/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.daemon.metrics.reporters;

import com.codahale.metrics.JmxReporter;
import com.codahale.metrics.MetricRegistry;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.storm.daemon.metrics.MetricsUtils;
import org.apache.storm.daemon.metrics.reporters.PreparableReporter;
import org.apache.storm.utils.ObjectReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JmxPreparableReporter
implements PreparableReporter<JmxReporter> {
    private static final Logger LOG = LoggerFactory.getLogger(JmxPreparableReporter.class);
    JmxReporter reporter = null;

    @Override
    public void prepare(MetricRegistry metricsRegistry, Map<String, Object> topoConf) {
        TimeUnit rateUnit;
        LOG.info("Preparing...");
        JmxReporter.Builder builder = JmxReporter.forRegistry((MetricRegistry)metricsRegistry);
        String domain = ObjectReader.getString((Object)topoConf.get("storm.daemon.metrics.reporter.plugin.domain"), null);
        if (domain != null) {
            builder.inDomain(domain);
        }
        if ((rateUnit = MetricsUtils.getMetricsRateUnit(topoConf)) != null) {
            builder.convertRatesTo(rateUnit);
        }
        this.reporter = builder.build();
    }

    @Override
    public void start() {
        if (this.reporter == null) {
            throw new IllegalStateException("Attempt to start without preparing " + this.getClass().getSimpleName());
        }
        LOG.debug("Starting...");
        this.reporter.start();
    }

    @Override
    public void stop() {
        if (this.reporter == null) {
            throw new IllegalStateException("Attempt to stop without preparing " + this.getClass().getSimpleName());
        }
        LOG.debug("Stopping...");
        this.reporter.stop();
    }
}

