/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.daemon.supervisor;

import java.io.IOException;
import java.util.Map;
import org.apache.storm.daemon.supervisor.Container;
import org.apache.storm.daemon.supervisor.ContainerLauncher;
import org.apache.storm.daemon.supervisor.ContainerRecoveryException;
import org.apache.storm.daemon.supervisor.Killable;
import org.apache.storm.daemon.supervisor.LocalContainer;
import org.apache.storm.generated.LocalAssignment;
import org.apache.storm.messaging.IContext;
import org.apache.storm.utils.LocalState;

public class LocalContainerLauncher
extends ContainerLauncher {
    private final Map<String, Object> _conf;
    private final String _supervisorId;
    private final IContext _sharedContext;

    public LocalContainerLauncher(Map<String, Object> conf, String supervisorId, IContext sharedContext) {
        this._conf = conf;
        this._supervisorId = supervisorId;
        this._sharedContext = sharedContext;
    }

    @Override
    public Container launchContainer(int port, LocalAssignment assignment, LocalState state) throws IOException {
        LocalContainer ret = new LocalContainer(this._conf, this._supervisorId, port, assignment, this._sharedContext);
        ret.setup();
        ret.launch();
        return ret;
    }

    @Override
    public Container recoverContainer(int port, LocalAssignment assignment, LocalState state) throws IOException {
        throw new ContainerRecoveryException("Local Mode Recovery is not supported");
    }

    @Override
    public Killable recoverContainer(String workerId, LocalState localState) throws IOException {
        throw new ContainerRecoveryException("Local Mode Recovery is not supported");
    }
}

