/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.daemon.supervisor;

import java.io.IOException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.storm.daemon.supervisor.ClientSupervisorUtils;
import org.apache.storm.generated.LSWorkerHeartbeat;
import org.apache.storm.localizer.LocalResource;
import org.apache.storm.localizer.Localizer;
import org.apache.storm.utils.ConfigUtils;
import org.apache.storm.utils.LocalState;
import org.apache.storm.utils.ObjectReader;
import org.apache.storm.utils.ServerUtils;
import org.apache.storm.utils.Utils;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.data.ACL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SupervisorUtils {
    private static final Logger LOG = LoggerFactory.getLogger(SupervisorUtils.class);
    private static final SupervisorUtils INSTANCE;
    private static SupervisorUtils _instance;

    public static void setInstance(SupervisorUtils u) {
        _instance = u;
    }

    public static void resetInstance() {
        _instance = INSTANCE;
    }

    public static void rmrAsUser(Map<String, Object> conf, String id, String path) throws IOException {
        String user = ServerUtils.getFileOwner(path);
        String logPreFix = "rmr " + id;
        ArrayList<String> commands = new ArrayList<String>();
        commands.add("rmr");
        commands.add(path);
        ClientSupervisorUtils.processLauncherAndWait(conf, (String)user, commands, null, (String)logPreFix);
        if (Utils.checkFileExists((String)path)) {
            throw new RuntimeException(path + " was not deleted.");
        }
    }

    public static Boolean shouldUncompressBlob(Map<String, Object> blobInfo) {
        return ObjectReader.getBoolean((Object)blobInfo.get("uncompress"), (boolean)false);
    }

    public static List<LocalResource> blobstoreMapToLocalresources(Map<String, Map<String, Object>> blobstoreMap) {
        ArrayList<LocalResource> localResourceList = new ArrayList<LocalResource>();
        if (blobstoreMap != null) {
            for (Map.Entry<String, Map<String, Object>> map : blobstoreMap.entrySet()) {
                LocalResource localResource = new LocalResource(map.getKey(), SupervisorUtils.shouldUncompressBlob(map.getValue()));
                localResourceList.add(localResource);
            }
        }
        return localResourceList;
    }

    static void addBlobReferences(Localizer localizer, String stormId, Map<String, Object> conf) throws IOException {
        Map topoConf = ConfigUtils.readSupervisorStormConf(conf, (String)stormId);
        Map blobstoreMap = (Map)topoConf.get("topology.blobstore.map");
        String user = (String)topoConf.get("topology.submitter.user");
        String topoName = (String)topoConf.get("topology.name");
        List<LocalResource> localresources = SupervisorUtils.blobstoreMapToLocalresources(blobstoreMap);
        if (blobstoreMap != null) {
            localizer.addReferences(localresources, user, topoName);
        }
    }

    public static Set<String> readDownloadedTopologyIds(Map<String, Object> conf) throws IOException {
        HashSet<String> stormIds = new HashSet<String>();
        String path = ConfigUtils.supervisorStormDistRoot(conf);
        Collection<String> rets = ServerUtils.readDirContents(path);
        for (String ret : rets) {
            stormIds.add(URLDecoder.decode(ret));
        }
        return stormIds;
    }

    public static Collection<String> supervisorWorkerIds(Map<String, Object> conf) {
        String workerRoot = ConfigUtils.workerRoot(conf);
        return ServerUtils.readDirContents(workerRoot);
    }

    public static Map<String, LSWorkerHeartbeat> readWorkerHeartbeats(Map<String, Object> conf) throws Exception {
        return _instance.readWorkerHeartbeatsImpl(conf);
    }

    public Map<String, LSWorkerHeartbeat> readWorkerHeartbeatsImpl(Map<String, Object> conf) throws Exception {
        HashMap<String, LSWorkerHeartbeat> workerHeartbeats = new HashMap<String, LSWorkerHeartbeat>();
        Collection<String> workerIds = SupervisorUtils.supervisorWorkerIds(conf);
        for (String workerId : workerIds) {
            LSWorkerHeartbeat whb = SupervisorUtils.readWorkerHeartbeat(conf, workerId);
            workerHeartbeats.put(workerId, whb);
        }
        return workerHeartbeats;
    }

    private static LSWorkerHeartbeat readWorkerHeartbeat(Map<String, Object> conf, String workerId) {
        return _instance.readWorkerHeartbeatImpl(conf, workerId);
    }

    protected LSWorkerHeartbeat readWorkerHeartbeatImpl(Map<String, Object> conf, String workerId) {
        try {
            LocalState localState = ConfigUtils.workerState(conf, (String)workerId);
            return localState.getWorkerHeartBeat();
        }
        catch (Exception e) {
            LOG.warn("Failed to read local heartbeat for workerId : {},Ignoring exception.", (Object)workerId, (Object)e);
            return null;
        }
    }

    public static boolean isWorkerHbTimedOut(int now, LSWorkerHeartbeat whb, Map<String, Object> conf) {
        return _instance.isWorkerHbTimedOutImpl(now, whb, conf);
    }

    private boolean isWorkerHbTimedOutImpl(int now, LSWorkerHeartbeat whb, Map<String, Object> conf) {
        return now - whb.get_time_secs() > ObjectReader.getInt((Object)conf.get("supervisor.worker.timeout.secs"));
    }

    static List<ACL> supervisorZkAcls() {
        ArrayList<ACL> acls = new ArrayList<ACL>();
        acls.add((ACL)ZooDefs.Ids.CREATOR_ALL_ACL.get(0));
        acls.add(new ACL(5, ZooDefs.Ids.ANYONE_ID_UNSAFE));
        return acls;
    }

    static {
        _instance = INSTANCE = new SupervisorUtils();
    }
}

