/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.daemon.supervisor.timer;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.storm.cluster.IStormClusterState;
import org.apache.storm.daemon.supervisor.Supervisor;
import org.apache.storm.generated.SupervisorInfo;
import org.apache.storm.utils.ObjectReader;
import org.apache.storm.utils.Time;

public class SupervisorHeartbeat
implements Runnable {
    private final IStormClusterState stormClusterState;
    private final String supervisorId;
    private final Map<String, Object> conf;
    private final Supervisor supervisor;

    public SupervisorHeartbeat(Map<String, Object> conf, Supervisor supervisor) {
        this.stormClusterState = supervisor.getStormClusterState();
        this.supervisorId = supervisor.getId();
        this.supervisor = supervisor;
        this.conf = conf;
    }

    private SupervisorInfo buildSupervisorInfo(Map<String, Object> conf, Supervisor supervisor) {
        SupervisorInfo supervisorInfo = new SupervisorInfo();
        supervisorInfo.set_time_secs((long)Time.currentTimeSecs());
        supervisorInfo.set_hostname(supervisor.getHostName());
        supervisorInfo.set_assignment_id(supervisor.getAssignmentId());
        ArrayList<Long> usedPorts = new ArrayList<Long>();
        usedPorts.addAll(supervisor.getCurrAssignment().get().keySet());
        supervisorInfo.set_used_ports(usedPorts);
        List metaDatas = (List)supervisor.getiSupervisor().getMetadata();
        ArrayList<Long> portList = new ArrayList<Long>();
        if (metaDatas != null) {
            for (Object data : metaDatas) {
                Integer port = ObjectReader.getInt(data);
                if (port == null) continue;
                portList.add(port.longValue());
            }
        }
        supervisorInfo.set_meta(portList);
        supervisorInfo.set_scheduler_meta((Map)conf.get("supervisor.scheduler.meta"));
        supervisorInfo.set_uptime_secs((long)supervisor.getUpTime().upTime());
        supervisorInfo.set_version(supervisor.getStormVersion());
        supervisorInfo.set_resources_map(this.mkSupervisorCapacities(conf));
        return supervisorInfo;
    }

    private Map<String, Double> mkSupervisorCapacities(Map<String, Object> conf) {
        HashMap<String, Double> ret = new HashMap<String, Double>();
        Double mem = ObjectReader.getDouble((Object)conf.get("supervisor.memory.capacity.mb"), (Double)4096.0);
        ret.put("supervisor.memory.capacity.mb", mem);
        Double cpu = ObjectReader.getDouble((Object)conf.get("supervisor.cpu.capacity"), (Double)400.0);
        ret.put("supervisor.cpu.capacity", cpu);
        return ret;
    }

    @Override
    public void run() {
        SupervisorInfo supervisorInfo = this.buildSupervisorInfo(this.conf, this.supervisor);
        this.stormClusterState.supervisorHeartbeat(this.supervisorId, supervisorInfo);
    }
}

