/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.daemon.supervisor.timer;

import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.storm.daemon.supervisor.Supervisor;
import org.apache.storm.daemon.supervisor.SupervisorUtils;
import org.apache.storm.generated.AuthorizationException;
import org.apache.storm.generated.KeyNotFoundException;
import org.apache.storm.generated.LocalAssignment;
import org.apache.storm.localizer.LocalResource;
import org.apache.storm.localizer.Localizer;
import org.apache.storm.utils.ConfigUtils;
import org.apache.storm.utils.NimbusLeaderNotFoundException;
import org.apache.storm.utils.Utils;
import org.apache.thrift.transport.TTransportException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpdateBlobs
implements Runnable {
    private static final Logger LOG = LoggerFactory.getLogger(UpdateBlobs.class);
    private Supervisor supervisor;

    public UpdateBlobs(Supervisor supervisor) {
        this.supervisor = supervisor;
    }

    @Override
    public void run() {
        try {
            Map<String, Object> conf = this.supervisor.getConf();
            Set<String> downloadedStormIds = SupervisorUtils.readDownloadedTopologyIds(conf);
            AtomicReference<Map<Long, LocalAssignment>> newAssignment = this.supervisor.getCurrAssignment();
            HashSet<String> assignedStormIds = new HashSet<String>();
            for (LocalAssignment localAssignment : newAssignment.get().values()) {
                assignedStormIds.add(localAssignment.get_topology_id());
            }
            for (String stormId : downloadedStormIds) {
                if (!assignedStormIds.contains(stormId)) continue;
                String stormRoot = ConfigUtils.supervisorStormDistRoot(conf, (String)stormId);
                LOG.debug("Checking Blob updates for storm topology id {} With target_dir: {}", (Object)stormId, (Object)stormRoot);
                this.updateBlobsForTopology(conf, stormId, this.supervisor.getLocalizer());
            }
        }
        catch (Exception e) {
            if (Utils.exceptionCauseIsInstanceOf(TTransportException.class, (Throwable)e)) {
                LOG.error("Network error while updating blobs, will retry again later", (Throwable)e);
            }
            if (Utils.exceptionCauseIsInstanceOf(NimbusLeaderNotFoundException.class, (Throwable)e)) {
                LOG.error("Nimbus unavailable to update blobs, will retry again later", (Throwable)e);
            }
            throw Utils.wrapInRuntime((Exception)e);
        }
    }

    private void updateBlobsForTopology(Map<String, Object> conf, String stormId, Localizer localizer) throws IOException {
        Map topoConf = ConfigUtils.readSupervisorStormConf(conf, (String)stormId);
        Map blobstoreMap = (Map)topoConf.get("topology.blobstore.map");
        String user = (String)topoConf.get("topology.submitter.user");
        List<LocalResource> localresources = SupervisorUtils.blobstoreMapToLocalresources(blobstoreMap);
        try {
            localizer.updateBlobs(localresources, user);
        }
        catch (AuthorizationException authExp) {
            LOG.error("AuthorizationException error", (Throwable)authExp);
        }
        catch (KeyNotFoundException knf) {
            LOG.error("KeyNotFoundException error", (Throwable)knf);
        }
    }
}

