/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.localizer;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.commons.io.FileUtils;
import org.apache.storm.localizer.LocalizedResource;
import org.apache.storm.localizer.LocalizedResourceSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalizedResourceRetentionSet {
    public static final Logger LOG = LoggerFactory.getLogger(LocalizedResourceRetentionSet.class);
    private long _delSize;
    private long _currentSize;
    private long _targetSize;
    private final SortedMap<LocalizedResource, LocalizedResourceSet> _noReferences;

    LocalizedResourceRetentionSet(long targetSize) {
        this(targetSize, new LRUComparator());
    }

    LocalizedResourceRetentionSet(long targetSize, Comparator<? super LocalizedResource> cmp) {
        this(targetSize, new TreeMap<LocalizedResource, LocalizedResourceSet>(cmp));
    }

    LocalizedResourceRetentionSet(long targetSize, SortedMap<LocalizedResource, LocalizedResourceSet> retain) {
        this._noReferences = retain;
        this._targetSize = targetSize;
    }

    protected int getSizeWithNoReferences() {
        return this._noReferences.size();
    }

    protected void addResourcesForSet(Iterator<LocalizedResource> setIter, LocalizedResourceSet set) {
        Iterator<LocalizedResource> iter = setIter;
        while (setIter.hasNext()) {
            LocalizedResource lrsrc = iter.next();
            this._currentSize += lrsrc.getSize();
            if (lrsrc.getRefCount() > 0) continue;
            LOG.debug("adding {} to be checked for cleaning", (Object)lrsrc.getKey());
            this._noReferences.put(lrsrc, set);
        }
    }

    public void addResources(LocalizedResourceSet set) {
        this.addResourcesForSet(set.getLocalFilesIterator(), set);
        this.addResourcesForSet(set.getLocalArchivesIterator(), set);
    }

    public void cleanup() {
        LOG.debug("cleanup target size: {} current size is: {}", (Object)this._targetSize, (Object)this._currentSize);
        Iterator<Map.Entry<LocalizedResource, LocalizedResourceSet>> i = this._noReferences.entrySet().iterator();
        while (this._currentSize - this._delSize > this._targetSize && i.hasNext()) {
            Map.Entry<LocalizedResource, LocalizedResourceSet> rsrc = i.next();
            LocalizedResource resource = rsrc.getKey();
            LocalizedResourceSet set = rsrc.getValue();
            if (resource == null || !set.remove(resource)) continue;
            if (this.deleteResource(resource)) {
                this._delSize += resource.getSize();
                LOG.info("deleting: " + resource.getFilePath() + " size of: " + resource.getSize());
                i.remove();
                continue;
            }
            set.add(resource.getKey(), resource, resource.isUncompressed());
        }
    }

    protected boolean deleteResource(LocalizedResource resource) {
        try {
            String fileWithVersion = resource.getFilePathWithVersion();
            String currentSymlinkName = resource.getCurrentSymlinkPath();
            String versionFile = resource.getVersionFilePath();
            File deletePath = new File(fileWithVersion);
            if (resource.isUncompressed()) {
                FileUtils.deleteDirectory((File)deletePath);
            } else {
                Files.delete(deletePath.toPath());
            }
            Files.delete(new File(currentSymlinkName).toPath());
            Files.delete(new File(versionFile).toPath());
            return true;
        }
        catch (IOException e) {
            LOG.warn("Could not delete: {}", (Object)resource.getFilePath());
            return false;
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Cache: ").append(this._currentSize).append(", ");
        sb.append("Deleted: ").append(this._delSize);
        return sb.toString();
    }

    static class LRUComparator
    implements Comparator<LocalizedResource> {
        LRUComparator() {
        }

        @Override
        public int compare(LocalizedResource r1, LocalizedResource r2) {
            long ret = r1.getLastAccessTime() - r2.getLastAccessTime();
            if (0L == ret) {
                return System.identityHashCode(r1) - System.identityHashCode(r2);
            }
            return ret > 0L ? 1 : -1;
        }
    }
}

