/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.localizer;

import java.util.Iterator;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.storm.localizer.LocalizedResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalizedResourceSet {
    public static final Logger LOG = LoggerFactory.getLogger(LocalizedResourceSet.class);
    private final ConcurrentMap<String, LocalizedResource> _localrsrcFiles = new ConcurrentHashMap<String, LocalizedResource>();
    private final ConcurrentMap<String, LocalizedResource> _localrsrcArchives = new ConcurrentHashMap<String, LocalizedResource>();
    private String _user;

    LocalizedResourceSet(String user) {
        this._user = user;
    }

    public String getUser() {
        return this._user;
    }

    public int getSize() {
        return this._localrsrcFiles.size() + this._localrsrcArchives.size();
    }

    public LocalizedResource get(String name, boolean uncompress) {
        if (uncompress) {
            return (LocalizedResource)this._localrsrcArchives.get(name);
        }
        return (LocalizedResource)this._localrsrcFiles.get(name);
    }

    public void putIfAbsent(String resourceName, LocalizedResource updatedResource, boolean uncompress) {
        if (uncompress) {
            this._localrsrcArchives.putIfAbsent(resourceName, updatedResource);
        } else {
            this._localrsrcFiles.putIfAbsent(resourceName, updatedResource);
        }
    }

    public void add(String resourceName, LocalizedResource newResource, boolean uncompress) {
        if (uncompress) {
            this._localrsrcArchives.put(resourceName, newResource);
        } else {
            this._localrsrcFiles.put(resourceName, newResource);
        }
    }

    public boolean exists(String resourceName, boolean uncompress) {
        if (uncompress) {
            return this._localrsrcArchives.containsKey(resourceName);
        }
        return this._localrsrcFiles.containsKey(resourceName);
    }

    public boolean remove(LocalizedResource resource) {
        LocalizedResource lrsrc = null;
        lrsrc = resource.isUncompressed() ? (LocalizedResource)this._localrsrcArchives.remove(resource.getKey()) : (LocalizedResource)this._localrsrcFiles.remove(resource.getKey());
        return lrsrc != null;
    }

    public Iterator<LocalizedResource> getLocalFilesIterator() {
        return this._localrsrcFiles.values().iterator();
    }

    public Iterator<LocalizedResource> getLocalArchivesIterator() {
        return this._localrsrcArchives.values().iterator();
    }
}

