/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.metric;

import com.codahale.metrics.Gauge;
import com.codahale.metrics.Histogram;
import com.codahale.metrics.Meter;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Reservoir;
import java.util.Map;
import java.util.concurrent.Callable;
import org.apache.storm.daemon.metrics.MetricsUtils;
import org.apache.storm.daemon.metrics.reporters.PreparableReporter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StormMetricsRegistry {
    private static final Logger LOG = LoggerFactory.getLogger(StormMetricsRegistry.class);
    public static final MetricRegistry DEFAULT_REGISTRY = new MetricRegistry();

    public static Meter registerMeter(String name) {
        Meter meter = new Meter();
        return StormMetricsRegistry.register(name, meter);
    }

    public static Gauge<Integer> registerGauge(final String name, final Callable fn) {
        Gauge<Integer> gauge = new Gauge<Integer>(){

            public Integer getValue() {
                try {
                    return (Integer)fn.call();
                }
                catch (Exception e) {
                    LOG.error("Error getting gauge value for {}", (Object)name, (Object)e);
                    return 0;
                }
            }
        };
        return StormMetricsRegistry.register(name, gauge);
    }

    public static Histogram registerHistogram(String name, Reservoir reservoir) {
        Histogram histogram = new Histogram(reservoir);
        return StormMetricsRegistry.register(name, histogram);
    }

    public static void startMetricsReporters(Map<String, Object> topoConf) {
        for (PreparableReporter reporter : MetricsUtils.getPreparableReporters(topoConf)) {
            StormMetricsRegistry.startMetricsReporter(reporter, topoConf);
        }
    }

    private static void startMetricsReporter(PreparableReporter reporter, Map<String, Object> topoConf) {
        reporter.prepare(DEFAULT_REGISTRY, topoConf);
        reporter.start();
        LOG.info("Started statistics report plugin...");
    }

    private static <T extends Metric> T register(String name, T metric) {
        Metric ret;
        try {
            ret = DEFAULT_REGISTRY.register(name, metric);
        }
        catch (IllegalArgumentException e) {
            ret = (Metric)DEFAULT_REGISTRY.getMetrics().get(name);
            if (ret == null) {
                throw e;
            }
            LOG.warn("Metric {} has already been registered", (Object)name);
        }
        return (T)ret;
    }
}

