/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.scheduler.multitenant;

import java.util.HashMap;
import java.util.Map;
import org.apache.storm.scheduler.Cluster;
import org.apache.storm.scheduler.IScheduler;
import org.apache.storm.scheduler.Topologies;
import org.apache.storm.scheduler.TopologyDetails;
import org.apache.storm.scheduler.multitenant.DefaultPool;
import org.apache.storm.scheduler.multitenant.FreePool;
import org.apache.storm.scheduler.multitenant.IsolatedPool;
import org.apache.storm.scheduler.multitenant.Node;
import org.apache.storm.scheduler.multitenant.NodePool;
import org.apache.storm.utils.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultitenantScheduler
implements IScheduler {
    private static final Logger LOG = LoggerFactory.getLogger(MultitenantScheduler.class);
    private Map _conf;

    public void prepare(Map<String, Object> conf) {
        this._conf = conf;
    }

    private Map<String, Number> getUserConf() {
        HashMap<String, Number> ret = (HashMap<String, Number>)this._conf.get("multitenant.scheduler.user.pools");
        ret = ret == null ? new HashMap<String, Number>() : new HashMap(ret);
        Map fromFile = Utils.findAndReadConfigFile((String)"multitenant-scheduler.yaml", (boolean)false);
        Map tmp = (Map)fromFile.get("multitenant.scheduler.user.pools");
        if (tmp != null) {
            ret.putAll(tmp);
        }
        return ret;
    }

    public void schedule(Topologies topologies, Cluster cluster) {
        LOG.debug("Rerunning scheduling...");
        Map<String, Node> nodeIdToNode = Node.getAllNodesFrom(cluster);
        Map<String, Number> userConf = this.getUserConf();
        HashMap<String, IsolatedPool> userPools = new HashMap<String, IsolatedPool>();
        for (Map.Entry<String, Number> entry : userConf.entrySet()) {
            userPools.put(entry.getKey(), new IsolatedPool(entry.getValue().intValue()));
        }
        DefaultPool defaultPool = new DefaultPool();
        FreePool freePool = new FreePool();
        freePool.init(cluster, nodeIdToNode);
        for (IsolatedPool pool : userPools.values()) {
            pool.init(cluster, nodeIdToNode);
        }
        defaultPool.init(cluster, nodeIdToNode);
        for (TopologyDetails td : topologies.getTopologies()) {
            String user = (String)td.getConf().get("topology.submitter.user");
            LOG.debug("Found top {} run by user {}", (Object)td.getId(), (Object)user);
            NodePool pool = (NodePool)userPools.get(user);
            if (pool == null || !pool.canAdd(td)) {
                pool = defaultPool;
            }
            pool.addTopology(td);
        }
        for (IsolatedPool pool : userPools.values()) {
            pool.scheduleAsNeeded(freePool, defaultPool);
        }
        defaultPool.scheduleAsNeeded(freePool);
        LOG.debug("Scheduling done...");
    }
}

