/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.utils;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.RandomAccessFile;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.GZIPInputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.exec.CommandLine;
import org.apache.commons.exec.DefaultExecutor;
import org.apache.commons.exec.ExecuteException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.storm.blobstore.BlobStore;
import org.apache.storm.blobstore.ClientBlobStore;
import org.apache.storm.blobstore.InputStreamWithMeta;
import org.apache.storm.blobstore.LocalFsBlobStore;
import org.apache.storm.generated.AccessControl;
import org.apache.storm.generated.AccessControlType;
import org.apache.storm.generated.AuthorizationException;
import org.apache.storm.generated.KeyNotFoundException;
import org.apache.storm.generated.ReadableBlobMeta;
import org.apache.storm.generated.SettableBlobMeta;
import org.apache.storm.localizer.Localizer;
import org.apache.storm.nimbus.NimbusInfo;
import org.apache.storm.utils.ReflectionUtils;
import org.apache.storm.utils.ShellUtils;
import org.apache.storm.utils.Utils;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerUtils {
    public static final Logger LOG = LoggerFactory.getLogger(ServerUtils.class);
    public static final String FILE_PATH_SEPARATOR = System.getProperty("file.separator");
    public static final String CLASS_PATH_SEPARATOR = System.getProperty("path.separator");
    public static final boolean IS_ON_WINDOWS = "Windows_NT".equals(System.getenv("OS"));
    public static final String DEFAULT_BLOB_VERSION_SUFFIX = ".version";
    public static final String CURRENT_BLOB_SUFFIX_ID = "current";
    public static final String DEFAULT_CURRENT_BLOB_SUFFIX = ".current";
    public static final int SIGKILL = 9;
    public static final int SIGTERM = 15;
    private static final Set<String> disallowedKeys = new HashSet<String>(Arrays.asList("/", ".", ":", "\\"));
    private static ServerUtils _instance = new ServerUtils();

    public static ServerUtils setInstance(ServerUtils u) {
        ServerUtils oldInstance = _instance;
        _instance = u;
        return oldInstance;
    }

    public static <T> List<T> interleaveAll(List<List<T>> nodeList) {
        if (nodeList != null && nodeList.size() > 0) {
            ArrayList<T> first = new ArrayList<T>();
            ArrayList<List<T>> rest = new ArrayList<List<T>>();
            for (List<T> node : nodeList) {
                if (node == null || node.size() <= 0) continue;
                first.add(node.get(0));
                rest.add(node.subList(1, node.size()));
            }
            List<T> interleaveRest = ServerUtils.interleaveAll(rest);
            if (interleaveRest != null) {
                first.addAll(interleaveRest);
            }
            return first;
        }
        return null;
    }

    public static BlobStore getNimbusBlobStore(Map<String, Object> conf, NimbusInfo nimbusInfo) {
        return ServerUtils.getNimbusBlobStore(conf, null, nimbusInfo);
    }

    public static BlobStore getNimbusBlobStore(Map<String, Object> conf, String baseDir, NimbusInfo nimbusInfo) {
        String type = (String)conf.get("nimbus.blobstore.class");
        if (type == null) {
            type = LocalFsBlobStore.class.getName();
        }
        BlobStore store = (BlobStore)ReflectionUtils.newInstance((String)type);
        HashMap<String, Object> nconf = new HashMap<String, Object>(conf);
        nconf.put("blobstore.cleanup.enable", Boolean.TRUE);
        if (store != null) {
            store.prepare(nconf, baseDir, nimbusInfo);
        }
        return store;
    }

    public static boolean isAbsolutePath(String path) {
        return Paths.get(path, new String[0]).isAbsolute();
    }

    public static String shellCmd(List<String> command) {
        ArrayList<String> changedCommands = new ArrayList<String>(command.size());
        for (String str : command) {
            if (str == null) continue;
            changedCommands.add("'" + str.replaceAll("'", "'\"'\"'") + "'");
        }
        return StringUtils.join(changedCommands, (String)" ");
    }

    public static String constructVersionFileName(String fileName) {
        return fileName + DEFAULT_BLOB_VERSION_SUFFIX;
    }

    public static String constructBlobCurrentSymlinkName(String fileName) {
        return fileName + DEFAULT_CURRENT_BLOB_SUFFIX;
    }

    public static long getDU(File dir) {
        long size = 0L;
        if (!dir.exists()) {
            return 0L;
        }
        if (!dir.isDirectory()) {
            return dir.length();
        }
        File[] allFiles = dir.listFiles();
        if (allFiles != null) {
            for (int i = 0; i < allFiles.length; ++i) {
                boolean isSymLink;
                try {
                    isSymLink = FileUtils.isSymlink((File)allFiles[i]);
                }
                catch (IOException ioe) {
                    isSymLink = true;
                }
                if (isSymLink) continue;
                size += ServerUtils.getDU(allFiles[i]);
            }
        }
        return size;
    }

    public static long localVersionOfBlob(String localFile) {
        File f = new File(localFile + DEFAULT_BLOB_VERSION_SUFFIX);
        long currentVersion = 0L;
        if (f.exists() && !f.isDirectory()) {
            BufferedReader br = null;
            try {
                br = new BufferedReader(new FileReader(f));
                String line = br.readLine();
                currentVersion = Long.parseLong(line);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            finally {
                try {
                    if (br != null) {
                        br.close();
                    }
                }
                catch (Exception ignore) {
                    LOG.error("Exception trying to cleanup", (Throwable)ignore);
                }
            }
            return currentVersion;
        }
        return -1L;
    }

    public static String constructBlobWithVersionFileName(String fileName, long version) {
        return fileName + "." + version;
    }

    public static ClientBlobStore getClientBlobStoreForSupervisor(Map<String, Object> conf) {
        ClientBlobStore store = (ClientBlobStore)ReflectionUtils.newInstance((String)((String)conf.get("supervisor.blobstore.class")));
        store.prepare(conf);
        return store;
    }

    public static void downloadResourcesAsSupervisor(String key, String localFile, ClientBlobStore cb) throws AuthorizationException, KeyNotFoundException, IOException {
        _instance.downloadResourcesAsSupervisorImpl(key, localFile, cb);
    }

    public static void extractDirFromJar(String jarpath, String dir, File destdir) {
        _instance.extractDirFromJarImpl(jarpath, dir, destdir);
    }

    public static String currentClasspath() {
        return _instance.currentClasspathImpl();
    }

    public static boolean zipDoesContainDir(String zipfile, String target) throws IOException {
        ArrayList<? extends ZipEntry> entries = Collections.list(new ZipFile(zipfile).entries());
        String targetDir = target + "/";
        for (ZipEntry zipEntry : entries) {
            String name = zipEntry.getName();
            if (!name.startsWith(targetDir)) continue;
            return true;
        }
        return false;
    }

    public static String getFileOwner(String path) throws IOException {
        return Files.getOwner(FileSystems.getDefault().getPath(path, new String[0]), new LinkOption[0]).getName();
    }

    public static Collection<String> readDirContents(String dir) {
        HashSet<String> ret = new HashSet<String>();
        File[] files = new File(dir).listFiles();
        if (files != null) {
            for (File f : files) {
                ret.add(f.getName());
            }
        }
        return ret;
    }

    public static Localizer createLocalizer(Map<String, Object> conf, String baseDir) {
        return new Localizer(conf, baseDir);
    }

    public static String containerFilePath(String dir) {
        return dir + FILE_PATH_SEPARATOR + "launch_container.sh";
    }

    public static String scriptFilePath(String dir) {
        return dir + FILE_PATH_SEPARATOR + "storm-worker-script.sh";
    }

    public static String writeScript(String dir, List<String> command, Map<String, String> environment) throws IOException {
        String path = ServerUtils.scriptFilePath(dir);
        try (BufferedWriter out = new BufferedWriter(new FileWriter(path));){
            out.write("#!/bin/bash");
            out.newLine();
            if (environment != null) {
                for (String k : environment.keySet()) {
                    String v = environment.get(k);
                    if (v == null) {
                        v = "";
                    }
                    out.write(ServerUtils.shellCmd(Arrays.asList("export", k + "=" + v)));
                    out.write(";");
                    out.newLine();
                }
            }
            out.newLine();
            out.write("exec " + ServerUtils.shellCmd(command) + ";");
        }
        return path;
    }

    public static int execCommand(String ... command) throws ExecuteException, IOException {
        CommandLine cmd = new CommandLine(command[0]);
        for (int i = 1; i < command.length; ++i) {
            cmd.addArgument(command[i]);
        }
        DefaultExecutor exec = new DefaultExecutor();
        return exec.execute(cmd);
    }

    public static void sendSignalToProcess(long lpid, int signum) throws IOException {
        String pid = Long.toString(lpid);
        try {
            if (Utils.isOnWindows()) {
                if (signum == 9) {
                    ServerUtils.execCommand("taskkill", "/f", "/pid", pid);
                } else {
                    ServerUtils.execCommand("taskkill", "/pid", pid);
                }
            } else {
                ServerUtils.execCommand("kill", "-" + signum, pid);
            }
        }
        catch (ExecuteException e) {
            LOG.info("Error when trying to kill {}. Process is probably already dead.", (Object)pid);
        }
        catch (IOException e) {
            LOG.info("IOException Error when trying to kill {}.", (Object)pid);
            throw e;
        }
    }

    public static void killProcessWithSigTerm(String pid) throws IOException {
        ServerUtils.sendSignalToProcess(Long.parseLong(pid), 15);
    }

    public static void forceKillProcess(String pid) throws IOException {
        ServerUtils.sendSignalToProcess(Long.parseLong(pid), 9);
    }

    public static long nimbusVersionOfBlob(String key, ClientBlobStore cb) throws AuthorizationException, KeyNotFoundException {
        long nimbusBlobVersion = 0L;
        ReadableBlobMeta metadata = cb.getBlobMeta(key);
        nimbusBlobVersion = metadata.get_version();
        return nimbusBlobVersion;
    }

    public static boolean canUserReadBlob(ReadableBlobMeta meta, String user) {
        SettableBlobMeta settable = meta.get_settable();
        for (AccessControl acl : settable.get_acl()) {
            if (acl.get_type().equals((Object)AccessControlType.OTHER) && (acl.get_access() & 1) > 0) {
                return true;
            }
            if (!acl.get_name().equals(user) || (acl.get_access() & 1) <= 0) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unJar(File jarFile, File toDir) throws IOException {
        try (JarFile jar = new JarFile(jarFile);){
            Enumeration<JarEntry> entries = jar.entries();
            while (entries.hasMoreElements()) {
                JarEntry entry = entries.nextElement();
                if (entry.isDirectory()) continue;
                try (InputStream in = jar.getInputStream(entry);){
                    File file = new File(toDir, entry.getName());
                    ServerUtils.ensureDirectory(file.getParentFile());
                    try (FileOutputStream out = new FileOutputStream(file);){
                        ServerUtils.copyBytes(in, out, 8192);
                    }
                }
            }
        }
    }

    public static void copyBytes(InputStream in, OutputStream out, int buffSize) throws IOException {
        PrintStream ps = out instanceof PrintStream ? (PrintStream)out : null;
        byte[] buf = new byte[buffSize];
        int bytesRead = in.read(buf);
        while (bytesRead >= 0) {
            out.write(buf, 0, bytesRead);
            if (ps != null && ps.checkError()) {
                throw new IOException("Unable to write to output stream.");
            }
            bytesRead = in.read(buf);
        }
    }

    private static void ensureDirectory(File dir) throws IOException {
        if (!dir.mkdirs() && !dir.isDirectory()) {
            throw new IOException("Mkdirs failed to create " + dir.toString());
        }
    }

    public static void unTar(File inFile, File untarDir) throws IOException {
        if (!untarDir.mkdirs() && !untarDir.isDirectory()) {
            throw new IOException("Mkdirs failed to create " + untarDir);
        }
        boolean gzipped = inFile.toString().endsWith("gz");
        if (Utils.isOnWindows()) {
            ServerUtils.unTarUsingJava(inFile, untarDir, gzipped);
        } else {
            ServerUtils.unTarUsingTar(inFile, untarDir, gzipped);
        }
    }

    private static void unTarUsingTar(File inFile, File untarDir, boolean gzipped) throws IOException {
        StringBuffer untarCommand = new StringBuffer();
        if (gzipped) {
            untarCommand.append(" gzip -dc '");
            untarCommand.append(inFile.toString());
            untarCommand.append("' | (");
        }
        untarCommand.append("cd '");
        untarCommand.append(untarDir.toString());
        untarCommand.append("' ; ");
        untarCommand.append("tar -xf ");
        if (gzipped) {
            untarCommand.append(" -)");
        } else {
            untarCommand.append(inFile.toString());
        }
        String[] shellCmd = new String[]{"bash", "-c", untarCommand.toString()};
        ShellUtils.ShellCommandExecutor shexec = new ShellUtils.ShellCommandExecutor(shellCmd);
        shexec.execute();
        int exitcode = shexec.getExitCode();
        if (exitcode != 0) {
            throw new IOException("Error untarring file " + inFile + ". Tar process exited with exit code " + exitcode);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void unTarUsingJava(File inFile, File untarDir, boolean gzipped) throws IOException {
        try (InputStream inputStream = null;){
            inputStream = gzipped ? new BufferedInputStream(new GZIPInputStream(new FileInputStream(inFile))) : new BufferedInputStream(new FileInputStream(inFile));
            try (TarArchiveInputStream tis = new TarArchiveInputStream(inputStream);){
                TarArchiveEntry entry = tis.getNextTarEntry();
                while (entry != null) {
                    ServerUtils.unpackEntries(tis, entry, untarDir);
                    entry = tis.getNextTarEntry();
                }
            }
        }
    }

    private static void unpackEntries(TarArchiveInputStream tis, TarArchiveEntry entry, File outputDir) throws IOException {
        int count;
        if (entry.isDirectory()) {
            File subDir = new File(outputDir, entry.getName());
            if (!subDir.mkdirs() && !subDir.isDirectory()) {
                throw new IOException("Mkdirs failed to create tar internal dir " + outputDir);
            }
            for (TarArchiveEntry e : entry.getDirectoryEntries()) {
                ServerUtils.unpackEntries(tis, e, subDir);
            }
            return;
        }
        File outputFile = new File(outputDir, entry.getName());
        if (!outputFile.getParentFile().exists() && !outputFile.getParentFile().mkdirs()) {
            throw new IOException("Mkdirs failed to create tar internal dir " + outputDir);
        }
        byte[] data = new byte[2048];
        BufferedOutputStream outputStream = new BufferedOutputStream(new FileOutputStream(outputFile));
        while ((count = tis.read(data)) != -1) {
            outputStream.write(data, 0, count);
        }
        outputStream.flush();
        outputStream.close();
    }

    public static void unpack(File localrsrc, File dst) throws IOException {
        String lowerDst = localrsrc.getName().toLowerCase();
        if (lowerDst.endsWith(".jar")) {
            ServerUtils.unJar(localrsrc, dst);
        } else if (lowerDst.endsWith(".zip")) {
            ServerUtils.unZip(localrsrc, dst);
        } else if (lowerDst.endsWith(".tar.gz") || lowerDst.endsWith(".tgz") || lowerDst.endsWith(".tar")) {
            ServerUtils.unTar(localrsrc, dst);
        } else {
            LOG.warn("Cannot unpack " + localrsrc);
            if (!localrsrc.renameTo(dst)) {
                throw new IOException("Unable to rename file: [" + localrsrc + "] to [" + dst + "]");
            }
        }
        if (localrsrc.isFile()) {
            localrsrc.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unZip(File inFile, File unzipDir) throws IOException {
        try (ZipFile zipFile = new ZipFile(inFile);){
            Enumeration<? extends ZipEntry> entries = zipFile.entries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                if (entry.isDirectory()) continue;
                try (InputStream in = zipFile.getInputStream(entry);){
                    File file = new File(unzipDir, entry.getName());
                    if (!file.getParentFile().mkdirs() && !file.getParentFile().isDirectory()) {
                        throw new IOException("Mkdirs failed to create " + file.getParentFile().toString());
                    }
                    try (FileOutputStream out = new FileOutputStream(file);){
                        int i;
                        byte[] buffer = new byte[8192];
                        while ((i = in.read(buffer)) != -1) {
                            ((OutputStream)out).write(buffer, 0, i);
                        }
                    }
                }
            }
        }
    }

    public static void validateKeyName(String name) {
        for (String key : disallowedKeys) {
            if (!name.contains(key)) continue;
            throw new RuntimeException("Key name cannot contain any of the following: " + disallowedKeys.toString());
        }
        if (name.trim().isEmpty()) {
            throw new RuntimeException("Key name cannot be blank");
        }
    }

    public static long zipFileSize(File myFile) throws IOException {
        RandomAccessFile raf = new RandomAccessFile(myFile, "r");
        raf.seek(raf.length() - 4L);
        long b4 = raf.read();
        long b3 = raf.read();
        long b2 = raf.read();
        long b1 = raf.read();
        long val = b1 << 24 | (b2 << 16) + (b3 << 8) + b4;
        raf.close();
        return val;
    }

    public String currentClasspathImpl() {
        return System.getProperty("java.class.path");
    }

    public void extractDirFromJarImpl(String jarpath, String dir, File destdir) {
        try (JarFile jarFile = new JarFile(jarpath);){
            Enumeration<JarEntry> jarEnums = jarFile.entries();
            while (jarEnums.hasMoreElements()) {
                JarEntry entry = jarEnums.nextElement();
                if (entry.isDirectory() || !entry.getName().startsWith(dir)) continue;
                File aFile = new File(destdir, entry.getName());
                aFile.getParentFile().mkdirs();
                FileOutputStream out = new FileOutputStream(aFile);
                Throwable throwable = null;
                try {
                    InputStream in = jarFile.getInputStream(entry);
                    Throwable throwable2 = null;
                    try {
                        IOUtils.copy((InputStream)in, (OutputStream)out);
                    }
                    catch (Throwable throwable3) {
                        throwable2 = throwable3;
                        throw throwable3;
                    }
                    finally {
                        if (in == null) continue;
                        if (throwable2 != null) {
                            try {
                                in.close();
                            }
                            catch (Throwable throwable4) {
                                throwable2.addSuppressed(throwable4);
                            }
                            continue;
                        }
                        in.close();
                    }
                }
                catch (Throwable throwable5) {
                    throwable = throwable5;
                    throw throwable5;
                }
                finally {
                    if (out == null) continue;
                    if (throwable != null) {
                        try {
                            out.close();
                        }
                        catch (Throwable throwable6) {
                            throwable.addSuppressed(throwable6);
                        }
                        continue;
                    }
                    out.close();
                }
            }
        }
        catch (IOException e) {
            LOG.info("Could not extract {} from {}", (Object)dir, (Object)jarpath);
        }
    }

    public void downloadResourcesAsSupervisorImpl(String key, String localFile, ClientBlobStore cb) throws AuthorizationException, KeyNotFoundException, IOException {
        int MAX_RETRY_ATTEMPTS = 2;
        int ATTEMPTS_INTERVAL_TIME = 100;
        for (int retryAttempts = 0; retryAttempts < 2 && !ServerUtils.downloadResourcesAsSupervisorAttempt(cb, key, localFile); ++retryAttempts) {
            Utils.sleep((long)100L);
        }
    }

    private static boolean downloadResourcesAsSupervisorAttempt(ClientBlobStore cb, String key, String localFile) {
        boolean isSuccess = false;
        try (FileOutputStream out = new FileOutputStream(localFile);
             InputStreamWithMeta in = cb.getBlob(key);){
            int len;
            long fileSize = in.getFileLength();
            byte[] buffer = new byte[1024];
            int downloadFileSize = 0;
            while ((len = in.read(buffer)) >= 0) {
                out.write(buffer, 0, len);
                downloadFileSize += len;
            }
            isSuccess = fileSize == (long)downloadFileSize;
        }
        catch (IOException | TException e) {
            LOG.error("An exception happened while downloading {} from blob store.", (Object)localFile, (Object)e);
        }
        if (!isSuccess) {
            try {
                Files.deleteIfExists(Paths.get(localFile, new String[0]));
            }
            catch (IOException ex) {
                LOG.error("Failed trying to delete the partially downloaded {}", (Object)localFile, (Object)ex);
            }
        }
        return isSuccess;
    }
}

