/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts2.convention;

import java.io.IOException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.struts2.StrutsException;
import org.apache.struts2.convention.ActionConfigBuilder;
import org.apache.struts2.convention.ActionNameBuilder;
import org.apache.struts2.convention.InterceptorMapBuilder;
import org.apache.struts2.convention.ReflectionTools;
import org.apache.struts2.convention.ResultMapBuilder;
import org.apache.struts2.convention.StringTools;
import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.Actions;
import org.apache.struts2.convention.annotation.AnnotationTools;
import org.apache.struts2.convention.annotation.DefaultInterceptorRef;
import org.apache.struts2.convention.annotation.ExceptionMapping;
import org.apache.struts2.convention.annotation.ExceptionMappings;
import org.apache.struts2.convention.annotation.Namespace;
import org.apache.struts2.convention.annotation.Namespaces;
import org.apache.struts2.convention.annotation.ParentPackage;
import org.apache.struts2.xwork2.ActionContext;
import org.apache.struts2.xwork2.ObjectFactory;
import org.apache.struts2.xwork2.config.Configuration;
import org.apache.struts2.xwork2.config.ConfigurationException;
import org.apache.struts2.xwork2.config.entities.ActionConfig;
import org.apache.struts2.xwork2.config.entities.ExceptionMappingConfig;
import org.apache.struts2.xwork2.config.entities.InterceptorMapping;
import org.apache.struts2.xwork2.config.entities.PackageConfig;
import org.apache.struts2.xwork2.config.entities.ResultConfig;
import org.apache.struts2.xwork2.inject.Container;
import org.apache.struts2.xwork2.inject.Inject;
import org.apache.struts2.xwork2.util.FileManager;
import org.apache.struts2.xwork2.util.TextParseUtil;
import org.apache.struts2.xwork2.util.classloader.ReloadingClassLoader;
import org.apache.struts2.xwork2.util.finder.ClassFinder;
import org.apache.struts2.xwork2.util.finder.ClassLoaderInterface;
import org.apache.struts2.xwork2.util.finder.ClassLoaderInterfaceDelegate;
import org.apache.struts2.xwork2.util.finder.Test;
import org.apache.struts2.xwork2.util.finder.UrlSet;
import org.apache.struts2.xwork2.util.logging.Logger;
import org.apache.struts2.xwork2.util.logging.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PackageBasedActionConfigBuilder
implements ActionConfigBuilder {
    private static final Logger LOG = LoggerFactory.getLogger(PackageBasedActionConfigBuilder.class);
    private final Configuration configuration;
    private final ActionNameBuilder actionNameBuilder;
    private final ResultMapBuilder resultMapBuilder;
    private final InterceptorMapBuilder interceptorMapBuilder;
    private final ObjectFactory objectFactory;
    private final String defaultParentPackage;
    private final boolean redirectToSlash;
    private String[] actionPackages;
    private String[] excludePackages;
    private String[] packageLocators;
    private String[] includeJars;
    private String packageLocatorsBasePackage;
    private boolean disableActionScanning = false;
    private boolean disablePackageLocatorsScanning = false;
    private String actionSuffix = "Action";
    private boolean checkImplementsAction = true;
    private boolean mapAllMatches = false;
    private Set<String> loadedFileUrls = new HashSet<String>();
    private boolean devMode;
    private ReloadingClassLoader reloadingClassLoader;
    private boolean reload;
    private Set<String> fileProtocols;
    private boolean alwaysMapExecute;
    private boolean excludeParentClassLoader;
    private boolean slashesInActionNames;
    private static final String DEFAULT_METHOD = "execute";
    private boolean eagerLoading = false;

    @Inject
    public PackageBasedActionConfigBuilder(Configuration configuration, Container container, ObjectFactory objectFactory, @Inject(value="struts.convention.redirect.to.slash") String redirectToSlash, @Inject(value="struts.convention.default.parent.package") String defaultParentPackage) {
        this.configuration = configuration;
        this.actionNameBuilder = (ActionNameBuilder)container.getInstance(ActionNameBuilder.class, (String)container.getInstance(String.class, "struts.convention.actionNameBuilder"));
        this.resultMapBuilder = (ResultMapBuilder)container.getInstance(ResultMapBuilder.class, (String)container.getInstance(String.class, "struts.convention.resultMapBuilder"));
        this.interceptorMapBuilder = (InterceptorMapBuilder)container.getInstance(InterceptorMapBuilder.class, (String)container.getInstance(String.class, "struts.convention.interceptorMapBuilder"));
        this.objectFactory = objectFactory;
        this.redirectToSlash = Boolean.parseBoolean(redirectToSlash);
        if (LOG.isTraceEnabled()) {
            LOG.trace("Setting action default parent package to [#0]", new String[]{defaultParentPackage});
        }
        this.defaultParentPackage = defaultParentPackage;
    }

    @Inject(value="struts.devMode")
    public void setDevMode(String mode) {
        this.devMode = "true".equals(mode);
    }

    @Inject(value="struts.convention.classes.reload")
    public void setReload(String reload) {
        this.reload = "true".equals(reload);
    }

    @Inject(value="struts.enable.SlashesInActionNames")
    public void setSlashesInActionNames(String slashesInActionNames) {
        this.slashesInActionNames = "true".equals(slashesInActionNames);
    }

    @Inject(value="struts.convention.exclude.parentClassLoader")
    public void setExcludeParentClassLoader(String exclude) {
        this.excludeParentClassLoader = "true".equals(exclude);
    }

    @Inject(value="struts.convention.action.alwaysMapExecute")
    public void setAlwaysMapExecute(String alwaysMapExecute) {
        this.alwaysMapExecute = "true".equals(alwaysMapExecute);
    }

    @Inject(value="struts.convention.action.fileProtocols")
    public void setFileProtocols(String fileProtocols) {
        if (StringUtils.isNotBlank((String)fileProtocols)) {
            this.fileProtocols = TextParseUtil.commaDelimitedStringToSet((String)fileProtocols);
        }
    }

    @Inject(value="struts.convention.action.disableScanning", required=false)
    public void setDisableActionScanning(String disableActionScanning) {
        this.disableActionScanning = "true".equals(disableActionScanning);
    }

    @Inject(value="struts.convention.action.includeJars", required=false)
    public void setIncludeJars(String includeJars) {
        if (StringUtils.isNotEmpty((String)includeJars)) {
            this.includeJars = includeJars.split("\\s*[,]\\s*");
        }
    }

    @Inject(value="struts.convention.package.locators.disable", required=false)
    public void setDisablePackageLocatorsScanning(String disablePackageLocatorsScanning) {
        this.disablePackageLocatorsScanning = "true".equals(disablePackageLocatorsScanning);
    }

    @Inject(value="struts.convention.action.packages", required=false)
    public void setActionPackages(String actionPackages) {
        if (StringUtils.isNotBlank((String)actionPackages)) {
            this.actionPackages = actionPackages.split("\\s*[,]\\s*");
        }
    }

    @Inject(value="struts.convention.action.checkImplementsAction", required=false)
    public void setCheckImplementsAction(String checkImplementsAction) {
        this.checkImplementsAction = "true".equals(checkImplementsAction);
    }

    @Inject(value="struts.convention.action.suffix", required=false)
    public void setActionSuffix(String actionSuffix) {
        if (StringUtils.isNotBlank((String)actionSuffix)) {
            this.actionSuffix = actionSuffix;
        }
    }

    @Inject(value="struts.convention.exclude.packages", required=false)
    public void setExcludePackages(String excludePackages) {
        if (StringUtils.isNotBlank((String)excludePackages)) {
            this.excludePackages = excludePackages.split("\\s*[,]\\s*");
        }
    }

    @Inject(value="struts.convention.package.locators", required=false)
    public void setPackageLocators(String packageLocators) {
        this.packageLocators = packageLocators.split("\\s*[,]\\s*");
    }

    @Inject(value="struts.convention.package.locators.basePackage", required=false)
    public void setPackageLocatorsBase(String packageLocatorsBasePackage) {
        this.packageLocatorsBasePackage = packageLocatorsBasePackage;
    }

    @Inject(value="struts.convention.action.mapAllMatches", required=false)
    public void setMapAllMatches(String mapAllMatches) {
        this.mapAllMatches = "true".equals(mapAllMatches);
    }

    @Inject(value="struts.convention.action.eagerLoading", required=false)
    public void setEagerLoading(String eagerLoading) {
        this.eagerLoading = "true".equals(eagerLoading);
    }

    protected void initReloadClassLoader() {
        if (this.isReloadEnabled() && this.reloadingClassLoader == null) {
            this.reloadingClassLoader = new ReloadingClassLoader(this.getClassLoader());
        }
    }

    protected ClassLoader getClassLoader() {
        return Thread.currentThread().getContextClassLoader();
    }

    @Override
    public void buildActionConfigs() {
        this.initReloadClassLoader();
        if (!this.disableActionScanning) {
            if (this.actionPackages == null && this.packageLocators == null) {
                throw new ConfigurationException("At least a list of action packages or action package locators must be given using one of the properties [struts.convention.action.packages] or [struts.convention.package.locators]");
            }
            if (LOG.isTraceEnabled()) {
                LOG.trace("Loading action configurations", new String[0]);
                if (this.actionPackages != null) {
                    LOG.trace("Actions being loaded from action packages " + Arrays.asList(this.actionPackages), new String[0]);
                }
                if (this.packageLocators != null) {
                    LOG.trace("Actions being loaded using package locators " + Arrays.asList(this.packageLocators), new String[0]);
                }
                if (this.excludePackages != null) {
                    LOG.trace("Excluding actions from packages " + Arrays.asList(this.excludePackages), new String[0]);
                }
            }
            Set<Class> classes = this.findActions();
            this.buildConfiguration(classes);
        }
    }

    protected ClassLoaderInterface getClassLoaderInterface() {
        if (this.isReloadEnabled()) {
            return new ClassLoaderInterfaceDelegate((ClassLoader)this.reloadingClassLoader);
        }
        ClassLoaderInterface classLoaderInterface = null;
        ActionContext ctx = ActionContext.getContext();
        if (ctx != null) {
            classLoaderInterface = (ClassLoaderInterface)ctx.get("__current_class_loader_interface");
        }
        return (ClassLoaderInterface)ObjectUtils.defaultIfNull((Object)classLoaderInterface, (Object)new ClassLoaderInterfaceDelegate(this.getClassLoader()));
    }

    protected boolean isReloadEnabled() {
        return this.devMode && this.reload;
    }

    protected Set<Class> findActions() {
        HashSet<Class> classes;
        block3: {
            classes = new HashSet<Class>();
            try {
                if (this.actionPackages != null || this.packageLocators != null && !this.disablePackageLocatorsScanning) {
                    Test<String> classPackageTest = this.getClassPackageTest();
                    ClassFinder finder = new ClassFinder(this.getClassLoaderInterface(), (Collection)this.buildUrlSet().getUrls(), true, this.fileProtocols, classPackageTest);
                    Test<ClassFinder.ClassInfo> test = this.getActionClassTest();
                    classes.addAll(finder.findClasses(test));
                }
            }
            catch (Exception ex) {
                if (!LOG.isErrorEnabled()) break block3;
                LOG.error("Unable to scan named packages", (Throwable)ex, new String[0]);
            }
        }
        return classes;
    }

    private UrlSet buildUrlSet() throws IOException {
        UrlSet urlSet;
        block14: {
            ClassLoaderInterface classLoaderInterface;
            block13: {
                classLoaderInterface = this.getClassLoaderInterface();
                urlSet = new UrlSet(classLoaderInterface, this.fileProtocols);
                if (this.excludeParentClassLoader) {
                    ClassLoaderInterface parent = classLoaderInterface.getParent();
                    if (parent != null && this.isReloadEnabled()) {
                        parent = parent.getParent();
                    }
                    if (parent != null) {
                        urlSet = urlSet.exclude(parent);
                    }
                    try {
                        ClassLoader systemClassLoader = ClassLoader.getSystemClassLoader();
                        urlSet = urlSet.exclude((ClassLoaderInterface)new ClassLoaderInterfaceDelegate(systemClassLoader.getParent()));
                    }
                    catch (SecurityException e) {
                        if (!LOG.isWarnEnabled()) break block13;
                        LOG.warn("Could not get the system classloader due to security constraints, there may be improper urls left to scan", new String[0]);
                    }
                }
            }
            urlSet = urlSet.includeClassesUrl(classLoaderInterface);
            urlSet = urlSet.excludeJavaExtDirs();
            urlSet = urlSet.excludeJavaEndorsedDirs();
            try {
                urlSet = urlSet.excludeJavaHome();
            }
            catch (NullPointerException e) {
                if (!LOG.isWarnEnabled()) break block14;
                LOG.warn("Could not exclude JAVA_HOME, is this a sandbox jvm?", new String[0]);
            }
        }
        urlSet = urlSet.excludePaths(System.getProperty("sun.boot.class.path", ""));
        urlSet = urlSet.exclude(".*/JavaVM.framework/.*");
        if (this.includeJars != null) {
            List rawIncludedUrls = urlSet.getUrls();
            HashSet<URL> includeUrls = new HashSet<URL>();
            boolean[] patternUsed = new boolean[this.includeJars.length];
            block4: for (URL url : rawIncludedUrls) {
                if (this.fileProtocols.contains(url.getProtocol())) {
                    for (int i = 0; i < this.includeJars.length; ++i) {
                        String includeJar = this.includeJars[i];
                        if (!Pattern.matches(includeJar, url.toExternalForm())) continue;
                        includeUrls.add(url);
                        patternUsed[i] = true;
                        continue block4;
                    }
                    continue;
                }
                includeUrls.add(url);
            }
            if (LOG.isWarnEnabled()) {
                for (int i = 0; i < patternUsed.length; ++i) {
                    if (patternUsed[i]) continue;
                    LOG.warn("The includeJars pattern [#0] did not match any jars in the classpath", new String[]{this.includeJars[i]});
                }
            }
            return new UrlSet(includeUrls);
        }
        urlSet = urlSet.exclude(".*?\\.jar(!/|/)?");
        return urlSet;
    }

    protected boolean includeClassNameInActionScan(String className) {
        String classPackageName = StringUtils.substringBeforeLast((String)className, (String)".");
        if (this.actionPackages != null) {
            for (String packageName : this.actionPackages) {
                String strictPackageName = packageName + ".";
                if (!classPackageName.equals(packageName) && !classPackageName.startsWith(strictPackageName)) continue;
                return true;
            }
        }
        if (this.packageLocators != null && !this.disablePackageLocatorsScanning) {
            for (String packageLocator : this.packageLocators) {
                String[] splitted;
                if (classPackageName.length() <= 0 || this.packageLocatorsBasePackage != null && !classPackageName.startsWith(this.packageLocatorsBasePackage) || !StringTools.contains(splitted = classPackageName.split("\\."), packageLocator, false)) continue;
                return true;
            }
        }
        return false;
    }

    protected Test<String> getClassPackageTest() {
        return new Test<String>(){

            public boolean test(String className) {
                return PackageBasedActionConfigBuilder.this.includeClassNameInActionScan(className);
            }
        };
    }

    protected Test<ClassFinder.ClassInfo> getActionClassTest() {
        return new Test<ClassFinder.ClassInfo>(){

            public boolean test(ClassFinder.ClassInfo classInfo) {
                boolean inPackage = PackageBasedActionConfigBuilder.this.includeClassNameInActionScan(classInfo.getName());
                boolean nameMatches = classInfo.getName().endsWith(PackageBasedActionConfigBuilder.this.actionSuffix);
                try {
                    return inPackage && (nameMatches || PackageBasedActionConfigBuilder.this.checkImplementsAction && org.apache.struts2.xwork2.Action.class.isAssignableFrom(classInfo.get()));
                }
                catch (ClassNotFoundException ex) {
                    if (LOG.isErrorEnabled()) {
                        LOG.error("Unable to load class [#0]", (Throwable)ex, new String[]{classInfo.getName()});
                    }
                    return false;
                }
            }
        };
    }

    protected void buildConfiguration(Set<Class> classes) {
        HashMap<String, PackageConfig.Builder> packageConfigs = new HashMap<String, PackageConfig.Builder>();
        for (Class actionClass : classes) {
            Actions actionsAnnotation = actionClass.getAnnotation(Actions.class);
            Action actionAnnotation = actionClass.getAnnotation(Action.class);
            if (this.cannotInstantiate(actionClass)) {
                if (!LOG.isTraceEnabled()) continue;
                LOG.trace("Class [#0] did not pass the instantiation test and will be ignored", new String[]{actionClass.getName()});
                continue;
            }
            if (this.eagerLoading) {
                try {
                    this.objectFactory.getClassInstance(actionClass.getName());
                }
                catch (ClassNotFoundException e) {
                    if (LOG.isErrorEnabled()) {
                        LOG.error("Object Factory was unable to load class [#0]", (Throwable)e, new String[]{actionClass.getName()});
                    }
                    throw new StrutsException("Object Factory was unable to load class " + actionClass.getName(), (Throwable)e);
                }
            }
            String actionPackage = actionClass.getPackage().getName();
            if (LOG.isDebugEnabled()) {
                LOG.debug("Processing class [#0] in package [#1]", new String[]{actionClass.getName(), actionPackage});
            }
            List<String> namespaces = this.determineActionNamespace(actionClass);
            for (String namespace : namespaces) {
                String methodName;
                String defaultActionName = this.determineActionName(actionClass);
                PackageConfig.Builder defaultPackageConfig = this.getPackageConfig(packageConfigs, namespace, actionPackage, actionClass, null);
                Map<String, List<Action>> map = this.getActionAnnotations(actionClass);
                HashSet<String> actionNames = new HashSet<String>();
                boolean hasDefaultMethod = ReflectionTools.containsMethod(actionClass, DEFAULT_METHOD, new Class[0]);
                if (!map.containsKey(DEFAULT_METHOD) && hasDefaultMethod && actionAnnotation == null && actionsAnnotation == null && (this.alwaysMapExecute || map.isEmpty())) {
                    boolean found = false;
                    for (String method : map.keySet()) {
                        List<Action> actions = map.get(method);
                        for (Action action : actions) {
                            String actionName;
                            String string = actionName = action.value().equals("DEFAULT_VALUE") ? defaultActionName : action.value();
                            if (actionNames.contains(actionName)) {
                                throw new ConfigurationException("The action class [" + actionClass + "] contains two methods with an action name annotation whose value " + "is the same (they both might be empty as well).");
                            }
                            actionNames.add(actionName);
                            if (!action.value().equals("DEFAULT_VALUE")) continue;
                            found = true;
                        }
                    }
                    if (!found) {
                        this.createActionConfig(defaultPackageConfig, actionClass, defaultActionName, DEFAULT_METHOD, null);
                    }
                }
                for (String method : map.keySet()) {
                    List<Action> actions = map.get(method);
                    for (Action action : actions) {
                        PackageConfig.Builder pkgCfg = defaultPackageConfig;
                        if (action.value().contains("/") && !this.slashesInActionNames) {
                            pkgCfg = this.getPackageConfig(packageConfigs, namespace, actionPackage, actionClass, action);
                        }
                        this.createActionConfig(pkgCfg, actionClass, defaultActionName, method, action);
                    }
                }
                if (map.isEmpty() && this.mapAllMatches && actionAnnotation == null && actionsAnnotation == null) {
                    this.createActionConfig(defaultPackageConfig, actionClass, defaultActionName, null, actionAnnotation);
                }
                String string = methodName = hasDefaultMethod ? DEFAULT_METHOD : null;
                if (actionsAnnotation != null) {
                    List<Action> actionAnnotations = this.checkActionsAnnotation(actionsAnnotation);
                    for (Action actionAnnotation2 : actionAnnotations) {
                        this.createActionConfig(defaultPackageConfig, actionClass, defaultActionName, methodName, actionAnnotation2);
                    }
                    continue;
                }
                if (actionAnnotation == null) continue;
                this.createActionConfig(defaultPackageConfig, actionClass, defaultActionName, methodName, actionAnnotation);
            }
        }
        this.buildIndexActions(packageConfigs);
        Set packageNames = packageConfigs.keySet();
        for (String packageName : packageNames) {
            this.configuration.addPackageConfig(packageName, ((PackageConfig.Builder)packageConfigs.get(packageName)).build());
        }
    }

    protected boolean cannotInstantiate(Class<?> actionClass) {
        return actionClass.isAnnotation() || actionClass.isInterface() || actionClass.isEnum() || (actionClass.getModifiers() & 0x400) != 0 || actionClass.isAnonymousClass();
    }

    protected List<String> determineActionNamespace(Class<?> actionClass) {
        int indexOfDot;
        Namespaces namespacesAnnotation;
        ArrayList<String> namespaces = new ArrayList<String>();
        Namespace namespaceAnnotation = AnnotationTools.findAnnotation(actionClass, Namespace.class);
        if (namespaceAnnotation != null) {
            if (LOG.isTraceEnabled()) {
                LOG.trace("Using non-default action namespace from Namespace annotation of [#0]", new String[]{namespaceAnnotation.value()});
            }
            namespaces.add(namespaceAnnotation.value());
        }
        if ((namespacesAnnotation = AnnotationTools.findAnnotation(actionClass, Namespaces.class)) != null) {
            if (LOG.isTraceEnabled()) {
                StringBuilder sb = new StringBuilder();
                for (Namespace namespace : namespacesAnnotation.value()) {
                    sb.append(namespace.value()).append(",");
                }
                sb.deleteCharAt(sb.length() - 1);
                LOG.trace("Using non-default action namespaces from Namespaces annotation of [#0]", new String[]{sb.toString()});
            }
            for (Namespace namespace : namespacesAnnotation.value()) {
                namespaces.add(namespace.value());
            }
        }
        if (!namespaces.isEmpty()) {
            return namespaces;
        }
        String pkg = actionClass.getPackage().getName();
        String pkgPart = null;
        if (this.actionPackages != null) {
            for (String actionPackage : this.actionPackages) {
                if (!pkg.startsWith(actionPackage)) continue;
                pkgPart = actionClass.getName().substring(actionPackage.length() + 1);
            }
        }
        if (pkgPart == null && this.packageLocators != null) {
            for (String packageLocator : this.packageLocators) {
                int index = pkg.lastIndexOf(packageLocator);
                if (index < 0 || index + packageLocator.length() != pkg.length() && index != 0 && (pkg.charAt(index - 1) != '.' || pkg.charAt(index + packageLocator.length()) != '.')) continue;
                pkgPart = actionClass.getName().substring(index + packageLocator.length() + 1);
            }
        }
        if (pkgPart != null && (indexOfDot = pkgPart.lastIndexOf(46)) >= 0) {
            String convertedNamespace = this.actionNameBuilder.build(pkgPart.substring(0, indexOfDot));
            namespaces.add("/" + convertedNamespace.replace('.', '/'));
            return namespaces;
        }
        namespaces.add("");
        return namespaces;
    }

    protected String determineActionName(Class<?> actionClass) {
        String actionName = this.actionNameBuilder.build(actionClass.getSimpleName());
        if (LOG.isTraceEnabled()) {
            LOG.trace("Got actionName for class [#0] of [#1]", new String[]{actionClass.toString(), actionName});
        }
        return actionName;
    }

    protected Map<String, List<Action>> getActionAnnotations(Class<?> actionClass) {
        Method[] methods = actionClass.getMethods();
        HashMap<String, List<Action>> map = new HashMap<String, List<Action>>();
        for (Method method : methods) {
            Actions actionsAnnotation = method.getAnnotation(Actions.class);
            if (actionsAnnotation != null) {
                List<Action> actions = this.checkActionsAnnotation(actionsAnnotation);
                map.put(method.getName(), actions);
                continue;
            }
            Action ann = method.getAnnotation(Action.class);
            if (ann == null) continue;
            map.put(method.getName(), Arrays.asList(ann));
        }
        return map;
    }

    protected List<Action> checkActionsAnnotation(Actions actionsAnnotation) {
        Action[] actionArray = actionsAnnotation.value();
        boolean valuelessSeen = false;
        ArrayList<Action> actions = new ArrayList<Action>();
        for (Action ann : actionArray) {
            if (ann.value().equals("DEFAULT_VALUE") && !valuelessSeen) {
                valuelessSeen = true;
            } else if (ann.value().equals("DEFAULT_VALUE")) {
                throw new ConfigurationException("You may only add a single Action annotation that has no value parameter.");
            }
            actions.add(ann);
        }
        return actions;
    }

    protected void createActionConfig(PackageConfig.Builder pkgCfg, Class<?> actionClass, String actionName, String actionMethod, Action annotation) {
        ActionConfig existingActionConfig;
        ExceptionMappings exceptionMappings;
        if (annotation != null) {
            actionName = annotation.value() != null && annotation.value().equals("DEFAULT_VALUE") ? actionName : annotation.value();
            actionName = StringUtils.contains((String)actionName, (String)"/") && !this.slashesInActionNames ? StringUtils.substringAfterLast((String)actionName, (String)"/") : actionName;
        }
        ActionConfig.Builder actionConfig = new ActionConfig.Builder(pkgCfg.getName(), actionName, actionClass.getName());
        actionConfig.methodName(actionMethod);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Creating action config for class [#0], name [#1] and package name [#2] in namespace [#3]", new String[]{actionClass.toString(), actionName, pkgCfg.getName(), pkgCfg.getNamespace()});
        }
        List<InterceptorMapping> interceptors = this.interceptorMapBuilder.build(actionClass, pkgCfg, actionName, annotation);
        actionConfig.addInterceptors(interceptors);
        Map<String, ResultConfig> results = this.resultMapBuilder.build(actionClass, annotation, actionName, pkgCfg.build());
        actionConfig.addResultConfigs(results);
        if (annotation != null) {
            actionConfig.addParams(StringTools.createParameterMap(annotation.params()));
        }
        if (annotation != null && annotation.exceptionMappings() != null) {
            actionConfig.addExceptionMappings(this.buildExceptionMappings(annotation.exceptionMappings(), actionName));
        }
        if ((exceptionMappings = actionClass.getAnnotation(ExceptionMappings.class)) != null) {
            actionConfig.addExceptionMappings(this.buildExceptionMappings(exceptionMappings.value(), actionName));
        }
        pkgCfg.addActionConfig(actionName, actionConfig.build());
        PackageConfig existingPkg = this.configuration.getPackageConfig(pkgCfg.getName());
        if (existingPkg != null && (existingActionConfig = (ActionConfig)existingPkg.getActionConfigs().get(actionName)) != null && LOG.isWarnEnabled()) {
            LOG.warn("Duplicated action definition in package [#0] with name [#1].", new String[]{pkgCfg.getName(), actionName});
        }
        if (this.isReloadEnabled()) {
            URL classFile = actionClass.getResource(actionClass.getSimpleName() + ".class");
            FileManager.loadFile((URL)classFile, (boolean)false);
            this.loadedFileUrls.add(classFile.toString());
        }
    }

    protected List<ExceptionMappingConfig> buildExceptionMappings(ExceptionMapping[] exceptions, String actionName) {
        ArrayList<ExceptionMappingConfig> exceptionMappings = new ArrayList<ExceptionMappingConfig>();
        for (ExceptionMapping exceptionMapping : exceptions) {
            if (LOG.isTraceEnabled()) {
                LOG.trace("Mapping exception [#0] to result [#1] for action [#2]", new String[]{exceptionMapping.exception(), exceptionMapping.result(), actionName});
            }
            ExceptionMappingConfig.Builder builder = new ExceptionMappingConfig.Builder(null, exceptionMapping.exception(), exceptionMapping.result());
            if (exceptionMapping.params() != null) {
                builder.addParams(StringTools.createParameterMap(exceptionMapping.params()));
            }
            exceptionMappings.add(builder.build());
        }
        return exceptionMappings;
    }

    protected PackageConfig.Builder getPackageConfig(Map<String, PackageConfig.Builder> packageConfigs, String actionNamespace, String actionPackage, Class<?> actionClass, Action action) {
        if (action != null && !action.value().equals("DEFAULT_VALUE")) {
            String actionName;
            if (LOG.isTraceEnabled()) {
                LOG.trace("Using non-default action namespace from the Action annotation of [#0]", new String[]{action.value()});
            }
            actionNamespace = StringUtils.contains((String)(actionName = action.value()), (String)"/") ? StringUtils.substringBeforeLast((String)actionName, (String)"/") : "";
        }
        ParentPackage parent = AnnotationTools.findAnnotation(actionClass, ParentPackage.class);
        String parentName = null;
        if (parent != null) {
            if (LOG.isTraceEnabled()) {
                LOG.trace("Using non-default parent package from annotation of [#0]", new String[]{parent.value()});
            }
            parentName = parent.value();
        }
        if (parentName == null) {
            parentName = this.defaultParentPackage;
        }
        if (parentName == null) {
            throw new ConfigurationException("Unable to determine the parent XWork package for the action class [" + actionClass.getName() + "]");
        }
        PackageConfig parentPkg = this.configuration.getPackageConfig(parentName);
        if (parentPkg == null) {
            throw new ConfigurationException("Unable to locate parent package [" + parentName + "]");
        }
        String name = actionPackage + "#" + parentPkg.getName() + "#" + actionNamespace;
        PackageConfig.Builder pkgConfig = packageConfigs.get(name);
        if (pkgConfig == null) {
            pkgConfig = new PackageConfig.Builder(name).namespace(actionNamespace).addParent(parentPkg);
            packageConfigs.put(name, pkgConfig);
            DefaultInterceptorRef defaultInterceptorRef = AnnotationTools.findAnnotation(actionClass, DefaultInterceptorRef.class);
            if (defaultInterceptorRef != null) {
                pkgConfig.defaultInterceptorRef(defaultInterceptorRef.value());
                if (LOG.isTraceEnabled()) {
                    LOG.trace("Setting [#0] as the default interceptor ref for [#1]", new String[]{defaultInterceptorRef.value(), pkgConfig.getName()});
                }
            }
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace("Created package config named [#0] with a namespace [#1]", new String[]{name, actionNamespace});
        }
        return pkgConfig;
    }

    protected void buildIndexActions(Map<String, PackageConfig.Builder> packageConfigs) {
        HashMap<String, PackageConfig.Builder> byNamespace = new HashMap<String, PackageConfig.Builder>();
        Collection<PackageConfig.Builder> values = packageConfigs.values();
        for (PackageConfig.Builder packageConfig : values) {
            byNamespace.put(packageConfig.getNamespace(), packageConfig);
        }
        Set namespaces = byNamespace.keySet();
        for (String namespace : namespaces) {
            int lastSlash;
            PackageConfig.Builder pkgConfig = (PackageConfig.Builder)byNamespace.get(namespace);
            ActionConfig indexActionConfig = (ActionConfig)pkgConfig.build().getAllActionConfigs().get("index");
            if (indexActionConfig == null) continue;
            if (!this.redirectToSlash && (lastSlash = namespace.lastIndexOf(47)) >= 0) {
                String parentAction = namespace.substring(lastSlash + 1);
                String parentNamespace = namespace.substring(0, lastSlash);
                PackageConfig.Builder parent = (PackageConfig.Builder)byNamespace.get(parentNamespace);
                if (parent == null || parent.build().getAllActionConfigs().get(parentAction) == null) {
                    if (parent == null) {
                        parent = new PackageConfig.Builder(parentNamespace).namespace(parentNamespace).addParents(pkgConfig.build().getParents());
                        packageConfigs.put(parentNamespace, parent);
                    }
                    if (parent.build().getAllActionConfigs().get(parentAction) == null) {
                        parent.addActionConfig(parentAction, indexActionConfig);
                    }
                } else if (LOG.isTraceEnabled()) {
                    LOG.trace("The parent namespace [#0] already contains an action [#1]", new String[]{parentNamespace, parentAction});
                }
            }
            if (pkgConfig.build().getAllActionConfigs().get("") != null) continue;
            if (LOG.isTraceEnabled()) {
                LOG.trace("Creating index ActionConfig with an action name of [] for the action class [#0]", new String[]{indexActionConfig.getClassName()});
            }
            pkgConfig.addActionConfig("", indexActionConfig);
        }
    }

    @Override
    public void destroy() {
        this.loadedFileUrls.clear();
    }

    @Override
    public boolean needsReload() {
        if (this.devMode && this.reload) {
            for (String url : this.loadedFileUrls) {
                if (!FileManager.fileNeedsReloading((String)url)) continue;
                if (LOG.isDebugEnabled()) {
                    LOG.debug("File [#0] changed, configuration will be reloaded", new String[]{url});
                }
                return true;
            }
            return false;
        }
        return false;
    }
}

