/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts2.dispatcher.ng;

import com.opensymphony.xwork2.ActionContext;
import com.opensymphony.xwork2.util.logging.LoggerFactory;
import java.util.HashMap;
import java.util.Iterator;
import org.apache.struts2.dispatcher.Dispatcher;
import org.apache.struts2.dispatcher.StaticContentLoader;
import org.apache.struts2.dispatcher.ng.HostConfig;
import org.apache.struts2.util.ClassLoaderUtils;

public class InitOperations {
    public void initLogging(HostConfig filterConfig) {
        String factoryName = filterConfig.getInitParameter("loggerFactory");
        if (factoryName != null) {
            try {
                Class cls = ClassLoaderUtils.loadClass(factoryName, this.getClass());
                LoggerFactory fac = (LoggerFactory)cls.newInstance();
                LoggerFactory.setLoggerFactory((LoggerFactory)fac);
            }
            catch (InstantiationException e) {
                System.err.println("Unable to instantiate logger factory: " + factoryName + ", using default");
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                System.err.println("Unable to access logger factory: " + factoryName + ", using default");
                e.printStackTrace();
            }
            catch (ClassNotFoundException e) {
                System.err.println("Unable to locate logger factory class: " + factoryName + ", using default");
                e.printStackTrace();
            }
        }
    }

    public Dispatcher initDispatcher(HostConfig filterConfig) {
        Dispatcher dispatcher = this.createDispatcher(filterConfig);
        dispatcher.init();
        return dispatcher;
    }

    public StaticContentLoader initStaticContentLoader(HostConfig filterConfig, Dispatcher dispatcher) {
        StaticContentLoader loader = (StaticContentLoader)dispatcher.getContainer().getInstance(StaticContentLoader.class);
        loader.setHostConfig(filterConfig);
        return loader;
    }

    public Dispatcher findDispatcherOnThread() {
        Dispatcher dispatcher = Dispatcher.getInstance();
        if (dispatcher == null) {
            throw new IllegalStateException("Must have the StrutsPrepareFilter execute before this one");
        }
        return dispatcher;
    }

    private Dispatcher createDispatcher(HostConfig filterConfig) {
        HashMap<String, String> params = new HashMap<String, String>();
        Iterator<String> e = filterConfig.getInitParameterNames();
        while (e.hasNext()) {
            String name = e.next();
            String value = filterConfig.getInitParameter(name);
            params.put(name, value);
        }
        return new Dispatcher(filterConfig.getServletContext(), params);
    }

    public void cleanup() {
        ActionContext.setContext(null);
    }
}

