/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts2.views.util;

public class TextUtil {
    protected static final int MAX_LENGTH = 300;
    protected static final char[][] _stringChars = new char[300][];

    public static final String escapeHTML(String s) {
        return TextUtil.escapeHTML(s, false);
    }

    public static final String escapeHTML(String s, boolean escapeEmpty) {
        char index;
        String trimmed;
        int len = s.length();
        if (len == 0) {
            return s;
        }
        if (!escapeEmpty && ((trimmed = s.trim()).length() == 0 || "\"\"".equals(trimmed))) {
            return s;
        }
        int i = 0;
        while (((index = s.charAt(i)) >= '\u012c' ? index != '\u20ac' : _stringChars[index] == null) && ++i < len) {
        }
        if (i == len) {
            return s;
        }
        StringBuilder sb = new StringBuilder(len + 40);
        char[] chars = new char[len];
        s.getChars(0, len, chars, 0);
        sb.append(chars, 0, i);
        int last = i;
        while (i < len) {
            char c = chars[i];
            char index2 = c;
            if (index2 < '\u012c') {
                char[] subst = _stringChars[index2];
                if (subst != null) {
                    if (i > last) {
                        sb.append(chars, last, i - last);
                    }
                    sb.append(subst);
                    last = i + 1;
                }
            } else if (index2 == '\u20ac') {
                if (i > last) {
                    sb.append(chars, last, i - last);
                }
                sb.append("&euro;");
                last = i + 1;
            }
            ++i;
        }
        if (i > last) {
            sb.append(chars, last, i - last);
        }
        return sb.toString();
    }

    protected static void addMapping(int c, String txt, String[] strings) {
        strings[c] = txt;
    }

    protected static void initMapping() {
        String[] strings = new String[300];
        TextUtil.addMapping(34, "&quot;", strings);
        TextUtil.addMapping(38, "&amp;", strings);
        TextUtil.addMapping(60, "&lt;", strings);
        TextUtil.addMapping(62, "&gt;", strings);
        TextUtil.addMapping(161, "&iexcl;", strings);
        TextUtil.addMapping(162, "&cent;", strings);
        TextUtil.addMapping(163, "&pound;", strings);
        TextUtil.addMapping(169, "&copy;", strings);
        TextUtil.addMapping(174, "&reg;", strings);
        TextUtil.addMapping(191, "&iquest;", strings);
        TextUtil.addMapping(192, "&Agrave;", strings);
        TextUtil.addMapping(193, "&Aacute;", strings);
        TextUtil.addMapping(194, "&Acirc;", strings);
        TextUtil.addMapping(195, "&Atilde;", strings);
        TextUtil.addMapping(196, "&Auml;", strings);
        TextUtil.addMapping(197, "&Aring;", strings);
        TextUtil.addMapping(198, "&AElig;", strings);
        TextUtil.addMapping(199, "&Ccedil;", strings);
        TextUtil.addMapping(200, "&Egrave;", strings);
        TextUtil.addMapping(201, "&Eacute;", strings);
        TextUtil.addMapping(202, "&Ecirc;", strings);
        TextUtil.addMapping(203, "&Euml;", strings);
        TextUtil.addMapping(204, "&Igrave;", strings);
        TextUtil.addMapping(205, "&Iacute;", strings);
        TextUtil.addMapping(206, "&Icirc;", strings);
        TextUtil.addMapping(207, "&Iuml;", strings);
        TextUtil.addMapping(208, "&ETH;", strings);
        TextUtil.addMapping(209, "&Ntilde;", strings);
        TextUtil.addMapping(210, "&Ograve;", strings);
        TextUtil.addMapping(211, "&Oacute;", strings);
        TextUtil.addMapping(212, "&Ocirc;", strings);
        TextUtil.addMapping(213, "&Otilde;", strings);
        TextUtil.addMapping(214, "&Ouml;", strings);
        TextUtil.addMapping(215, "&times;", strings);
        TextUtil.addMapping(216, "&Oslash;", strings);
        TextUtil.addMapping(217, "&Ugrave;", strings);
        TextUtil.addMapping(218, "&Uacute;", strings);
        TextUtil.addMapping(219, "&Ucirc;", strings);
        TextUtil.addMapping(220, "&Uuml;", strings);
        TextUtil.addMapping(221, "&Yacute;", strings);
        TextUtil.addMapping(222, "&THORN;", strings);
        TextUtil.addMapping(223, "&szlig;", strings);
        TextUtil.addMapping(224, "&agrave;", strings);
        TextUtil.addMapping(225, "&aacute;", strings);
        TextUtil.addMapping(226, "&acirc;", strings);
        TextUtil.addMapping(227, "&atilde;", strings);
        TextUtil.addMapping(228, "&auml;", strings);
        TextUtil.addMapping(229, "&aring;", strings);
        TextUtil.addMapping(230, "&aelig;", strings);
        TextUtil.addMapping(231, "&ccedil;", strings);
        TextUtil.addMapping(232, "&egrave;", strings);
        TextUtil.addMapping(233, "&eacute;", strings);
        TextUtil.addMapping(234, "&ecirc;", strings);
        TextUtil.addMapping(235, "&euml;", strings);
        TextUtil.addMapping(236, "&igrave;", strings);
        TextUtil.addMapping(237, "&iacute;", strings);
        TextUtil.addMapping(238, "&icirc;", strings);
        TextUtil.addMapping(239, "&iuml;", strings);
        TextUtil.addMapping(240, "&eth;", strings);
        TextUtil.addMapping(241, "&ntilde;", strings);
        TextUtil.addMapping(242, "&ograve;", strings);
        TextUtil.addMapping(243, "&oacute;", strings);
        TextUtil.addMapping(244, "&ocirc;", strings);
        TextUtil.addMapping(245, "&otilde;", strings);
        TextUtil.addMapping(246, "&ouml;", strings);
        TextUtil.addMapping(247, "&divide;", strings);
        TextUtil.addMapping(248, "&oslash;", strings);
        TextUtil.addMapping(249, "&ugrave;", strings);
        TextUtil.addMapping(250, "&uacute;", strings);
        TextUtil.addMapping(251, "&ucirc;", strings);
        TextUtil.addMapping(252, "&uuml;", strings);
        TextUtil.addMapping(253, "&yacute;", strings);
        TextUtil.addMapping(254, "&thorn;", strings);
        TextUtil.addMapping(255, "&yuml;", strings);
        for (int i = 0; i < strings.length; ++i) {
            String str = strings[i];
            if (str == null) continue;
            TextUtil._stringChars[i] = str.toCharArray();
        }
    }

    static {
        TextUtil.initMapping();
    }
}

