/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts2.config;

import com.opensymphony.xwork2.util.location.LocatableProperties;
import com.opensymphony.xwork2.util.location.Location;
import com.opensymphony.xwork2.util.location.LocationImpl;
import com.opensymphony.xwork2.util.logging.Logger;
import com.opensymphony.xwork2.util.logging.LoggerFactory;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Iterator;
import org.apache.struts2.StrutsException;
import org.apache.struts2.config.Settings;
import org.apache.struts2.util.ClassLoaderUtils;

class PropertiesSettings
extends Settings {
    LocatableProperties settings;
    static Logger LOG = LoggerFactory.getLogger(PropertiesSettings.class);

    public PropertiesSettings(String name) {
        URL settingsUrl = ClassLoaderUtils.getResource(name + ".properties", this.getClass());
        if (settingsUrl == null) {
            LOG.debug(name + ".properties missing", new String[0]);
            this.settings = new LocatableProperties();
            return;
        }
        this.settings = new LocatableProperties((Location)new LocationImpl(null, settingsUrl.toString()));
        InputStream in = null;
        try {
            in = settingsUrl.openStream();
            this.settings.load(in);
        }
        catch (IOException e) {
            throw new StrutsException("Could not load " + name + ".properties:" + e, e);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException io) {
                    LOG.warn("Unable to close input stream", (Throwable)io, new String[0]);
                }
            }
        }
    }

    public void setImpl(String aName, String aValue) {
        this.settings.setProperty(aName, aValue);
    }

    public String getImpl(String aName) throws IllegalArgumentException {
        String setting = this.settings.getProperty(aName);
        if (setting == null) {
            throw new IllegalArgumentException("No such setting:" + aName);
        }
        return setting;
    }

    public Location getLocationImpl(String aName) throws IllegalArgumentException {
        Location loc = this.settings.getPropertyLocation(aName);
        if (loc == null && !this.settings.containsKey((Object)aName)) {
            throw new IllegalArgumentException("No such setting:" + aName);
        }
        return loc;
    }

    public boolean isSetImpl(String aName) {
        return this.settings.get((Object)aName) != null;
    }

    public Iterator listImpl() {
        return this.settings.keySet().iterator();
    }
}

