/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts2.dispatcher;

import com.opensymphony.xwork2.ActionContext;
import com.opensymphony.xwork2.ActionInvocation;
import com.opensymphony.xwork2.Result;
import com.opensymphony.xwork2.util.TextParseUtil;
import com.opensymphony.xwork2.util.ValueStack;
import com.opensymphony.xwork2.util.logging.Logger;
import com.opensymphony.xwork2.util.logging.LoggerFactory;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts2.ServletActionContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpHeaderResult
implements Result {
    private static final long serialVersionUID = 195648957144219214L;
    private static final Logger LOG = LoggerFactory.getLogger(HttpHeaderResult.class);
    private boolean parse = true;
    private Map<String, String> headers = new HashMap<String, String>();
    private int status = -1;
    private String error = null;
    private String errorMessage;

    public HttpHeaderResult() {
    }

    public HttpHeaderResult(int status) {
        this();
        this.status = status;
        this.parse = false;
    }

    public void setError(String error) {
        this.error = error;
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public void setParse(boolean parse) {
        this.parse = parse;
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public int getStatus() {
        return this.status;
    }

    public void addHeader(String name, String value) {
        this.headers.put(name, value);
    }

    public void execute(ActionInvocation invocation) throws Exception {
        HttpServletResponse response = ServletActionContext.getResponse();
        ValueStack stack = ActionContext.getContext().getValueStack();
        if (this.status != -1) {
            response.setStatus(this.status);
        }
        if (this.headers != null) {
            for (Map.Entry<String, String> entry : this.headers.entrySet()) {
                String value = entry.getValue();
                String finalValue = this.parse ? TextParseUtil.translateVariables((String)value, (ValueStack)stack) : value;
                response.addHeader(entry.getKey(), finalValue);
            }
        }
        if (this.status == -1 && this.error != null) {
            int errorCode;
            block9: {
                errorCode = -1;
                try {
                    errorCode = Integer.parseInt(this.parse ? TextParseUtil.translateVariables((String)this.error, (ValueStack)stack) : this.error);
                }
                catch (Exception e) {
                    if (!LOG.isErrorEnabled()) break block9;
                    LOG.error("Cannot parse errorCode [#0] value as Integer!", (Throwable)e, new String[]{this.error});
                }
            }
            if (errorCode != -1) {
                if (this.errorMessage != null) {
                    String finalMessage = this.parse ? TextParseUtil.translateVariables((String)this.errorMessage, (ValueStack)stack) : this.errorMessage;
                    response.sendError(errorCode, finalMessage);
                } else {
                    response.sendError(errorCode);
                }
            }
        }
    }
}

