/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts2.dispatcher;

import com.opensymphony.xwork2.ActionInvocation;
import com.opensymphony.xwork2.util.logging.Logger;
import com.opensymphony.xwork2.util.logging.LoggerFactory;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts2.dispatcher.StrutsResultSupport;

public class PlainTextResult
extends StrutsResultSupport {
    public static final int BUFFER_SIZE = 1024;
    private static final Logger LOG = LoggerFactory.getLogger(PlainTextResult.class);
    private static final long serialVersionUID = 3633371605905583950L;
    private String charSet;

    public PlainTextResult() {
    }

    public PlainTextResult(String location) {
        super(location);
    }

    public String getCharSet() {
        return this.charSet;
    }

    public void setCharSet(String charSet) {
        this.charSet = charSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doExecute(String finalLocation, ActionInvocation invocation) throws Exception {
        Charset charset = null;
        if (this.charSet != null) {
            if (Charset.isSupported(this.charSet)) {
                charset = Charset.forName(this.charSet);
            } else {
                if (LOG.isWarnEnabled()) {
                    LOG.warn("charset [" + this.charSet + "] is not recognized ", new String[0]);
                }
                charset = null;
            }
        }
        HttpServletResponse response = (HttpServletResponse)invocation.getInvocationContext().get("com.opensymphony.xwork2.dispatcher.HttpServletResponse");
        ServletContext servletContext = (ServletContext)invocation.getInvocationContext().get("com.opensymphony.xwork2.dispatcher.ServletContext");
        if (charset != null) {
            response.setContentType("text/plain; charset=" + this.charSet);
        } else {
            response.setContentType("text/plain");
        }
        response.setHeader("Content-Disposition", "inline");
        PrintWriter writer = response.getWriter();
        InputStreamReader reader = null;
        try {
            InputStream resourceAsStream = servletContext.getResourceAsStream(finalLocation);
            reader = charset != null ? new InputStreamReader(resourceAsStream, charset) : new InputStreamReader(resourceAsStream);
            if (resourceAsStream == null) {
                if (LOG.isWarnEnabled()) {
                    LOG.warn("resource at location [" + finalLocation + "] cannot be obtained (return null) from ServletContext !!! ", new String[0]);
                }
            } else {
                int charRead;
                char[] buffer = new char[1024];
                while ((charRead = reader.read(buffer)) != -1) {
                    writer.write(buffer, 0, charRead);
                }
            }
        }
        finally {
            if (reader != null) {
                reader.close();
            }
            if (writer != null) {
                writer.flush();
                writer.close();
            }
        }
    }
}

