/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.xwork2;

import com.opensymphony.xwork2.LocaleProviderFactory;
import com.opensymphony.xwork2.LocalizedTextProvider;
import com.opensymphony.xwork2.ResourceBundleTextProvider;
import com.opensymphony.xwork2.TextProvider;
import com.opensymphony.xwork2.TextProviderSupport;
import com.opensymphony.xwork2.inject.Inject;
import java.util.ResourceBundle;

public class TextProviderFactory {
    private TextProvider textProvider;
    private LocaleProviderFactory localeProviderFactory;
    private LocalizedTextProvider localizedTextProvider;

    @Inject
    public void setTextProvider(TextProvider textProvider) {
        this.textProvider = textProvider;
    }

    @Inject
    public void setLocaleProviderFactory(LocaleProviderFactory localeProviderFactory) {
        this.localeProviderFactory = localeProviderFactory;
    }

    @Inject
    public void setLocalizedTextProvider(LocalizedTextProvider localizedTextProvider) {
        this.localizedTextProvider = localizedTextProvider;
    }

    public TextProvider createInstance(Class clazz) {
        TextProvider instance = this.getTextProvider(clazz);
        if (instance instanceof ResourceBundleTextProvider) {
            ((ResourceBundleTextProvider)instance).setClazz(clazz);
            ((ResourceBundleTextProvider)instance).setLocaleProvider(this.localeProviderFactory.createLocaleProvider());
        }
        return instance;
    }

    public TextProvider createInstance(ResourceBundle bundle) {
        TextProvider instance = this.getTextProvider(bundle);
        if (instance instanceof ResourceBundleTextProvider) {
            ((ResourceBundleTextProvider)instance).setBundle(bundle);
            ((ResourceBundleTextProvider)instance).setLocaleProvider(this.localeProviderFactory.createLocaleProvider());
        }
        return instance;
    }

    protected TextProvider getTextProvider(Class clazz) {
        if (this.textProvider == null) {
            return new TextProviderSupport(clazz, this.localeProviderFactory.createLocaleProvider(), this.localizedTextProvider);
        }
        return this.textProvider;
    }

    private TextProvider getTextProvider(ResourceBundle bundle) {
        if (this.textProvider == null) {
            return new TextProviderSupport(bundle, this.localeProviderFactory.createLocaleProvider(), this.localizedTextProvider);
        }
        return this.textProvider;
    }
}

