/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.xwork2.util;

import com.opensymphony.xwork2.ActionContext;
import com.opensymphony.xwork2.ActionInvocation;
import com.opensymphony.xwork2.LocalizedTextProvider;
import com.opensymphony.xwork2.ModelDriven;
import com.opensymphony.xwork2.inject.Inject;
import com.opensymphony.xwork2.util.TextParseUtil;
import com.opensymphony.xwork2.util.ValueStack;
import com.opensymphony.xwork2.util.reflection.ReflectionProviderFactory;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.ParameterizedMessage;

public class DefaultLocalizedTextProvider
implements LocalizedTextProvider {
    private static final Logger LOG = LogManager.getLogger(DefaultLocalizedTextProvider.class);
    public static final String XWORK_MESSAGES_BUNDLE = "com/opensymphony/xwork2/xwork-messages";
    public static final String STRUTS_MESSAGES_BUNDLE = "org/apache/struts2/struts-messages";
    private static final String TOMCAT_RESOURCE_ENTRIES_FIELD = "resourceEntries";
    private final ConcurrentMap<Integer, List<String>> classLoaderMap = new ConcurrentHashMap<Integer, List<String>>();
    private boolean reloadBundles = false;
    private boolean devMode = false;
    private final ConcurrentMap<String, ResourceBundle> bundlesMap = new ConcurrentHashMap<String, ResourceBundle>();
    private final ConcurrentMap<MessageFormatKey, MessageFormat> messageFormats = new ConcurrentHashMap<MessageFormatKey, MessageFormat>();
    private final ConcurrentMap<Integer, ClassLoader> delegatedClassLoaderMap = new ConcurrentHashMap<Integer, ClassLoader>();
    private final Set<String> missingBundles = Collections.synchronizedSet(new HashSet());
    private final String RELOADED = "com.opensymphony.xwork2.util.LocalizedTextUtil.reloaded";

    @Deprecated
    public static void clearDefaultResourceBundles() {
    }

    public DefaultLocalizedTextProvider() {
        this.addDefaultResourceBundle(XWORK_MESSAGES_BUNDLE);
        this.addDefaultResourceBundle(STRUTS_MESSAGES_BUNDLE);
    }

    @Inject(value="struts.i18n.reload", required=false)
    public void setReloadBundles(String reloadBundles) {
        this.reloadBundles = Boolean.parseBoolean(reloadBundles);
    }

    @Inject(value="struts.devMode", required=false)
    public void setDevMode(String devMode) {
        this.devMode = Boolean.parseBoolean(devMode);
    }

    @Inject(value="struts.custom.i18n.resources", required=false)
    public void setCustomI18NResources(String bundles) {
        if (bundles != null && bundles.length() > 0) {
            StringTokenizer customBundles = new StringTokenizer(bundles, ", ");
            while (customBundles.hasMoreTokens()) {
                String name = customBundles.nextToken();
                try {
                    LOG.trace("Loading global messages from [{}]", (Object)name);
                    this.addDefaultResourceBundle(name);
                }
                catch (Exception e) {
                    LOG.error((Message)new ParameterizedMessage("Could not find messages file {}.properties. Skipping", (Object)name), (Throwable)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addDefaultResourceBundle(String resourceBundleName) {
        ClassLoader ccl = DefaultLocalizedTextProvider.getCurrentThreadContextClassLoader();
        String string = XWORK_MESSAGES_BUNDLE;
        synchronized (XWORK_MESSAGES_BUNDLE) {
            CopyOnWriteArrayList<String> bundles = (CopyOnWriteArrayList<String>)this.classLoaderMap.get(ccl.hashCode());
            if (bundles == null) {
                bundles = new CopyOnWriteArrayList<String>();
                this.classLoaderMap.put(ccl.hashCode(), bundles);
            }
            bundles.remove(resourceBundleName);
            bundles.add(0, resourceBundleName);
            // ** MonitorExit[var3_3] (shouldn't be in output)
            if (LOG.isDebugEnabled()) {
                LOG.debug("Added default resource bundle '{}' to default resource bundles for the following classloader '{}'", (Object)resourceBundleName, (Object)ccl.toString());
            }
            return;
        }
    }

    public static Locale localeFromString(String localeStr, Locale defaultLocale) {
        if (localeStr == null || localeStr.trim().length() == 0 || "_".equals(localeStr)) {
            if (defaultLocale != null) {
                return defaultLocale;
            }
            return Locale.getDefault();
        }
        int index = localeStr.indexOf(95);
        if (index < 0) {
            return new Locale(localeStr);
        }
        String language = localeStr.substring(0, index);
        if (index == localeStr.length()) {
            return new Locale(language);
        }
        if ((index = (localeStr = localeStr.substring(index + 1)).indexOf(95)) < 0) {
            return new Locale(language, localeStr);
        }
        String country = localeStr.substring(0, index);
        if (index == localeStr.length()) {
            return new Locale(language, country);
        }
        localeStr = localeStr.substring(index + 1);
        return new Locale(language, country, localeStr);
    }

    @Override
    public String findDefaultText(String aTextName, Locale locale) {
        List localList = (List)this.classLoaderMap.get(Thread.currentThread().getContextClassLoader().hashCode());
        for (String bundleName : localList) {
            ResourceBundle bundle = this.findResourceBundle(bundleName, locale);
            if (bundle == null) continue;
            this.reloadBundles();
            try {
                return bundle.getString(aTextName);
            }
            catch (MissingResourceException missingResourceException) {
            }
        }
        if (this.devMode) {
            LOG.warn("Missing key [{}] in bundles [{}]!", (Object)aTextName, (Object)localList);
        } else {
            LOG.debug("Missing key [{}] in bundles [{}]!", (Object)aTextName, (Object)localList);
        }
        return null;
    }

    @Override
    public String findDefaultText(String aTextName, Locale locale, Object[] params) {
        String defaultText = this.findDefaultText(aTextName, locale);
        if (defaultText != null) {
            MessageFormat mf = this.buildMessageFormat(defaultText, locale);
            return this.formatWithNullDetection(mf, params);
        }
        return null;
    }

    @Override
    public ResourceBundle findResourceBundle(String aBundleName, Locale locale) {
        ClassLoader classLoader = DefaultLocalizedTextProvider.getCurrentThreadContextClassLoader();
        String key = this.createMissesKey(String.valueOf(classLoader.hashCode()), aBundleName, locale);
        if (this.missingBundles.contains(key)) {
            return null;
        }
        ResourceBundle bundle = null;
        try {
            if (this.bundlesMap.containsKey(key)) {
                bundle = (ResourceBundle)this.bundlesMap.get(key);
            } else {
                bundle = ResourceBundle.getBundle(aBundleName, locale, classLoader);
                this.bundlesMap.putIfAbsent(key, bundle);
            }
        }
        catch (MissingResourceException ex) {
            if (this.delegatedClassLoaderMap.containsKey(classLoader.hashCode())) {
                try {
                    if (this.bundlesMap.containsKey(key)) {
                        bundle = (ResourceBundle)this.bundlesMap.get(key);
                    }
                    bundle = ResourceBundle.getBundle(aBundleName, locale, (ClassLoader)this.delegatedClassLoaderMap.get(classLoader.hashCode()));
                    this.bundlesMap.putIfAbsent(key, bundle);
                }
                catch (MissingResourceException e) {
                    LOG.debug("Missing resource bundle [{}]!", (Object)aBundleName, (Object)e);
                    this.missingBundles.add(key);
                }
            }
            LOG.debug("Missing resource bundle [{}]!", (Object)aBundleName);
            this.missingBundles.add(key);
        }
        return bundle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDelegatedClassLoader(ClassLoader classLoader) {
        ConcurrentMap<String, ResourceBundle> concurrentMap = this.bundlesMap;
        synchronized (concurrentMap) {
            this.delegatedClassLoaderMap.put(DefaultLocalizedTextProvider.getCurrentThreadContextClassLoader().hashCode(), classLoader);
        }
    }

    public void clearBundle(String bundleName) {
        this.bundlesMap.remove(DefaultLocalizedTextProvider.getCurrentThreadContextClassLoader().hashCode() + bundleName);
    }

    private String createMissesKey(String prefix, String aBundleName, Locale locale) {
        return prefix + aBundleName + "_" + locale.toString();
    }

    @Override
    public String findText(Class aClass, String aTextName, Locale locale) {
        return this.findText(aClass, aTextName, locale, aTextName, new Object[0]);
    }

    @Override
    public String findText(Class aClass, String aTextName, Locale locale, String defaultMessage, Object[] args) {
        ValueStack valueStack = ActionContext.getContext().getValueStack();
        return this.findText(aClass, aTextName, locale, defaultMessage, args, valueStack);
    }

    @Override
    public String findText(Class aClass, String aTextName, Locale locale, String defaultMessage, Object[] args, ValueStack valueStack) {
        GetDefaultMessageReturnArg result;
        Object model;
        Object action;
        ActionContext context;
        ActionInvocation actionInvocation;
        String msg;
        String indexedTextName = null;
        if (aTextName == null) {
            LOG.warn("Trying to find text with null key!");
            aTextName = "";
        }
        if (aTextName.contains("[")) {
            int i = -1;
            indexedTextName = aTextName;
            while ((i = indexedTextName.indexOf("[", i + 1)) != -1) {
                int j = indexedTextName.indexOf("]", i);
                String a = indexedTextName.substring(0, i);
                String b = indexedTextName.substring(j);
                indexedTextName = a + "[*" + b;
            }
        }
        if ((msg = this.findMessage(aClass, aTextName, indexedTextName, locale, args, null, valueStack)) != null) {
            return msg;
        }
        if (ModelDriven.class.isAssignableFrom(aClass) && (actionInvocation = (context = ActionContext.getContext()).getActionInvocation()) != null && (action = actionInvocation.getAction()) instanceof ModelDriven && (model = ((ModelDriven)action).getModel()) != null && (msg = this.findMessage(model.getClass(), aTextName, indexedTextName, locale, args, null, valueStack)) != null) {
            return msg;
        }
        for (Class clazz = aClass; clazz != null && !clazz.equals(Object.class); clazz = clazz.getSuperclass()) {
            String basePackageName = clazz.getName();
            while (basePackageName.lastIndexOf(46) != -1) {
                String packageName = (basePackageName = basePackageName.substring(0, basePackageName.lastIndexOf(46))) + ".package";
                msg = this.getMessage(packageName, locale, aTextName, valueStack, args);
                if (msg != null) {
                    return msg;
                }
                if (indexedTextName == null || (msg = this.getMessage(packageName, locale, indexedTextName, valueStack, args)) == null) continue;
                return msg;
            }
        }
        int idx = aTextName.indexOf(".");
        if (idx != -1) {
            String newKey = null;
            String prop = null;
            if (aTextName.startsWith("invalid.fieldvalue.")) {
                idx = aTextName.indexOf(".", "invalid.fieldvalue.".length());
                if (idx != -1) {
                    prop = aTextName.substring("invalid.fieldvalue.".length(), idx);
                    newKey = "invalid.fieldvalue." + aTextName.substring(idx + 1);
                }
            } else {
                prop = aTextName.substring(0, idx);
                newKey = aTextName.substring(idx + 1);
            }
            if (prop != null) {
                Object obj = valueStack.findValue(prop);
                try {
                    Class<?> clazz;
                    PropertyDescriptor propertyDescriptor;
                    Object actionObj = ReflectionProviderFactory.getInstance().getRealTarget(prop, valueStack.getContext(), valueStack.getRoot());
                    if (actionObj != null && (propertyDescriptor = ReflectionProviderFactory.getInstance().getPropertyDescriptor(actionObj.getClass(), prop)) != null && (clazz = propertyDescriptor.getPropertyType()) != null) {
                        if (obj != null) {
                            valueStack.push(obj);
                        }
                        msg = this.findText(clazz, newKey, locale, null, args);
                        if (obj != null) {
                            valueStack.pop();
                        }
                        if (msg != null) {
                            return msg;
                        }
                    }
                }
                catch (Exception e) {
                    LOG.debug("unable to find property {}", (Object)prop, (Object)e);
                }
            }
        }
        if (indexedTextName == null) {
            result = this.getDefaultMessage(aTextName, locale, valueStack, args, defaultMessage);
        } else {
            result = this.getDefaultMessage(aTextName, locale, valueStack, args, null);
            if (result != null && result.message != null) {
                return result.message;
            }
            result = this.getDefaultMessage(indexedTextName, locale, valueStack, args, defaultMessage);
        }
        if (DefaultLocalizedTextProvider.unableToFindTextForKey(result) && LOG.isDebugEnabled()) {
            String warn = "Unable to find text for key '" + aTextName + "' ";
            if (indexedTextName != null) {
                warn = warn + " or indexed key '" + indexedTextName + "' ";
            }
            warn = warn + "in class '" + aClass.getName() + "' and locale '" + locale + "'";
            LOG.debug(warn);
        }
        return result != null ? result.message : null;
    }

    private static boolean unableToFindTextForKey(GetDefaultMessageReturnArg result) {
        if (result == null || result.message == null) {
            return true;
        }
        return !result.foundInBundle;
    }

    @Override
    public String findText(ResourceBundle bundle, String aTextName, Locale locale) {
        return this.findText(bundle, aTextName, locale, aTextName, new Object[0]);
    }

    @Override
    public String findText(ResourceBundle bundle, String aTextName, Locale locale, String defaultMessage, Object[] args) {
        ValueStack valueStack = ActionContext.getContext().getValueStack();
        return this.findText(bundle, aTextName, locale, defaultMessage, args, valueStack);
    }

    @Override
    public String findText(ResourceBundle bundle, String aTextName, Locale locale, String defaultMessage, Object[] args, ValueStack valueStack) {
        try {
            this.reloadBundles(valueStack.getContext());
            String message = TextParseUtil.translateVariables(bundle.getString(aTextName), valueStack);
            MessageFormat mf = this.buildMessageFormat(message, locale);
            return this.formatWithNullDetection(mf, args);
        }
        catch (MissingResourceException ex) {
            if (this.devMode) {
                LOG.warn("Missing key [{}] in bundle [{}]!", (Object)aTextName, (Object)bundle);
            } else {
                LOG.debug("Missing key [{}] in bundle [{}]!", (Object)aTextName, (Object)bundle);
            }
            GetDefaultMessageReturnArg result = this.getDefaultMessage(aTextName, locale, valueStack, args, defaultMessage);
            if (DefaultLocalizedTextProvider.unableToFindTextForKey(result)) {
                LOG.warn("Unable to find text for key '{}' in ResourceBundles for locale '{}'", (Object)aTextName, (Object)locale);
            }
            return result != null ? result.message : null;
        }
    }

    private GetDefaultMessageReturnArg getDefaultMessage(String key, Locale locale, ValueStack valueStack, Object[] args, String defaultMessage) {
        GetDefaultMessageReturnArg result = null;
        boolean found = true;
        if (key != null) {
            String message = this.findDefaultText(key, locale);
            if (message == null) {
                message = defaultMessage;
                found = false;
            }
            if (message != null) {
                MessageFormat mf = this.buildMessageFormat(TextParseUtil.translateVariables(message, valueStack), locale);
                String msg = this.formatWithNullDetection(mf, args);
                result = new GetDefaultMessageReturnArg(msg, found);
            }
        }
        return result;
    }

    private String getMessage(String bundleName, Locale locale, String key, ValueStack valueStack, Object[] args) {
        ResourceBundle bundle = this.findResourceBundle(bundleName, locale);
        if (bundle == null) {
            return null;
        }
        if (valueStack != null) {
            this.reloadBundles(valueStack.getContext());
        }
        try {
            String message = bundle.getString(key);
            if (valueStack != null) {
                message = TextParseUtil.translateVariables(bundle.getString(key), valueStack);
            }
            MessageFormat mf = this.buildMessageFormat(message, locale);
            return this.formatWithNullDetection(mf, args);
        }
        catch (MissingResourceException e) {
            if (this.devMode) {
                LOG.warn("Missing key [{}] in bundle [{}]!", (Object)key, (Object)bundleName);
            } else {
                LOG.debug("Missing key [{}] in bundle [{}]!", (Object)key, (Object)bundleName);
            }
            return null;
        }
    }

    private String formatWithNullDetection(MessageFormat mf, Object[] args) {
        String message = mf.format(args);
        if ("null".equals(message)) {
            return null;
        }
        return message;
    }

    private MessageFormat buildMessageFormat(String pattern, Locale locale) {
        MessageFormatKey key = new MessageFormatKey(pattern, locale);
        MessageFormat format = (MessageFormat)this.messageFormats.get(key);
        if (format == null) {
            format = new MessageFormat(pattern);
            format.setLocale(locale);
            format.applyPattern(pattern);
            this.messageFormats.put(key, format);
        }
        return format;
    }

    private String findMessage(Class clazz, String key, String indexedKey, Locale locale, Object[] args, Set<String> checked, ValueStack valueStack) {
        Class<?>[] interfaces;
        if (checked == null) {
            checked = new TreeSet<String>();
        } else if (checked.contains(clazz.getName())) {
            return null;
        }
        String msg = this.getMessage(clazz.getName(), locale, key, valueStack, args);
        if (msg != null) {
            return msg;
        }
        if (indexedKey != null && (msg = this.getMessage(clazz.getName(), locale, indexedKey, valueStack, args)) != null) {
            return msg;
        }
        for (Class<?> anInterface : interfaces = clazz.getInterfaces()) {
            msg = this.getMessage(anInterface.getName(), locale, key, valueStack, args);
            if (msg != null) {
                return msg;
            }
            if (indexedKey == null || (msg = this.getMessage(anInterface.getName(), locale, indexedKey, valueStack, args)) == null) continue;
            return msg;
        }
        if (clazz.isInterface()) {
            for (Class<?> anInterface : interfaces = clazz.getInterfaces()) {
                msg = this.findMessage(anInterface, key, indexedKey, locale, args, checked, valueStack);
                if (msg == null) continue;
                return msg;
            }
        } else if (!clazz.equals(Object.class) && !clazz.isPrimitive()) {
            return this.findMessage(clazz.getSuperclass(), key, indexedKey, locale, args, checked, valueStack);
        }
        return null;
    }

    private void reloadBundles() {
        this.reloadBundles(ActionContext.getContext() != null ? ActionContext.getContext().getContextMap() : null);
    }

    private void reloadBundles(Map<String, Object> context) {
        block6: {
            if (this.reloadBundles) {
                try {
                    Boolean reloaded = context != null ? (Boolean)ObjectUtils.defaultIfNull((Object)context.get("com.opensymphony.xwork2.util.LocalizedTextUtil.reloaded"), (Object)Boolean.FALSE) : Boolean.FALSE;
                    if (reloaded.booleanValue()) break block6;
                    this.bundlesMap.clear();
                    try {
                        DefaultLocalizedTextProvider.clearMap(ResourceBundle.class, null, "cacheList");
                    }
                    catch (NoSuchFieldException e) {
                        DefaultLocalizedTextProvider.clearMap(ResourceBundle.class, null, "cache");
                    }
                    DefaultLocalizedTextProvider.clearTomcatCache();
                    if (context != null) {
                        context.put("com.opensymphony.xwork2.util.LocalizedTextUtil.reloaded", true);
                    }
                    LOG.debug("Resource bundles reloaded");
                }
                catch (Exception e) {
                    LOG.error("Could not reload resource bundles", (Throwable)e);
                }
            }
        }
    }

    private static void clearTomcatCache() {
        ClassLoader loader = DefaultLocalizedTextProvider.getCurrentThreadContextClassLoader();
        Class<?> cl = loader.getClass();
        try {
            if ("org.apache.catalina.loader.WebappClassLoader".equals(cl.getName())) {
                DefaultLocalizedTextProvider.clearMap(cl, loader, TOMCAT_RESOURCE_ENTRIES_FIELD);
            } else {
                LOG.debug("Class loader {} is not tomcat loader.", (Object)cl.getName());
            }
        }
        catch (NoSuchFieldException nsfe) {
            if ("org.apache.catalina.loader.WebappClassLoaderBase".equals(cl.getSuperclass().getName())) {
                LOG.debug("Base class {} doesn't contain '{}' field, trying with parent!", (Object)cl.getName(), (Object)TOMCAT_RESOURCE_ENTRIES_FIELD, (Object)nsfe);
                try {
                    DefaultLocalizedTextProvider.clearMap(cl.getSuperclass(), loader, TOMCAT_RESOURCE_ENTRIES_FIELD);
                }
                catch (Exception e) {
                    LOG.warn("Couldn't clear tomcat cache using {}", (Object)cl.getSuperclass().getName(), (Object)e);
                }
            }
        }
        catch (Exception e) {
            LOG.warn("Couldn't clear tomcat cache", (Object)cl.getName(), (Object)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void clearMap(Class cl, Object obj, String name) throws NoSuchFieldException, IllegalAccessException, NoSuchMethodException, InvocationTargetException {
        Object cache;
        Field field = cl.getDeclaredField(name);
        field.setAccessible(true);
        Object object = cache = field.get(obj);
        synchronized (object) {
            Class<?> ccl = cache.getClass();
            Method clearMethod = ccl.getMethod("clear", new Class[0]);
            clearMethod.invoke(cache, new Object[0]);
        }
    }

    @Deprecated
    public void reset() {
    }

    private static ClassLoader getCurrentThreadContextClassLoader() {
        return Thread.currentThread().getContextClassLoader();
    }

    private static class EmptyResourceBundle
    extends ResourceBundle {
        private EmptyResourceBundle() {
        }

        @Override
        public Enumeration<String> getKeys() {
            return null;
        }

        @Override
        protected Object handleGetObject(String key) {
            return null;
        }
    }

    static class GetDefaultMessageReturnArg {
        String message;
        boolean foundInBundle;

        public GetDefaultMessageReturnArg(String message, boolean foundInBundle) {
            this.message = message;
            this.foundInBundle = foundInBundle;
        }
    }

    static class MessageFormatKey {
        String pattern;
        Locale locale;

        MessageFormatKey(String pattern, Locale locale) {
            this.pattern = pattern;
            this.locale = locale;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof MessageFormatKey)) {
                return false;
            }
            MessageFormatKey messageFormatKey = (MessageFormatKey)o;
            if (this.locale != null ? !this.locale.equals(messageFormatKey.locale) : messageFormatKey.locale != null) {
                return false;
            }
            return !(this.pattern != null ? !this.pattern.equals(messageFormatKey.pattern) : messageFormatKey.pattern != null);
        }

        public int hashCode() {
            int result = this.pattern != null ? this.pattern.hashCode() : 0;
            result = 29 * result + (this.locale != null ? this.locale.hashCode() : 0);
            return result;
        }
    }
}

