/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts2.interceptor.validation;

import com.opensymphony.xwork2.ActionInvocation;
import com.opensymphony.xwork2.config.ConfigurationException;
import com.opensymphony.xwork2.util.AnnotationUtils;
import com.opensymphony.xwork2.validator.ValidationInterceptor;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.struts2.interceptor.validation.SkipValidation;

public class AnnotationValidationInterceptor
extends ValidationInterceptor {
    private static final Logger LOG = LogManager.getLogger(AnnotationValidationInterceptor.class);

    @Override
    protected String doIntercept(ActionInvocation invocation) throws Exception {
        Object action = invocation.getAction();
        if (action != null) {
            Method method = this.getActionMethod(action.getClass(), invocation.getProxy().getMethod());
            Collection<Method> annotatedMethods = AnnotationUtils.getAnnotatedMethods(action.getClass(), SkipValidation.class);
            if (annotatedMethods.contains(method)) {
                return invocation.invoke();
            }
            LOG.debug("Check if method overrides an annotated method");
            for (Class<?> clazz = action.getClass().getSuperclass(); clazz != null; clazz = clazz.getSuperclass()) {
                annotatedMethods = AnnotationUtils.getAnnotatedMethods(clazz, SkipValidation.class);
                if (annotatedMethods == null) continue;
                for (Method annotatedMethod : annotatedMethods) {
                    if (!annotatedMethod.getName().equals(method.getName()) || !Arrays.equals(annotatedMethod.getParameterTypes(), method.getParameterTypes()) || !Arrays.equals(annotatedMethod.getExceptionTypes(), method.getExceptionTypes())) continue;
                    return invocation.invoke();
                }
            }
        }
        return super.doIntercept(invocation);
    }

    protected Method getActionMethod(Class<?> actionClass, String methodName) {
        try {
            return actionClass.getMethod(methodName, new Class[0]);
        }
        catch (NoSuchMethodException e) {
            throw new ConfigurationException("Wrong method was defined as an action method: " + methodName, e);
        }
    }
}

