/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.xwork2.util;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.ClassUtils;

public class AnnotationUtils {
    private static final Pattern SETTER_PATTERN = Pattern.compile("set([A-Z][A-Za-z0-9]*)$");
    private static final Pattern GETTER_PATTERN = Pattern.compile("(get|is|has)([A-Z][A-Za-z0-9]*)$");

    public static void addAllFields(Class<? extends Annotation> annotationClass, Class clazz, List<Field> allFields) {
        Field[] fields;
        if (clazz == null) {
            return;
        }
        for (Field field : fields = clazz.getDeclaredFields()) {
            Annotation ann = field.getAnnotation(annotationClass);
            if (ann == null) continue;
            allFields.add(field);
        }
        AnnotationUtils.addAllFields(annotationClass, clazz.getSuperclass(), allFields);
    }

    public static void addAllMethods(Class<? extends Annotation> annotationClass, Class clazz, List<Method> allMethods) {
        Method[] methods;
        if (clazz == null) {
            return;
        }
        for (Method method : methods = clazz.getDeclaredMethods()) {
            Annotation ann = method.getAnnotation(annotationClass);
            if (ann == null) continue;
            allMethods.add(method);
        }
        AnnotationUtils.addAllMethods(annotationClass, clazz.getSuperclass(), allMethods);
    }

    public static void addAllInterfaces(Class clazz, List<Class> allInterfaces) {
        if (clazz == null) {
            return;
        }
        Class<?>[] interfaces = clazz.getInterfaces();
        allInterfaces.addAll(Arrays.asList(interfaces));
        AnnotationUtils.addAllInterfaces(clazz.getSuperclass(), allInterfaces);
    }

    @Deprecated
    public static Collection<Method> getAnnotatedMethods(Class clazz, Class<? extends Annotation> ... annotation) {
        List allSuperclasses = ClassUtils.getAllSuperclasses((Class)clazz);
        allSuperclasses.add(0, clazz);
        int sci = 0;
        List allInterfaces = ClassUtils.getAllInterfaces((Class)clazz);
        int ifi = 0;
        ArrayList<Method> annotatedMethods = new ArrayList<Method>();
        while (ifi < allInterfaces.size() || sci < allSuperclasses.size()) {
            Method[] allMethods;
            Class acls = ifi >= allInterfaces.size() ? (Class)allSuperclasses.get(sci++) : (sci >= allSuperclasses.size() ? (Class)allInterfaces.get(ifi++) : (sci <= ifi ? (Class)allSuperclasses.get(sci++) : (Class)allInterfaces.get(ifi++)));
            for (Method method : allMethods = acls.getDeclaredMethods()) {
                if (ArrayUtils.isEmpty((Object[])annotation) && ArrayUtils.isNotEmpty((Object[])method.getAnnotations())) {
                    annotatedMethods.add(method);
                    continue;
                }
                for (Class<? extends Annotation> c : annotation) {
                    if (method.getAnnotation(c) == null) continue;
                    annotatedMethods.add(method);
                }
            }
        }
        return annotatedMethods;
    }

    @Deprecated
    public static <A extends Annotation> A findAnnotation(Method method, Class<A> annotationCls) {
        A annotation = method.getAnnotation(annotationCls);
        if (annotation == null) {
            Class<?> mcls = method.getDeclaringClass();
            List allSuperclasses = ClassUtils.getAllSuperclasses(mcls);
            int sci = 0;
            List allInterfaces = ClassUtils.getAllInterfaces(mcls);
            int ifi = 0;
            while (ifi < allInterfaces.size() || sci < allSuperclasses.size()) {
                Class acls = ifi >= allInterfaces.size() ? (Class)allSuperclasses.get(sci++) : (sci >= allSuperclasses.size() ? (Class)allInterfaces.get(ifi++) : (ifi <= sci ? (Class)allInterfaces.get(ifi++) : (Class)allSuperclasses.get(sci++)));
                Method equivalentMethod = null;
                try {
                    equivalentMethod = acls.getDeclaredMethod(method.getName(), method.getParameterTypes());
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    // empty catch block
                }
                if (equivalentMethod == null || (annotation = equivalentMethod.getAnnotation(annotationCls)) == null) continue;
                break;
            }
        }
        return annotation;
    }

    public static String resolvePropertyName(Method method) {
        Matcher matcher = SETTER_PATTERN.matcher(method.getName());
        if (matcher.matches() && method.getParameterTypes().length == 1) {
            String raw = matcher.group(1);
            return raw.substring(0, 1).toLowerCase() + raw.substring(1);
        }
        matcher = GETTER_PATTERN.matcher(method.getName());
        if (matcher.matches() && method.getParameterTypes().length == 0) {
            String raw = matcher.group(2);
            return raw.substring(0, 1).toLowerCase() + raw.substring(1);
        }
        return null;
    }

    public static <T extends Annotation> T findAnnotation(Class<?> clazz, Class<T> annotationClass) {
        T ann = clazz.getAnnotation(annotationClass);
        while (ann == null && clazz != null) {
            ann = clazz.getAnnotation(annotationClass);
            if (ann == null) {
                ann = clazz.getPackage().getAnnotation(annotationClass);
            }
            if (ann != null || (clazz = clazz.getSuperclass()) == null) continue;
            ann = clazz.getAnnotation(annotationClass);
        }
        return ann;
    }
}

