/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.xwork2.util;

import com.opensymphony.xwork2.util.ClassLoaderUtil;
import java.lang.reflect.Proxy;
import org.apache.commons.lang3.reflect.MethodUtils;

public class ProxyUtil {
    private static final String SPRING_ADVISED_CLASS_NAME = "org.springframework.aop.framework.Advised";
    private static final String SPRING_SPRINGPROXY_CLASS_NAME = "org.springframework.aop.SpringProxy";

    public static <T> T getSpringUltimateTargetObject(Object candidate) {
        try {
            if (ProxyUtil.isSpringAopProxy(candidate) && ProxyUtil.implementsInterface(candidate.getClass(), SPRING_ADVISED_CLASS_NAME)) {
                Object targetSource = MethodUtils.invokeMethod((Object)candidate, (String)"getTargetSource");
                Object target = MethodUtils.invokeMethod((Object)targetSource, (String)"getTarget");
                return ProxyUtil.getSpringUltimateTargetObject(target);
            }
        }
        catch (Throwable ex) {
            throw new IllegalStateException("Failed to unwrap proxied object", ex);
        }
        return (T)candidate;
    }

    public static boolean isSpringAopProxy(Object object) {
        Class<?> clazz = object.getClass();
        return ProxyUtil.implementsInterface(clazz, SPRING_SPRINGPROXY_CLASS_NAME) && (Proxy.isProxyClass(clazz) || ProxyUtil.isCglibProxyClass(clazz));
    }

    private static boolean isCglibProxyClass(Class<?> clazz) {
        return clazz != null && clazz.getName().contains("$$");
    }

    private static boolean implementsInterface(Class<?> clazz, String ifaceClassName) {
        try {
            Class ifaceClass = ClassLoaderUtil.loadClass(ifaceClassName, ProxyUtil.class);
            return ifaceClass.isAssignableFrom(clazz);
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }
}

