/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.xwork2.config.providers;

import com.opensymphony.xwork2.FileManager;
import com.opensymphony.xwork2.FileManagerFactory;
import com.opensymphony.xwork2.ObjectFactory;
import com.opensymphony.xwork2.XWorkException;
import com.opensymphony.xwork2.config.Configuration;
import com.opensymphony.xwork2.config.ConfigurationException;
import com.opensymphony.xwork2.config.ConfigurationProvider;
import com.opensymphony.xwork2.config.ConfigurationUtil;
import com.opensymphony.xwork2.config.entities.ActionConfig;
import com.opensymphony.xwork2.config.entities.ExceptionMappingConfig;
import com.opensymphony.xwork2.config.entities.InterceptorConfig;
import com.opensymphony.xwork2.config.entities.InterceptorMapping;
import com.opensymphony.xwork2.config.entities.InterceptorStackConfig;
import com.opensymphony.xwork2.config.entities.PackageConfig;
import com.opensymphony.xwork2.config.entities.ResultConfig;
import com.opensymphony.xwork2.config.entities.ResultTypeConfig;
import com.opensymphony.xwork2.config.entities.UnknownHandlerConfig;
import com.opensymphony.xwork2.config.impl.LocatableFactory;
import com.opensymphony.xwork2.config.providers.CycleDetector;
import com.opensymphony.xwork2.config.providers.DirectedGraph;
import com.opensymphony.xwork2.config.providers.InterceptorBuilder;
import com.opensymphony.xwork2.config.providers.ValueSubstitutor;
import com.opensymphony.xwork2.config.providers.XmlHelper;
import com.opensymphony.xwork2.inject.ContainerBuilder;
import com.opensymphony.xwork2.inject.Inject;
import com.opensymphony.xwork2.inject.Scope;
import com.opensymphony.xwork2.util.ClassLoaderUtil;
import com.opensymphony.xwork2.util.ClassPathFinder;
import com.opensymphony.xwork2.util.DomHelper;
import com.opensymphony.xwork2.util.TextParseUtil;
import com.opensymphony.xwork2.util.location.LocatableProperties;
import com.opensymphony.xwork2.util.location.Location;
import com.opensymphony.xwork2.util.location.LocationUtils;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class XmlConfigurationProvider
implements ConfigurationProvider {
    private static final Logger LOG = LogManager.getLogger(XmlConfigurationProvider.class);
    private List<Document> documents;
    private Set<String> includedFileNames;
    private String configFileName;
    private ObjectFactory objectFactory;
    private final Set<String> loadedFileUrls = new HashSet<String>();
    private boolean errorIfMissing;
    private Map<String, String> dtdMappings;
    private Configuration configuration;
    private boolean throwExceptionOnDuplicateBeans = true;
    private final Map<String, Element> declaredPackages = new HashMap<String, Element>();
    private FileManager fileManager;
    private ValueSubstitutor valueSubstitutor;

    public XmlConfigurationProvider() {
        this("xwork.xml", true);
    }

    public XmlConfigurationProvider(String filename) {
        this(filename, true);
    }

    public XmlConfigurationProvider(String filename, boolean errorIfMissing) {
        this.configFileName = filename;
        this.errorIfMissing = errorIfMissing;
        HashMap<String, String> mappings = new HashMap<String, String>();
        mappings.put("-//Apache Struts//XWork 2.5//EN", "xwork-2.5.dtd");
        mappings.put("-//Apache Struts//XWork 2.3//EN", "xwork-2.3.dtd");
        mappings.put("-//Apache Struts//XWork 2.1.3//EN", "xwork-2.1.3.dtd");
        mappings.put("-//Apache Struts//XWork 2.1//EN", "xwork-2.1.dtd");
        mappings.put("-//Apache Struts//XWork 2.0//EN", "xwork-2.0.dtd");
        mappings.put("-//Apache Struts//XWork 1.1.1//EN", "xwork-1.1.1.dtd");
        mappings.put("-//Apache Struts//XWork 1.1//EN", "xwork-1.1.dtd");
        mappings.put("-//Apache Struts//XWork 1.0//EN", "xwork-1.0.dtd");
        this.setDtdMappings(mappings);
    }

    public void setThrowExceptionOnDuplicateBeans(boolean val) {
        this.throwExceptionOnDuplicateBeans = val;
    }

    public void setDtdMappings(Map<String, String> mappings) {
        this.dtdMappings = Collections.unmodifiableMap(mappings);
    }

    @Inject
    public void setObjectFactory(ObjectFactory objectFactory) {
        this.objectFactory = objectFactory;
    }

    @Inject
    public void setFileManagerFactory(FileManagerFactory fileManagerFactory) {
        this.fileManager = fileManagerFactory.getFileManager();
    }

    @Inject(required=false)
    public void setValueSubstitutor(ValueSubstitutor valueSubstitutor) {
        this.valueSubstitutor = valueSubstitutor;
    }

    public Map<String, String> getDtdMappings() {
        return this.dtdMappings;
    }

    @Override
    public void init(Configuration configuration) {
        this.configuration = configuration;
        this.includedFileNames = configuration.getLoadedFileNames();
        this.loadDocuments(this.configFileName);
    }

    @Override
    public void destroy() {
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof XmlConfigurationProvider)) {
            return false;
        }
        XmlConfigurationProvider xmlConfigurationProvider = (XmlConfigurationProvider)o;
        return !(this.configFileName != null ? !this.configFileName.equals(xmlConfigurationProvider.configFileName) : xmlConfigurationProvider.configFileName != null);
    }

    public int hashCode() {
        return this.configFileName != null ? this.configFileName.hashCode() : 0;
    }

    private void loadDocuments(String configFileName) {
        try {
            this.loadedFileUrls.clear();
            this.documents = this.loadConfigurationFiles(configFileName, null);
        }
        catch (ConfigurationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ConfigurationException("Error loading configuration file " + configFileName, e);
        }
    }

    @Override
    public void register(ContainerBuilder containerBuilder, LocatableProperties props) throws ConfigurationException {
        LOG.trace("Parsing configuration file [{}]", (Object)this.configFileName);
        HashMap<String, Element> loadedBeans = new HashMap<String, Element>();
        for (Document doc : this.documents) {
            Element rootElement = doc.getDocumentElement();
            NodeList children = rootElement.getChildNodes();
            int childSize = children.getLength();
            for (int i = 0; i < childSize; ++i) {
                Node childNode = children.item(i);
                if (!(childNode instanceof Element)) continue;
                Element child = (Element)childNode;
                String nodeName = child.getNodeName();
                if ("bean".equals(nodeName)) {
                    String type = child.getAttribute("type");
                    String name = child.getAttribute("name");
                    String impl = child.getAttribute("class");
                    String onlyStatic = child.getAttribute("static");
                    String scopeStr = child.getAttribute("scope");
                    boolean optional = "true".equals(child.getAttribute("optional"));
                    Scope scope = Scope.SINGLETON;
                    if ("prototype".equals(scopeStr)) {
                        scope = Scope.PROTOTYPE;
                    } else if ("request".equals(scopeStr)) {
                        scope = Scope.REQUEST;
                    } else if ("session".equals(scopeStr)) {
                        scope = Scope.SESSION;
                    } else if ("singleton".equals(scopeStr)) {
                        scope = Scope.SINGLETON;
                    } else if ("thread".equals(scopeStr)) {
                        scope = Scope.THREAD;
                    }
                    if (StringUtils.isEmpty((CharSequence)name)) {
                        name = "default";
                    }
                    try {
                        Class classImpl;
                        Class classType = classImpl = ClassLoaderUtil.loadClass(impl, this.getClass());
                        if (StringUtils.isNotEmpty((CharSequence)type)) {
                            classType = ClassLoaderUtil.loadClass(type, this.getClass());
                        }
                        if ("true".equals(onlyStatic)) {
                            classImpl.getDeclaredClasses();
                            containerBuilder.injectStatics(classImpl);
                        } else {
                            if (containerBuilder.contains(classType, name)) {
                                Location loc = LocationUtils.getLocation(loadedBeans.get(classType.getName() + name));
                                if (this.throwExceptionOnDuplicateBeans) {
                                    throw new ConfigurationException("Bean type " + classType + " with the name " + name + " has already been loaded by " + loc, (Object)child);
                                }
                            }
                            classImpl.getDeclaredConstructors();
                            LOG.debug("Loaded type: {} name: {} impl: {}", (Object)type, (Object)name, (Object)impl);
                            containerBuilder.factory(classType, name, new LocatableFactory(name, classType, classImpl, scope, childNode), scope);
                        }
                        loadedBeans.put(classType.getName() + name, child);
                    }
                    catch (Throwable ex) {
                        if (!optional) {
                            throw new ConfigurationException("Unable to load bean: type:" + type + " class:" + impl, ex, childNode);
                        }
                        LOG.debug("Unable to load optional class: {}", (Object)impl);
                    }
                    continue;
                }
                if ("constant".equals(nodeName)) {
                    String name = child.getAttribute("name");
                    String value = child.getAttribute("value");
                    if (this.valueSubstitutor != null) {
                        LOG.debug("Substituting value [{}] using [{}]", (Object)value, (Object)this.valueSubstitutor.getClass().getName());
                        value = this.valueSubstitutor.substitute(value);
                    }
                    props.setProperty(name, value, childNode);
                    continue;
                }
                if (!nodeName.equals("unknown-handler-stack")) continue;
                ArrayList<UnknownHandlerConfig> unknownHandlerStack = new ArrayList<UnknownHandlerConfig>();
                NodeList unknownHandlers = child.getElementsByTagName("unknown-handler-ref");
                int unknownHandlersSize = unknownHandlers.getLength();
                for (int k = 0; k < unknownHandlersSize; ++k) {
                    Element unknownHandler = (Element)unknownHandlers.item(k);
                    Location location = LocationUtils.getLocation(unknownHandler);
                    unknownHandlerStack.add(new UnknownHandlerConfig(unknownHandler.getAttribute("name"), location));
                }
                if (unknownHandlerStack.isEmpty()) continue;
                this.configuration.setUnknownHandlerStack(unknownHandlerStack);
            }
        }
    }

    @Override
    public void loadPackages() throws ConfigurationException {
        ArrayList<Element> reloads = new ArrayList<Element>();
        this.verifyPackageStructure();
        for (Document doc : this.documents) {
            Element rootElement = doc.getDocumentElement();
            NodeList children = rootElement.getChildNodes();
            int childSize = children.getLength();
            for (int i = 0; i < childSize; ++i) {
                PackageConfig cfg;
                Element child;
                String nodeName;
                Node childNode = children.item(i);
                if (!(childNode instanceof Element) || !"package".equals(nodeName = (child = (Element)childNode).getNodeName()) || !(cfg = this.addPackage(child)).isNeedsRefresh()) continue;
                reloads.add(child);
            }
            this.loadExtraConfiguration(doc);
        }
        if (reloads.size() > 0) {
            this.reloadRequiredPackages(reloads);
        }
        for (Document doc : this.documents) {
            this.loadExtraConfiguration(doc);
        }
        this.documents.clear();
        this.declaredPackages.clear();
        this.configuration = null;
    }

    private void verifyPackageStructure() {
        DirectedGraph<String> graph = new DirectedGraph<String>();
        for (Document doc : this.documents) {
            Element rootElement = doc.getDocumentElement();
            NodeList children = rootElement.getChildNodes();
            int childSize = children.getLength();
            for (int i = 0; i < childSize; ++i) {
                Element child;
                String nodeName;
                Node childNode = children.item(i);
                if (!(childNode instanceof Element) || !"package".equals(nodeName = (child = (Element)childNode).getNodeName())) continue;
                String packageName = child.getAttribute("name");
                this.declaredPackages.put(packageName, child);
                graph.addNode(packageName);
                String extendsAttribute = child.getAttribute("extends");
                List<String> parents = ConfigurationUtil.buildParentListFromString(extendsAttribute);
                for (String parent : parents) {
                    graph.addNode(parent);
                    graph.addEdge(packageName, parent);
                }
            }
        }
        CycleDetector detector = new CycleDetector(graph);
        if (detector.containsCycle()) {
            StringBuilder builder = new StringBuilder("The following packages participate in cycles:");
            for (String packageName : detector.getVerticesInCycles()) {
                builder.append(" ");
                builder.append(packageName);
            }
            throw new ConfigurationException(builder.toString());
        }
    }

    private void reloadRequiredPackages(List<Element> reloads) {
        if (reloads.size() > 0) {
            ArrayList<Element> result = new ArrayList<Element>();
            for (Element pkg : reloads) {
                PackageConfig cfg = this.addPackage(pkg);
                if (!cfg.isNeedsRefresh()) continue;
                result.add(pkg);
            }
            if (result.size() > 0 && result.size() != reloads.size()) {
                this.reloadRequiredPackages(result);
                return;
            }
            if (result.size() > 0) {
                for (Element rp : result) {
                    List<PackageConfig> parents;
                    String parent = rp.getAttribute("extends");
                    if (parent == null || (parents = ConfigurationUtil.buildParentsFromString(this.configuration, parent)) == null || parents.size() > 0) continue;
                    LOG.error("Unable to find parent packages {}", (Object)parent);
                }
            }
        }
    }

    @Override
    public boolean needsReload() {
        for (String url : this.loadedFileUrls) {
            if (!this.fileManager.fileNeedsReloading(url)) continue;
            return true;
        }
        return false;
    }

    protected void addAction(Element actionElement, PackageConfig.Builder packageContext) throws ConfigurationException {
        Map<String, ResultConfig> results;
        String name = actionElement.getAttribute("name");
        String className = actionElement.getAttribute("class");
        String methodName = StringUtils.trimToNull((String)actionElement.getAttribute("method"));
        Location location = DomHelper.getLocationObject(actionElement);
        if (location == null) {
            LOG.warn("Location null for {}", (Object)className);
        }
        if (!StringUtils.isEmpty((CharSequence)className) && !this.verifyAction(className, name, location)) {
            LOG.error("Unable to verify action [{}] with class [{}], from [{}]", (Object)name, (Object)className, (Object)location);
            return;
        }
        try {
            results = this.buildResults(actionElement, packageContext);
        }
        catch (ConfigurationException e) {
            throw new ConfigurationException("Error building results for action " + name + " in namespace " + packageContext.getNamespace(), e, actionElement);
        }
        List<InterceptorMapping> interceptorList = this.buildInterceptorList(actionElement, packageContext);
        List<ExceptionMappingConfig> exceptionMappings = this.buildExceptionMappings(actionElement, packageContext);
        Set<String> allowedMethods = this.buildAllowedMethods(actionElement, packageContext);
        ActionConfig actionConfig = ((ActionConfig.Builder)new ActionConfig.Builder(packageContext.getName(), name, className).methodName(methodName).addResultConfigs(results).addInterceptors((List)interceptorList)).addExceptionMappings(exceptionMappings).addParams(XmlHelper.getParams(actionElement)).setStrictMethodInvocation(packageContext.isStrictMethodInvocation()).addAllowedMethod(allowedMethods).location(location).build();
        packageContext.addActionConfig(name, actionConfig);
        LOG.debug("Loaded {}{} in '{}' package: {}", (Object)(StringUtils.isNotEmpty((CharSequence)packageContext.getNamespace()) ? packageContext.getNamespace() + "/" : ""), (Object)name, (Object)packageContext.getName(), (Object)actionConfig);
    }

    protected boolean verifyAction(String className, String name, Location loc) {
        if (className.contains("{")) {
            LOG.debug("Action class [{}] contains a wildcard replacement value, so it can't be verified", (Object)className);
            return true;
        }
        try {
            if (this.objectFactory.isNoArgConstructorRequired()) {
                Class clazz = this.objectFactory.getClassInstance(className);
                if (!Modifier.isPublic(clazz.getModifiers())) {
                    throw new ConfigurationException("Action class [" + className + "] is not public", (Object)loc);
                }
                clazz.getConstructor(new Class[0]);
            }
        }
        catch (ClassNotFoundException e) {
            LOG.debug("Class not found for action [{}]", (Object)className, (Object)e);
            throw new ConfigurationException("Action class [" + className + "] not found", (Object)loc);
        }
        catch (NoSuchMethodException e) {
            LOG.debug("No constructor found for action [{}]", (Object)className, (Object)e);
            throw new ConfigurationException("Action class [" + className + "] does not have a public no-arg constructor", e, loc);
        }
        catch (RuntimeException ex) {
            LOG.info("Unable to verify action class [{}] exists at initialization", (Object)className);
            LOG.debug("Action verification cause", (Throwable)ex);
        }
        catch (Exception ex) {
            LOG.debug("Unable to verify action class [{}]", (Object)className, (Object)ex);
            throw new ConfigurationException(ex, (Object)loc);
        }
        return true;
    }

    protected PackageConfig addPackage(Element packageElement) throws ConfigurationException {
        String packageName = packageElement.getAttribute("name");
        PackageConfig packageConfig = this.configuration.getPackageConfig(packageName);
        if (packageConfig != null) {
            LOG.debug("Package [{}] already loaded, skipping re-loading it and using existing PackageConfig [{}]", (Object)packageName, (Object)packageConfig);
            return packageConfig;
        }
        PackageConfig.Builder newPackage = this.buildPackageContext(packageElement);
        if (newPackage.isNeedsRefresh()) {
            return newPackage.build();
        }
        LOG.debug("Loaded {}", (Object)newPackage);
        this.addResultTypes(newPackage, packageElement);
        this.loadInterceptors(newPackage, packageElement);
        this.loadDefaultInterceptorRef(newPackage, packageElement);
        this.loadDefaultClassRef(newPackage, packageElement);
        this.loadGlobalResults(newPackage, packageElement);
        this.loadGlobalAllowedMethods(newPackage, packageElement);
        this.loadGlobalExceptionMappings(newPackage, packageElement);
        NodeList actionList = packageElement.getElementsByTagName("action");
        for (int i = 0; i < actionList.getLength(); ++i) {
            Element actionElement = (Element)actionList.item(i);
            this.addAction(actionElement, newPackage);
        }
        this.loadDefaultActionRef(newPackage, packageElement);
        PackageConfig cfg = newPackage.build();
        this.configuration.addPackageConfig(cfg.getName(), cfg);
        return cfg;
    }

    protected void addResultTypes(PackageConfig.Builder packageContext, Element element) {
        NodeList resultTypeList = element.getElementsByTagName("result-type");
        for (int i = 0; i < resultTypeList.getLength(); ++i) {
            Element resultTypeElement = (Element)resultTypeList.item(i);
            String name = resultTypeElement.getAttribute("name");
            String className = resultTypeElement.getAttribute("class");
            String def = resultTypeElement.getAttribute("default");
            Location loc = DomHelper.getLocationObject(resultTypeElement);
            Class clazz = this.verifyResultType(className, loc);
            if (clazz == null) continue;
            String paramName = null;
            try {
                paramName = (String)clazz.getField("DEFAULT_PARAM").get(null);
            }
            catch (Throwable t) {
                LOG.debug("The result type [{}] doesn't have a default param [DEFAULT_PARAM] defined!", (Object)className, (Object)t);
            }
            ResultTypeConfig.Builder resultType = new ResultTypeConfig.Builder(name, className).defaultResultParam(paramName).location(DomHelper.getLocationObject(resultTypeElement));
            Map<String, String> params = XmlHelper.getParams(resultTypeElement);
            if (!params.isEmpty()) {
                resultType.addParams(params);
            }
            packageContext.addResultTypeConfig(resultType.build());
            if (!BooleanUtils.toBoolean((String)def)) continue;
            packageContext.defaultResultType(name);
        }
    }

    protected Class verifyResultType(String className, Location loc) {
        try {
            return this.objectFactory.getClassInstance(className);
        }
        catch (ClassNotFoundException | NoClassDefFoundError e) {
            LOG.warn("Result class [{}] doesn't exist ({}) at {}, ignoring", (Object)className, (Object)e.getClass().getSimpleName(), (Object)loc, (Object)e);
            return null;
        }
    }

    protected List<InterceptorMapping> buildInterceptorList(Element element, PackageConfig.Builder context) throws ConfigurationException {
        ArrayList<InterceptorMapping> interceptorList = new ArrayList<InterceptorMapping>();
        NodeList interceptorRefList = element.getElementsByTagName("interceptor-ref");
        for (int i = 0; i < interceptorRefList.getLength(); ++i) {
            Element interceptorRefElement = (Element)interceptorRefList.item(i);
            if (!interceptorRefElement.getParentNode().equals(element) && !interceptorRefElement.getParentNode().getNodeName().equals(element.getNodeName())) continue;
            List<InterceptorMapping> interceptors = this.lookupInterceptorReference(context, interceptorRefElement);
            interceptorList.addAll(interceptors);
        }
        return interceptorList;
    }

    protected PackageConfig.Builder buildPackageContext(Element packageElement) {
        String parent = packageElement.getAttribute("extends");
        String abstractVal = packageElement.getAttribute("abstract");
        boolean isAbstract = Boolean.parseBoolean(abstractVal);
        String name = StringUtils.defaultString((String)packageElement.getAttribute("name"));
        String namespace = StringUtils.defaultString((String)packageElement.getAttribute("namespace"));
        boolean strictDMI = true;
        if (packageElement.hasAttribute("strict-method-invocation")) {
            strictDMI = Boolean.parseBoolean(packageElement.getAttribute("strict-method-invocation"));
        }
        PackageConfig.Builder cfg = new PackageConfig.Builder(name).namespace(namespace).isAbstract(isAbstract).strictMethodInvocation(strictDMI).location(DomHelper.getLocationObject(packageElement));
        if (StringUtils.isNotEmpty((CharSequence)StringUtils.defaultString((String)parent))) {
            ArrayList<PackageConfig> parents = new ArrayList<PackageConfig>();
            for (String parentPackageName : ConfigurationUtil.buildParentListFromString(parent)) {
                if (this.configuration.getPackageConfigNames().contains(parentPackageName)) {
                    parents.add(this.configuration.getPackageConfig(parentPackageName));
                    continue;
                }
                if (this.declaredPackages.containsKey(parentPackageName)) {
                    if (this.configuration.getPackageConfig(parentPackageName) == null) {
                        this.addPackage(this.declaredPackages.get(parentPackageName));
                    }
                    parents.add(this.configuration.getPackageConfig(parentPackageName));
                    continue;
                }
                throw new ConfigurationException("Parent package is not defined: " + parentPackageName);
            }
            if (parents.size() <= 0) {
                cfg.needsRefresh(true);
            } else {
                cfg.addParents(parents);
            }
        }
        return cfg;
    }

    protected Map<String, ResultConfig> buildResults(Element element, PackageConfig.Builder packageContext) {
        NodeList resultEls = element.getElementsByTagName("result");
        LinkedHashMap<String, ResultConfig> results = new LinkedHashMap<String, ResultConfig>();
        for (int i = 0; i < resultEls.getLength(); ++i) {
            Element resultElement = (Element)resultEls.item(i);
            if (!resultElement.getParentNode().equals(element) && !resultElement.getParentNode().getNodeName().equals(element.getNodeName())) continue;
            String resultName = resultElement.getAttribute("name");
            String resultType = resultElement.getAttribute("type");
            if (StringUtils.isEmpty((CharSequence)resultName)) {
                resultName = "success";
            }
            if (StringUtils.isEmpty((CharSequence)resultType) && StringUtils.isEmpty((CharSequence)(resultType = packageContext.getFullDefaultResultType()))) {
                throw new ConfigurationException("No result type specified for result named '" + resultName + "', perhaps the parent package does not specify the result type?", (Object)resultElement);
            }
            ResultTypeConfig config = packageContext.getResultType(resultType);
            if (config == null) {
                throw new ConfigurationException("There is no result type defined for type '" + resultType + "' mapped with name '" + resultName + "'." + "  Did you mean '" + this.guessResultType(resultType) + "'?", (Object)resultElement);
            }
            String resultClass = config.getClassName();
            if (resultClass == null) {
                throw new ConfigurationException("Result type '" + resultType + "' is invalid");
            }
            Map<String, String> resultParams = XmlHelper.getParams(resultElement);
            if (resultParams.size() == 0 && resultElement.getChildNodes().getLength() >= 1) {
                resultParams = new LinkedHashMap<String, String>();
                String paramName = config.getDefaultResultParam();
                if (paramName != null) {
                    StringBuilder paramValue = new StringBuilder();
                    for (int j = 0; j < resultElement.getChildNodes().getLength(); ++j) {
                        String val;
                        if (resultElement.getChildNodes().item(j).getNodeType() != 3 || (val = resultElement.getChildNodes().item(j).getNodeValue()) == null) continue;
                        paramValue.append(val);
                    }
                    String val = paramValue.toString().trim();
                    if (val.length() > 0) {
                        resultParams.put(paramName, val);
                    }
                } else {
                    LOG.debug("No default parameter defined for result [{}] of type [{}] ", (Object)config.getName(), (Object)config.getClassName());
                }
            }
            LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
            Map<String, String> configParams = config.getParams();
            if (configParams != null) {
                params.putAll(configParams);
            }
            params.putAll(resultParams);
            Set<String> resultNamesSet = TextParseUtil.commaDelimitedStringToSet(resultName);
            if (resultNamesSet.isEmpty()) {
                resultNamesSet.add(resultName);
            }
            for (String name : resultNamesSet) {
                ResultConfig resultConfig = new ResultConfig.Builder(name, resultClass).addParams(params).location(DomHelper.getLocationObject(element)).build();
                results.put(resultConfig.getName(), resultConfig);
            }
        }
        return results;
    }

    protected String guessResultType(String type) {
        StringBuilder sb = null;
        if (type != null) {
            sb = new StringBuilder();
            boolean capNext = false;
            for (int x = 0; x < type.length(); ++x) {
                char c = type.charAt(x);
                if (c == '-') {
                    capNext = true;
                    continue;
                }
                if (Character.isLowerCase(c) && capNext) {
                    c = Character.toUpperCase(c);
                    capNext = false;
                }
                sb.append(c);
            }
        }
        return sb != null ? sb.toString() : null;
    }

    protected List<ExceptionMappingConfig> buildExceptionMappings(Element element, PackageConfig.Builder packageContext) {
        NodeList exceptionMappingEls = element.getElementsByTagName("exception-mapping");
        ArrayList<ExceptionMappingConfig> exceptionMappings = new ArrayList<ExceptionMappingConfig>();
        for (int i = 0; i < exceptionMappingEls.getLength(); ++i) {
            Element ehElement = (Element)exceptionMappingEls.item(i);
            if (!ehElement.getParentNode().equals(element) && !ehElement.getParentNode().getNodeName().equals(element.getNodeName())) continue;
            String emName = ehElement.getAttribute("name");
            String exceptionClassName = ehElement.getAttribute("exception");
            String exceptionResult = ehElement.getAttribute("result");
            Map<String, String> params = XmlHelper.getParams(ehElement);
            if (StringUtils.isEmpty((CharSequence)emName)) {
                emName = exceptionResult;
            }
            ExceptionMappingConfig ehConfig = new ExceptionMappingConfig.Builder(emName, exceptionClassName, exceptionResult).addParams(params).location(DomHelper.getLocationObject(ehElement)).build();
            exceptionMappings.add(ehConfig);
        }
        return exceptionMappings;
    }

    protected Set<String> buildAllowedMethods(Element element, PackageConfig.Builder packageContext) {
        HashSet<String> allowedMethods;
        NodeList allowedMethodsEls = element.getElementsByTagName("allowed-methods");
        if (allowedMethodsEls.getLength() > 0) {
            allowedMethods = new HashSet<String>(packageContext.getGlobalAllowedMethods());
            Node allowedMethodsNode = allowedMethodsEls.item(0);
            if (allowedMethodsNode != null) {
                NodeList allowedMethodsChildren = allowedMethodsNode.getChildNodes();
                StringBuilder allowedMethodsSB = new StringBuilder();
                for (int i = 0; i < allowedMethodsChildren.getLength(); ++i) {
                    Node allowedMethodsChildNode = allowedMethodsChildren.item(i);
                    if (allowedMethodsChildNode == null || allowedMethodsChildNode.getNodeType() != 3) continue;
                    String childNodeValue = allowedMethodsChildNode.getNodeValue();
                    String string = childNodeValue = childNodeValue != null ? childNodeValue.trim() : "";
                    if (childNodeValue.length() <= 0) continue;
                    allowedMethodsSB.append(childNodeValue);
                }
                if (allowedMethodsSB.length() > 0) {
                    allowedMethods.addAll(TextParseUtil.commaDelimitedStringToSet(allowedMethodsSB.toString()));
                }
            }
        } else if (packageContext.isStrictMethodInvocation()) {
            allowedMethods = new HashSet<String>(packageContext.getGlobalAllowedMethods());
        } else {
            allowedMethods = new HashSet();
            allowedMethods.add("*");
        }
        LOG.debug("Collected allowed methods: {}", allowedMethods);
        return Collections.unmodifiableSet(allowedMethods);
    }

    protected void loadDefaultInterceptorRef(PackageConfig.Builder packageContext, Element element) {
        NodeList resultTypeList = element.getElementsByTagName("default-interceptor-ref");
        if (resultTypeList.getLength() > 0) {
            Element defaultRefElement = (Element)resultTypeList.item(0);
            packageContext.defaultInterceptorRef(defaultRefElement.getAttribute("name"));
        }
    }

    protected void loadDefaultActionRef(PackageConfig.Builder packageContext, Element element) {
        NodeList resultTypeList = element.getElementsByTagName("default-action-ref");
        if (resultTypeList.getLength() > 0) {
            Element defaultRefElement = (Element)resultTypeList.item(0);
            packageContext.defaultActionRef(defaultRefElement.getAttribute("name"));
        }
    }

    protected void loadGlobalResults(PackageConfig.Builder packageContext, Element packageElement) {
        NodeList globalResultList = packageElement.getElementsByTagName("global-results");
        if (globalResultList.getLength() > 0) {
            Element globalResultElement = (Element)globalResultList.item(0);
            Map<String, ResultConfig> results = this.buildResults(globalResultElement, packageContext);
            packageContext.addGlobalResultConfigs(results);
        }
    }

    protected void loadGlobalAllowedMethods(PackageConfig.Builder packageContext, Element packageElement) {
        NodeList globalAllowedMethodsElms = packageElement.getElementsByTagName("global-allowed-methods");
        if (globalAllowedMethodsElms.getLength() > 0) {
            HashSet<String> globalAllowedMethods = new HashSet<String>();
            Node globaAllowedMethodsNode = globalAllowedMethodsElms.item(0);
            if (globaAllowedMethodsNode != null) {
                NodeList globaAllowedMethodsChildren = globaAllowedMethodsNode.getChildNodes();
                StringBuilder globalAllowedMethodsSB = new StringBuilder();
                for (int i = 0; i < globaAllowedMethodsChildren.getLength(); ++i) {
                    Node globalAllowedMethodsChildNode = globaAllowedMethodsChildren.item(i);
                    if (globalAllowedMethodsChildNode == null || globalAllowedMethodsChildNode.getNodeType() != 3) continue;
                    String childNodeValue = globalAllowedMethodsChildNode.getNodeValue();
                    String string = childNodeValue = childNodeValue != null ? childNodeValue.trim() : "";
                    if (childNodeValue.length() <= 0) continue;
                    globalAllowedMethodsSB.append(childNodeValue);
                }
                if (globalAllowedMethodsSB.length() > 0) {
                    globalAllowedMethods.addAll(TextParseUtil.commaDelimitedStringToSet(globalAllowedMethodsSB.toString()));
                }
            }
            packageContext.addGlobalAllowedMethods(globalAllowedMethods);
        }
    }

    protected void loadDefaultClassRef(PackageConfig.Builder packageContext, Element element) {
        NodeList defaultClassRefList = element.getElementsByTagName("default-class-ref");
        if (defaultClassRefList.getLength() > 0) {
            Element defaultClassRefElement = (Element)defaultClassRefList.item(0);
            packageContext.defaultClassRef(defaultClassRefElement.getAttribute("class"));
        }
    }

    protected void loadGlobalExceptionMappings(PackageConfig.Builder packageContext, Element packageElement) {
        NodeList globalExceptionMappingList = packageElement.getElementsByTagName("global-exception-mappings");
        if (globalExceptionMappingList.getLength() > 0) {
            Element globalExceptionMappingElement = (Element)globalExceptionMappingList.item(0);
            List<ExceptionMappingConfig> exceptionMappings = this.buildExceptionMappings(globalExceptionMappingElement, packageContext);
            packageContext.addGlobalExceptionMappingConfigs(exceptionMappings);
        }
    }

    protected InterceptorStackConfig loadInterceptorStack(Element element, PackageConfig.Builder context) throws ConfigurationException {
        String name = element.getAttribute("name");
        InterceptorStackConfig.Builder config = new InterceptorStackConfig.Builder(name).location(DomHelper.getLocationObject(element));
        NodeList interceptorRefList = element.getElementsByTagName("interceptor-ref");
        for (int j = 0; j < interceptorRefList.getLength(); ++j) {
            Element interceptorRefElement = (Element)interceptorRefList.item(j);
            List<InterceptorMapping> interceptors = this.lookupInterceptorReference(context, interceptorRefElement);
            config.addInterceptors((List)interceptors);
        }
        return config.build();
    }

    protected void loadInterceptorStacks(Element element, PackageConfig.Builder context) throws ConfigurationException {
        NodeList interceptorStackList = element.getElementsByTagName("interceptor-stack");
        for (int i = 0; i < interceptorStackList.getLength(); ++i) {
            Element interceptorStackElement = (Element)interceptorStackList.item(i);
            InterceptorStackConfig config = this.loadInterceptorStack(interceptorStackElement, context);
            context.addInterceptorStackConfig(config);
        }
    }

    protected void loadInterceptors(PackageConfig.Builder context, Element element) throws ConfigurationException {
        NodeList interceptorList = element.getElementsByTagName("interceptor");
        for (int i = 0; i < interceptorList.getLength(); ++i) {
            Element interceptorElement = (Element)interceptorList.item(i);
            String name = interceptorElement.getAttribute("name");
            String className = interceptorElement.getAttribute("class");
            Map<String, String> params = XmlHelper.getParams(interceptorElement);
            InterceptorConfig config = new InterceptorConfig.Builder(name, className).addParams(params).location(DomHelper.getLocationObject(interceptorElement)).build();
            context.addInterceptorConfig(config);
        }
        this.loadInterceptorStacks(element, context);
    }

    private List<Document> loadConfigurationFiles(String fileName, Element includeElement) {
        ArrayList<Document> docs = new ArrayList<Document>();
        ArrayList<Document> finalDocs = new ArrayList<Document>();
        if (!this.includedFileNames.contains(fileName)) {
            LOG.debug("Loading action configurations from: {}", (Object)fileName);
            this.includedFileNames.add(fileName);
            Iterator<URL> urls = null;
            InputStream is = null;
            IOException ioException = null;
            try {
                urls = this.getConfigurationUrls(fileName);
            }
            catch (IOException ex) {
                ioException = ex;
            }
            if (urls == null || !urls.hasNext()) {
                if (this.errorIfMissing) {
                    throw new ConfigurationException("Could not open files of the name " + fileName, ioException);
                }
                LOG.trace("Unable to locate configuration files of the name {}, skipping", (Object)fileName);
                return docs;
            }
            URL url = null;
            while (urls.hasNext()) {
                try {
                    url = urls.next();
                    is = this.fileManager.loadFile(url);
                    InputSource in = new InputSource(is);
                    in.setSystemId(url.toString());
                    docs.add(DomHelper.parse(in, this.dtdMappings));
                    this.loadedFileUrls.add(url.toString());
                }
                catch (XWorkException e) {
                    if (includeElement != null) {
                        throw new ConfigurationException("Unable to load " + url, e, includeElement);
                    }
                    throw new ConfigurationException("Unable to load " + url, e);
                }
                catch (Exception e) {
                    throw new ConfigurationException("Caught exception while loading file " + fileName, e, includeElement);
                }
                finally {
                    if (is == null) continue;
                    try {
                        is.close();
                    }
                    catch (IOException e) {
                        LOG.error("Unable to close input stream", (Throwable)e);
                    }
                }
            }
            Collections.sort(docs, new Comparator<Document>(){

                @Override
                public int compare(Document doc1, Document doc2) {
                    return XmlHelper.getLoadOrder(doc1).compareTo(XmlHelper.getLoadOrder(doc2));
                }
            });
            for (Document doc : docs) {
                Element rootElement = doc.getDocumentElement();
                NodeList children = rootElement.getChildNodes();
                int childSize = children.getLength();
                for (int i = 0; i < childSize; ++i) {
                    Element child;
                    String nodeName;
                    Node childNode = children.item(i);
                    if (!(childNode instanceof Element) || !"include".equals(nodeName = (child = (Element)childNode).getNodeName())) continue;
                    String includeFileName = child.getAttribute("file");
                    if (includeFileName.indexOf(42) != -1) {
                        ClassPathFinder wildcardFinder = new ClassPathFinder();
                        wildcardFinder.setPattern(includeFileName);
                        Vector<String> wildcardMatches = wildcardFinder.findMatches();
                        for (String match : wildcardMatches) {
                            finalDocs.addAll(this.loadConfigurationFiles(match, child));
                        }
                        continue;
                    }
                    finalDocs.addAll(this.loadConfigurationFiles(includeFileName, child));
                }
                finalDocs.add(doc);
            }
            LOG.debug("Loaded action configuration from: {}", (Object)fileName);
        }
        return finalDocs;
    }

    protected Iterator<URL> getConfigurationUrls(String fileName) throws IOException {
        return ClassLoaderUtil.getResources(fileName, XmlConfigurationProvider.class, false);
    }

    protected void loadExtraConfiguration(Document doc) {
    }

    private List<InterceptorMapping> lookupInterceptorReference(PackageConfig.Builder context, Element interceptorRefElement) throws ConfigurationException {
        String refName = interceptorRefElement.getAttribute("name");
        Map<String, String> refParams = XmlHelper.getParams(interceptorRefElement);
        Location loc = LocationUtils.getLocation(interceptorRefElement);
        return InterceptorBuilder.constructInterceptorReference(context, refName, refParams, loc, this.objectFactory);
    }

    List<Document> getDocuments() {
        return this.documents;
    }

    public String toString() {
        return "XmlConfigurationProvider{configFileName='" + this.configFileName + '\'' + '}';
    }
}

