/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts2.interceptor;

import com.opensymphony.xwork2.ActionContext;
import com.opensymphony.xwork2.ActionInvocation;
import java.io.Serializable;

public class BackgroundProcess
implements Serializable {
    private static final long serialVersionUID = 3884464776311686443L;
    protected Object action;
    protected ActionInvocation invocation;
    protected String result;
    protected Exception exception;
    protected boolean done;

    public BackgroundProcess(String threadName, final ActionInvocation invocation, int threadPriority) {
        this.invocation = invocation;
        this.action = invocation.getAction();
        try {
            Thread t = new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        BackgroundProcess.this.beforeInvocation();
                        BackgroundProcess.this.result = invocation.invokeActionOnly();
                        BackgroundProcess.this.afterInvocation();
                    }
                    catch (Exception e) {
                        BackgroundProcess.this.exception = e;
                    }
                    BackgroundProcess.this.done = true;
                }
            });
            t.setName(threadName);
            t.setPriority(threadPriority);
            t.start();
        }
        catch (Exception e) {
            this.exception = e;
        }
    }

    protected void beforeInvocation() throws Exception {
        ActionContext.setContext(this.invocation.getInvocationContext());
    }

    protected void afterInvocation() throws Exception {
        ActionContext.setContext(null);
    }

    public Object getAction() {
        return this.action;
    }

    public ActionInvocation getInvocation() {
        return this.invocation;
    }

    public String getResult() {
        return this.result;
    }

    public Exception getException() {
        return this.exception;
    }

    public boolean isDone() {
        return this.done;
    }
}

