/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts2.interceptor;

import com.opensymphony.xwork2.ActionInvocation;
import com.opensymphony.xwork2.LocaleProvider;
import com.opensymphony.xwork2.inject.Inject;
import com.opensymphony.xwork2.interceptor.AbstractInterceptor;
import com.opensymphony.xwork2.util.LocalizedTextUtil;
import java.util.Locale;
import java.util.Map;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletResponse;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.apache.struts2.ServletActionContext;
import org.apache.struts2.dispatcher.HttpParameters;
import org.apache.struts2.dispatcher.Parameter;

public class I18nInterceptor
extends AbstractInterceptor {
    private static final Logger LOG = LogManager.getLogger(I18nInterceptor.class);
    public static final String DEFAULT_SESSION_ATTRIBUTE = "WW_TRANS_I18N_LOCALE";
    public static final String DEFAULT_PARAMETER = "request_locale";
    public static final String DEFAULT_REQUEST_ONLY_PARAMETER = "request_only_locale";
    public static final String DEFAULT_COOKIE_ATTRIBUTE = "WW_TRANS_I18N_LOCALE";
    public static final String DEFAULT_COOKIE_PARAMETER = "request_cookie_locale";
    protected String parameterName = "request_locale";
    protected String requestOnlyParameterName = "request_only_locale";
    protected String attributeName = "WW_TRANS_I18N_LOCALE";
    protected String requestCookieParameterName = "request_cookie_locale";
    protected Storage storage = Storage.SESSION;
    protected LocaleProvider localeProvider;

    public void setParameterName(String parameterName) {
        this.parameterName = parameterName;
    }

    public void setAttributeName(String attributeName) {
        this.attributeName = attributeName;
    }

    public void setRequestOnlyParameterName(String requestOnlyParameterName) {
        this.requestOnlyParameterName = requestOnlyParameterName;
    }

    public void setRequestCookieParameterName(String requestCookieParameterName) {
        this.requestCookieParameterName = requestCookieParameterName;
    }

    public void setLocaleStorage(String storageName) {
        if (storageName == null || "".equals(storageName)) {
            this.storage = Storage.NONE;
        } else {
            try {
                this.storage = Storage.valueOf(storageName.toUpperCase());
            }
            catch (IllegalArgumentException e) {
                LOG.warn((Message)new ParameterizedMessage("Wrong storage name [{{}] was defined, falling back to {}", (Object)storageName, (Object)Storage.SESSION), (Throwable)e);
                this.storage = Storage.SESSION;
            }
        }
    }

    @Inject
    public void setLocaleProvider(LocaleProvider localeProvider) {
        this.localeProvider = localeProvider;
    }

    @Override
    public String intercept(ActionInvocation invocation) throws Exception {
        LOG.debug("Intercept '{}/{}'", (Object)invocation.getProxy().getNamespace(), (Object)invocation.getProxy().getActionName());
        RequestOnlyLocaleFinder localeFinder = this.getLocaleFinder(invocation);
        Locale locale = this.getLocaleFromParam(localeFinder.find());
        locale = this.storeLocale(invocation, locale);
        this.useLocale(invocation, locale);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Before action invocation Locale={}", invocation.getStack().findValue("locale"));
        }
        String result = invocation.invoke();
        if (LOG.isDebugEnabled()) {
            LOG.debug("After action invocation Locale={}", invocation.getStack().findValue("locale"));
        }
        return result;
    }

    protected RequestOnlyLocaleFinder getLocaleFinder(ActionInvocation invocation) {
        RequestOnlyLocaleFinder localeFinder = this.storage == Storage.COOKIE ? new CookieLocaleFinder(invocation) : (this.storage == Storage.SESSION ? new SessionLocaleFinder(invocation) : new RequestOnlyLocaleFinder(invocation));
        LOG.debug("Using LocaleFinder implementation {}", (Object)localeFinder.getClass().getName());
        return localeFinder;
    }

    protected Locale storeLocale(ActionInvocation invocation, Locale locale) {
        if (locale == null) {
            this.storage = Storage.NONE;
            locale = this.readStoredLocale(invocation);
        }
        if (this.storage == Storage.COOKIE) {
            this.storeLocaleInCookie(invocation, locale);
        }
        if (Storage.SESSION == this.storage) {
            this.storeLocaleInSession(invocation, locale);
        }
        return locale;
    }

    protected void storeLocaleInCookie(ActionInvocation ignore, Locale locale) {
        HttpServletResponse response = ServletActionContext.getResponse();
        Cookie cookie = new Cookie("WW_TRANS_I18N_LOCALE", locale.toString());
        cookie.setMaxAge(1209600);
        response.addCookie(cookie);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void storeLocaleInSession(ActionInvocation invocation, Locale locale) {
        Map<String, Object> session = invocation.getInvocationContext().getSession();
        if (session != null) {
            Map<String, Object> map = session;
            synchronized (map) {
                session.put(this.attributeName, locale);
            }
        }
    }

    protected Locale readStoredLocale(ActionInvocation invocation) {
        Locale locale = this.readStoredLocalFromSession(invocation);
        if (locale != null) {
            LOG.debug("Found stored Locale {} in session, using it!", (Object)locale);
            return locale;
        }
        Locale cookie = this.readStoredLocaleFromCookie(invocation);
        if (cookie != null) {
            LOG.debug("Found stored Locale {} in cookies, using it!", (Object)locale);
            return cookie;
        }
        LOG.debug("Neither locale was in session nor in cookies, searching current Invocation context");
        return this.readStoredLocalFromCurrentInvocation(invocation);
    }

    protected Locale getLocaleFromParam(Object requestedLocale) {
        Locale locale = null;
        if (requestedLocale != null) {
            if (requestedLocale instanceof Locale) {
                locale = (Locale)requestedLocale;
            } else {
                String localeStr = requestedLocale.toString();
                if (this.localeProvider.isValidLocaleString(localeStr)) {
                    locale = LocalizedTextUtil.localeFromString(requestedLocale.toString(), null);
                }
            }
            if (locale != null) {
                LOG.debug("Applied request locale: {}", (Object)locale);
            }
        }
        if (locale != null && !this.localeProvider.isValidLocale(locale)) {
            Locale defaultLocale = this.localeProvider.getLocale();
            LOG.debug("Provided locale {} isn't valid, fallback to default locale", (Object)locale, (Object)defaultLocale);
            locale = defaultLocale;
        }
        return locale;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Locale readStoredLocalFromSession(ActionInvocation invocation) {
        Map<String, Object> session = invocation.getInvocationContext().getSession();
        if (session != null) {
            Map<String, Object> map = session;
            synchronized (map) {
                Object sessionLocale = session.get(this.attributeName);
                if (sessionLocale != null && sessionLocale instanceof Locale) {
                    Locale locale = (Locale)sessionLocale;
                    LOG.debug("Applied session locale: {}", (Object)locale);
                    return locale;
                }
            }
        }
        return null;
    }

    protected Locale readStoredLocaleFromCookie(ActionInvocation ignore) {
        Cookie[] cookies = ServletActionContext.getRequest().getCookies();
        if (cookies != null) {
            for (Cookie cookie : cookies) {
                if (!"WW_TRANS_I18N_LOCALE".equals(cookie.getName())) continue;
                return this.getLocaleFromParam(cookie.getValue());
            }
        }
        return null;
    }

    protected Locale readStoredLocalFromCurrentInvocation(ActionInvocation invocation) {
        Locale locale = invocation.getInvocationContext().getLocale();
        if (locale != null) {
            LOG.debug("Applied invocation context locale: {}", (Object)locale);
        }
        return locale;
    }

    protected Parameter findLocaleParameter(HttpParameters params, String parameterName) {
        Parameter requestedLocale = params.get(parameterName);
        params.remove(parameterName);
        if (requestedLocale.isDefined()) {
            LOG.debug("Requested locale: {}", (Object)requestedLocale.getValue());
        }
        return requestedLocale;
    }

    protected void useLocale(ActionInvocation invocation, Locale locale) {
        invocation.getInvocationContext().setLocale(locale);
    }

    protected class CookieLocaleFinder
    extends RequestOnlyLocaleFinder {
        protected CookieLocaleFinder(ActionInvocation invocation) {
            super(invocation);
        }

        @Override
        public String find() {
            String requestOnlySessionLocale = super.find();
            if (requestOnlySessionLocale != null) {
                return requestOnlySessionLocale;
            }
            HttpParameters params = this.actionInvocation.getInvocationContext().getParameters();
            Parameter requestedLocale = I18nInterceptor.this.findLocaleParameter(params, I18nInterceptor.this.requestCookieParameterName);
            if (requestedLocale.isDefined()) {
                I18nInterceptor.this.storage = Storage.COOKIE;
                return requestedLocale.getValue();
            }
            return null;
        }
    }

    protected class SessionLocaleFinder
    extends RequestOnlyLocaleFinder {
        protected SessionLocaleFinder(ActionInvocation invocation) {
            super(invocation);
        }

        @Override
        public String find() {
            String requestOnlyLocale = super.find();
            if (requestOnlyLocale != null) {
                return requestOnlyLocale;
            }
            HttpParameters params = this.actionInvocation.getInvocationContext().getParameters();
            Parameter requestedLocale = I18nInterceptor.this.findLocaleParameter(params, I18nInterceptor.this.parameterName);
            if (requestedLocale.isDefined()) {
                return requestedLocale.getValue();
            }
            return requestedLocale.getValue();
        }
    }

    protected class RequestOnlyLocaleFinder {
        protected ActionInvocation actionInvocation = null;

        protected RequestOnlyLocaleFinder(ActionInvocation invocation) {
            this.actionInvocation = invocation;
        }

        public String find() {
            HttpParameters params = this.actionInvocation.getInvocationContext().getParameters();
            Parameter requestedLocale = I18nInterceptor.this.findLocaleParameter(params, I18nInterceptor.this.requestOnlyParameterName);
            if (requestedLocale.isDefined()) {
                I18nInterceptor.this.storage = Storage.NONE;
                return requestedLocale.getValue();
            }
            return null;
        }
    }

    protected static enum Storage {
        COOKIE,
        SESSION,
        NONE;

    }
}

