/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts2.components;

import java.io.Writer;
import java.util.Locale;
import java.util.ResourceBundle;
import org.apache.struts2.StrutsException;
import org.apache.struts2.components.Component;
import org.apache.struts2.views.annotations.StrutsTag;
import org.apache.struts2.views.annotations.StrutsTagAttribute;
import org.apache.struts2.xwork2.LocaleProvider;
import org.apache.struts2.xwork2.TextProvider;
import org.apache.struts2.xwork2.TextProviderFactory;
import org.apache.struts2.xwork2.inject.Container;
import org.apache.struts2.xwork2.inject.Inject;
import org.apache.struts2.xwork2.util.LocalizedTextUtil;
import org.apache.struts2.xwork2.util.ValueStack;
import org.apache.struts2.xwork2.util.logging.Logger;
import org.apache.struts2.xwork2.util.logging.LoggerFactory;

@StrutsTag(name="i18n", tldTagClass="org.apache.struts2.views.jsp.I18nTag", description="Get a resource bundle and place it on the value stack")
public class I18n
extends Component {
    private static final Logger LOG = LoggerFactory.getLogger(I18n.class);
    protected boolean pushed;
    protected String name;
    protected Container container;
    private TextProvider textProvider;

    public I18n(ValueStack stack) {
        super(stack);
    }

    @Inject
    public void setContainer(Container container) {
        this.container = container;
    }

    public boolean start(Writer writer) {
        boolean result = super.start(writer);
        try {
            String name = this.findString(this.name, "name", "Resource bundle name is required. Example: foo or foo_en");
            ResourceBundle bundle = (ResourceBundle)this.findValue("getTexts('" + name + "')");
            if (bundle == null) {
                bundle = LocalizedTextUtil.findResourceBundle((String)name, (Locale)((Locale)this.getStack().getContext().get("org.apache.struts2.xwork2.ActionContext.locale")));
            }
            if (bundle != null) {
                final Locale locale = (Locale)this.getStack().getContext().get("org.apache.struts2.xwork2.ActionContext.locale");
                TextProviderFactory tpf = new TextProviderFactory();
                this.container.inject((Object)tpf);
                this.textProvider = tpf.createInstance(bundle, new LocaleProvider(){

                    public Locale getLocale() {
                        return locale;
                    }
                });
                this.getStack().push((Object)this.textProvider);
                this.pushed = true;
            }
        }
        catch (Exception e) {
            String msg = "Could not find the bundle " + this.name;
            throw new StrutsException(msg, e);
        }
        return result;
    }

    public boolean end(Writer writer, String body) throws StrutsException {
        Object o;
        if (this.pushed && ((o = this.getStack().pop()) == null || !o.equals(this.textProvider))) {
            LOG.error("A closing i18n tag attempted to pop its own TextProvider from the top of the ValueStack but popped an unexpected object (" + (o != null ? o.getClass() : "null") + "). " + "Refactor the page within the i18n tags to ensure no objects are pushed onto the ValueStack without popping them prior to the closing tag. " + "If you see this message it's likely that the i18n's TextProvider is still on the stack and will continue to provide message resources after the closing tag.", new String[0]);
            throw new StrutsException("A closing i18n tag attempted to pop its TextProvider from the top of the ValueStack but popped an unexpected object (" + (o != null ? o.getClass() : "null") + ")");
        }
        return super.end(writer, body);
    }

    @StrutsTagAttribute(description="Name of resource bundle to use (eg foo/bar/customBundle)", required=true, defaultValue="String")
    public void setName(String name) {
        this.name = name;
    }
}

