/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts2.components;

import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import org.apache.struts2.components.ContextBean;
import org.apache.struts2.components.Param;
import org.apache.struts2.util.MakeIterator;
import org.apache.struts2.util.MergeIteratorFilter;
import org.apache.struts2.views.annotations.StrutsTag;
import org.apache.struts2.views.annotations.StrutsTagAttribute;
import org.apache.struts2.xwork2.util.ValueStack;
import org.apache.struts2.xwork2.util.logging.Logger;
import org.apache.struts2.xwork2.util.logging.LoggerFactory;

@StrutsTag(name="merge", tldTagClass="org.apache.struts2.views.jsp.iterator.MergeIteratorTag", description="Merge the values of a list of iterators into one iterator")
public class MergeIterator
extends ContextBean
implements Param.UnnamedParametric {
    private static final Logger LOG = LoggerFactory.getLogger(MergeIterator.class);
    private MergeIteratorFilter mergeIteratorFilter = null;
    private List _parameters;

    public MergeIterator(ValueStack stack) {
        super(stack);
    }

    public boolean start(Writer writer) {
        this.mergeIteratorFilter = new MergeIteratorFilter();
        this._parameters = new ArrayList();
        return super.start(writer);
    }

    public boolean end(Writer writer, String body) {
        for (Object iteratorEntryObj : this._parameters) {
            if (!MakeIterator.isIterable(iteratorEntryObj)) {
                if (!LOG.isWarnEnabled()) continue;
                LOG.warn("param with value resolved as " + iteratorEntryObj + " cannot be make as iterator, it will be ignored and hence will not appear in the merged iterator", new String[0]);
                continue;
            }
            this.mergeIteratorFilter.setSource(MakeIterator.convert(iteratorEntryObj));
        }
        this.mergeIteratorFilter.execute();
        this.putInContext(this.mergeIteratorFilter);
        this.mergeIteratorFilter = null;
        return super.end(writer, body);
    }

    @StrutsTagAttribute(description="The name where the resultant merged iterator will be stored in the stack's context")
    public void setVar(String var) {
        super.setVar(var);
    }

    public void addParameter(Object value) {
        this._parameters.add(value);
    }
}

