/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts2.dispatcher;

import java.io.IOException;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts2.dispatcher.Dispatcher;
import org.apache.struts2.dispatcher.StrutsResultSupport;
import org.apache.struts2.dispatcher.mapper.ActionMapper;
import org.apache.struts2.dispatcher.mapper.ActionMapping;
import org.apache.struts2.views.util.UrlHelper;
import org.apache.struts2.xwork2.ActionContext;
import org.apache.struts2.xwork2.ActionInvocation;
import org.apache.struts2.xwork2.config.entities.ResultConfig;
import org.apache.struts2.xwork2.inject.Inject;
import org.apache.struts2.xwork2.util.logging.Logger;
import org.apache.struts2.xwork2.util.logging.LoggerFactory;
import org.apache.struts2.xwork2.util.reflection.ReflectionException;
import org.apache.struts2.xwork2.util.reflection.ReflectionExceptionHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServletRedirectResult
extends StrutsResultSupport
implements ReflectionExceptionHandler {
    private static final long serialVersionUID = 6316947346435301270L;
    private static final Logger LOG = LoggerFactory.getLogger(ServletRedirectResult.class);
    protected boolean prependServletContext = true;
    protected ActionMapper actionMapper;
    protected int statusCode = 302;
    protected boolean suppressEmptyParameters = false;
    protected Map<String, String> requestParameters = new LinkedHashMap<String, String>();
    protected String anchor;

    public ServletRedirectResult() {
    }

    public ServletRedirectResult(String location) {
        this(location, null);
    }

    public ServletRedirectResult(String location, String anchor) {
        super(location);
        this.anchor = anchor;
    }

    @Inject
    public void setActionMapper(ActionMapper mapper) {
        this.actionMapper = mapper;
    }

    public void setStatusCode(int code) {
        this.statusCode = code;
    }

    public void setAnchor(String anchor) {
        this.anchor = anchor;
    }

    public void setPrependServletContext(boolean prependServletContext) {
        this.prependServletContext = prependServletContext;
    }

    @Override
    public void execute(ActionInvocation invocation) throws Exception {
        if (this.anchor != null) {
            this.anchor = this.conditionalParse(this.anchor, invocation);
        }
        super.execute(invocation);
    }

    @Override
    protected void doExecute(String finalLocation, ActionInvocation invocation) throws Exception {
        ActionContext ctx = invocation.getInvocationContext();
        HttpServletRequest request = (HttpServletRequest)ctx.get("org.apache.struts2.xwork2.dispatcher.HttpServletRequest");
        HttpServletResponse response = (HttpServletResponse)ctx.get("org.apache.struts2.xwork2.dispatcher.HttpServletResponse");
        if (ServletRedirectResult.isPathUrl(finalLocation)) {
            ResultConfig resultConfig;
            if (!finalLocation.startsWith("/")) {
                ActionMapping mapping = this.actionMapper.getMapping(request, Dispatcher.getInstance().getConfigurationManager());
                String namespace = null;
                if (mapping != null) {
                    namespace = mapping.getNamespace();
                }
                finalLocation = namespace != null && namespace.length() > 0 && !"/".equals(namespace) ? namespace + "/" + finalLocation : "/" + finalLocation;
            }
            if (this.prependServletContext && request.getContextPath() != null && request.getContextPath().length() > 0) {
                finalLocation = request.getContextPath() + finalLocation;
            }
            if ((resultConfig = (ResultConfig)invocation.getProxy().getConfig().getResults().get(invocation.getResultCode())) != null) {
                Map resultConfigParams = resultConfig.getParams();
                for (Map.Entry e : resultConfigParams.entrySet()) {
                    String potentialValue;
                    if (this.getProhibitedResultParams().contains(e.getKey())) continue;
                    String string = potentialValue = e.getValue() == null ? "" : this.conditionalParse((String)e.getValue(), invocation);
                    if (this.suppressEmptyParameters && (potentialValue == null || potentialValue.length() <= 0)) continue;
                    this.requestParameters.put((String)e.getKey(), potentialValue);
                }
            }
            StringBuilder tmpLocation = new StringBuilder(finalLocation);
            UrlHelper.buildParametersString(this.requestParameters, tmpLocation, "&");
            if (this.anchor != null) {
                tmpLocation.append('#').append(this.anchor);
            }
            finalLocation = response.encodeRedirectURL(tmpLocation.toString());
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Redirecting to finalLocation " + finalLocation, new String[0]);
        }
        this.sendRedirect(response, finalLocation);
    }

    protected List<String> getProhibitedResultParams() {
        return Arrays.asList("location", "namespace", "method", "encode", "parse", "location", "prependServletContext", "suppressEmptyParameters", "anchor");
    }

    protected void sendRedirect(HttpServletResponse response, String finalLocation) throws IOException {
        if (302 == this.statusCode) {
            response.sendRedirect(finalLocation);
        } else {
            response.setStatus(this.statusCode);
            response.setHeader("Location", finalLocation);
            response.getWriter().write(finalLocation);
            response.getWriter().close();
        }
    }

    private static boolean isPathUrl(String url) {
        return url.indexOf(58) == -1;
    }

    public void setSuppressEmptyParameters(boolean suppressEmptyParameters) {
        this.suppressEmptyParameters = suppressEmptyParameters;
    }

    public ServletRedirectResult addParameter(String key, Object value) {
        this.requestParameters.put(key, String.valueOf(value));
        return this;
    }

    public void handle(ReflectionException ex) {
        LOG.debug(ex.getMessage(), (Throwable)ex, new String[0]);
    }
}

