/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts2.dispatcher.mapper;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.struts2.RequestUtils;
import org.apache.struts2.dispatcher.ServletRedirectResult;
import org.apache.struts2.dispatcher.mapper.ActionMapper;
import org.apache.struts2.dispatcher.mapper.ActionMapping;
import org.apache.struts2.dispatcher.mapper.ParameterAction;
import org.apache.struts2.util.PrefixTrie;
import org.apache.struts2.xwork2.ActionContext;
import org.apache.struts2.xwork2.config.Configuration;
import org.apache.struts2.xwork2.config.ConfigurationManager;
import org.apache.struts2.xwork2.config.entities.PackageConfig;
import org.apache.struts2.xwork2.inject.Container;
import org.apache.struts2.xwork2.inject.Inject;

public class DefaultActionMapper
implements ActionMapper {
    protected static final String METHOD_PREFIX = "method:";
    protected static final String ACTION_PREFIX = "action:";
    protected static final String REDIRECT_PREFIX = "redirect:";
    protected static final String REDIRECT_ACTION_PREFIX = "redirectAction:";
    protected boolean allowDynamicMethodCalls = true;
    protected boolean allowSlashesInActionNames = false;
    protected boolean alwaysSelectFullNamespace = false;
    protected PrefixTrie prefixTrie = null;
    protected List<String> extensions = new ArrayList<String>(){
        {
            this.add("action");
            this.add("");
        }
    };
    protected Container container;

    public DefaultActionMapper() {
        this.prefixTrie = new PrefixTrie(){
            {
                this.put(DefaultActionMapper.METHOD_PREFIX, new ParameterAction(){

                    public void execute(String key, ActionMapping mapping) {
                        if (DefaultActionMapper.this.allowDynamicMethodCalls) {
                            mapping.setMethod(key.substring(DefaultActionMapper.METHOD_PREFIX.length()));
                        }
                    }
                });
                this.put(DefaultActionMapper.ACTION_PREFIX, new ParameterAction(){

                    public void execute(String key, ActionMapping mapping) {
                        int bang;
                        String name = key.substring(DefaultActionMapper.ACTION_PREFIX.length());
                        if (DefaultActionMapper.this.allowDynamicMethodCalls && (bang = name.indexOf(33)) != -1) {
                            String method = name.substring(bang + 1);
                            mapping.setMethod(method);
                            name = name.substring(0, bang);
                        }
                        mapping.setName(name);
                    }
                });
                this.put(DefaultActionMapper.REDIRECT_PREFIX, new ParameterAction(){

                    public void execute(String key, ActionMapping mapping) {
                        ServletRedirectResult redirect = new ServletRedirectResult();
                        DefaultActionMapper.this.container.inject((Object)redirect);
                        redirect.setLocation(key.substring(DefaultActionMapper.REDIRECT_PREFIX.length()));
                        mapping.setResult(redirect);
                    }
                });
                this.put(DefaultActionMapper.REDIRECT_ACTION_PREFIX, new ParameterAction(){

                    public void execute(String key, ActionMapping mapping) {
                        String location = key.substring(DefaultActionMapper.REDIRECT_ACTION_PREFIX.length());
                        ServletRedirectResult redirect = new ServletRedirectResult();
                        DefaultActionMapper.this.container.inject((Object)redirect);
                        String extension = DefaultActionMapper.this.getDefaultExtension();
                        if (extension != null && extension.length() > 0) {
                            location = location + "." + extension;
                        }
                        redirect.setLocation(location);
                        mapping.setResult(redirect);
                    }
                });
            }
        };
    }

    protected void addParameterAction(String prefix, ParameterAction parameterAction) {
        this.prefixTrie.put(prefix, parameterAction);
    }

    @Inject(value="struts.enable.DynamicMethodInvocation")
    public void setAllowDynamicMethodCalls(String allow) {
        this.allowDynamicMethodCalls = "true".equals(allow);
    }

    @Inject(value="struts.enable.SlashesInActionNames")
    public void setSlashesInActionNames(String allow) {
        this.allowSlashesInActionNames = "true".equals(allow);
    }

    @Inject(value="struts.mapper.alwaysSelectFullNamespace")
    public void setAlwaysSelectFullNamespace(String val) {
        this.alwaysSelectFullNamespace = "true".equals(val);
    }

    @Inject
    public void setContainer(Container container) {
        this.container = container;
    }

    @Inject(value="struts.action.extension")
    public void setExtensions(String extensions) {
        if (extensions != null && !"".equals(extensions)) {
            String[] tokens;
            ArrayList<String> list = new ArrayList<String>();
            for (String token : tokens = extensions.split(",")) {
                list.add(token);
            }
            if (extensions.endsWith(",")) {
                list.add("");
            }
            this.extensions = Collections.unmodifiableList(list);
        } else {
            this.extensions = null;
        }
    }

    public ActionMapping getMappingFromActionName(String actionName) {
        ActionMapping mapping = new ActionMapping();
        mapping.setName(actionName);
        return this.parseActionName(mapping);
    }

    public ActionMapping getMapping(HttpServletRequest request, ConfigurationManager configManager) {
        ActionMapping mapping = new ActionMapping();
        String uri = this.getUri(request);
        int indexOfSemicolon = uri.indexOf(";");
        uri = indexOfSemicolon > -1 ? uri.substring(0, indexOfSemicolon) : uri;
        if ((uri = this.dropExtension(uri, mapping)) == null) {
            return null;
        }
        this.parseNameAndNamespace(uri, mapping, configManager);
        this.handleSpecialParameters(request, mapping);
        if (mapping.getName() == null) {
            return null;
        }
        this.parseActionName(mapping);
        return mapping;
    }

    protected ActionMapping parseActionName(ActionMapping mapping) {
        String name;
        int exclamation;
        if (mapping.getName() == null) {
            return mapping;
        }
        if (this.allowDynamicMethodCalls && (exclamation = (name = mapping.getName()).lastIndexOf("!")) != -1) {
            mapping.setName(name.substring(0, exclamation));
            mapping.setMethod(name.substring(exclamation + 1));
        }
        return mapping;
    }

    public void handleSpecialParameters(HttpServletRequest request, ActionMapping mapping) {
        HashSet<String> uniqueParameters = new HashSet<String>();
        Map parameterMap = request.getParameterMap();
        for (String key : parameterMap.keySet()) {
            ParameterAction parameterAction;
            if (key.endsWith(".x") || key.endsWith(".y")) {
                key = key.substring(0, key.length() - 2);
            }
            if (uniqueParameters.contains(key) || (parameterAction = (ParameterAction)this.prefixTrie.get(key)) == null) continue;
            parameterAction.execute(key, mapping);
            uniqueParameters.add(key);
            break;
        }
    }

    protected void parseNameAndNamespace(String uri, ActionMapping mapping, ConfigurationManager configManager) {
        int pos;
        String name;
        String namespace;
        int lastSlash = uri.lastIndexOf("/");
        if (lastSlash == -1) {
            namespace = "";
            name = uri;
        } else if (lastSlash == 0) {
            namespace = "/";
            name = uri.substring(lastSlash + 1);
        } else if (this.alwaysSelectFullNamespace) {
            namespace = uri.substring(0, lastSlash);
            name = uri.substring(lastSlash + 1);
        } else {
            Configuration config = configManager.getConfiguration();
            String prefix = uri.substring(0, lastSlash);
            namespace = "";
            boolean rootAvailable = false;
            for (PackageConfig cfg : config.getPackageConfigs().values()) {
                String ns = cfg.getNamespace();
                if (ns != null && prefix.startsWith(ns) && (prefix.length() == ns.length() || prefix.charAt(ns.length()) == '/') && ns.length() > namespace.length()) {
                    namespace = ns;
                }
                if (!"/".equals(ns)) continue;
                rootAvailable = true;
            }
            name = uri.substring(namespace.length() + 1);
            if (rootAvailable && "".equals(namespace)) {
                namespace = "/";
            }
        }
        if (!this.allowSlashesInActionNames && name != null && (pos = name.lastIndexOf(47)) > -1 && pos < name.length() - 1) {
            name = name.substring(pos + 1);
        }
        mapping.setNamespace(namespace);
        mapping.setName(name);
    }

    protected String dropExtension(String name) {
        return this.dropExtension(name, new ActionMapping());
    }

    protected String dropExtension(String name, ActionMapping mapping) {
        if (this.extensions == null) {
            return name;
        }
        for (String ext : this.extensions) {
            if ("".equals(ext)) {
                int index = name.lastIndexOf(46);
                if (index != -1 && name.indexOf(47, index) < 0) continue;
                return name;
            }
            String extension = "." + ext;
            if (!name.endsWith(extension)) continue;
            name = name.substring(0, name.length() - extension.length());
            mapping.setExtension(ext);
            return name;
        }
        return null;
    }

    protected String getDefaultExtension() {
        if (this.extensions == null) {
            return null;
        }
        return this.extensions.get(0);
    }

    protected String getUri(HttpServletRequest request) {
        String uri = (String)request.getAttribute("javax.servlet.include.servlet_path");
        if (uri != null) {
            return uri;
        }
        uri = RequestUtils.getServletPath(request);
        if (uri != null && !"".equals(uri)) {
            return uri;
        }
        uri = request.getRequestURI();
        return uri.substring(request.getContextPath().length());
    }

    public String getUriFromActionMapping(ActionMapping mapping) {
        String extension;
        StringBuilder uri = new StringBuilder();
        if (mapping.getNamespace() != null) {
            uri.append(mapping.getNamespace());
            if (!"/".equals(mapping.getNamespace())) {
                uri.append("/");
            }
        }
        String name = mapping.getName();
        String params = "";
        if (name.indexOf(63) != -1) {
            params = name.substring(name.indexOf(63));
            name = name.substring(0, name.indexOf(63));
        }
        uri.append(name);
        if (null != mapping.getMethod() && !"".equals(mapping.getMethod())) {
            uri.append("!").append(mapping.getMethod());
        }
        if ((extension = mapping.getExtension()) == null) {
            ActionMapping orig;
            ActionContext context = ActionContext.getContext();
            if (context != null && (orig = (ActionMapping)context.get("struts.actionMapping")) != null) {
                extension = orig.getExtension();
            }
            if (extension == null) {
                extension = this.getDefaultExtension();
            }
        }
        if (extension != null && (extension.length() == 0 || extension.length() > 0 && uri.indexOf('.' + extension) == -1) && extension.length() > 0) {
            uri.append(".").append(extension);
        }
        if (params.length() > 0) {
            uri.append(params);
        }
        return uri.toString();
    }

    public boolean isSlashesInActionNames() {
        return this.allowSlashesInActionNames;
    }
}

