/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts2.interceptor;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.struts2.xwork2.ActionInvocation;
import org.apache.struts2.xwork2.interceptor.AbstractInterceptor;
import org.apache.struts2.xwork2.util.logging.Logger;
import org.apache.struts2.xwork2.util.logging.LoggerFactory;

public class CheckboxInterceptor
extends AbstractInterceptor {
    private static final long serialVersionUID = -586878104807229585L;
    private String uncheckedValue = Boolean.FALSE.toString();
    private static final Logger LOG = LoggerFactory.getLogger(CheckboxInterceptor.class);

    public String intercept(ActionInvocation ai) throws Exception {
        Map parameters = ai.getInvocationContext().getParameters();
        HashMap<String, String[]> newParams = new HashMap<String, String[]>();
        Set entries = parameters.entrySet();
        Iterator iterator = entries.iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            String key = (String)entry.getKey();
            if (!key.startsWith("__checkbox_")) continue;
            String name = key.substring("__checkbox_".length());
            Object values = entry.getValue();
            iterator.remove();
            if (values != null && values instanceof String[] && ((String[])values).length > 1) {
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug("Bypassing automatic checkbox detection due to multiple checkboxes of the same name: #1", new String[]{name});
                continue;
            }
            if (parameters.containsKey(name)) continue;
            newParams.put(name, new String[]{this.uncheckedValue});
        }
        parameters.putAll(newParams);
        return ai.invoke();
    }

    public void setUncheckedValue(String uncheckedValue) {
        this.uncheckedValue = uncheckedValue;
    }
}

