/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.xwork2.ognl;

import com.opensymphony.xwork2.ognl.OgnlCache;
import com.opensymphony.xwork2.ognl.OgnlCacheFactory;
import com.opensymphony.xwork2.ognl.OgnlDefaultCache;
import com.opensymphony.xwork2.ognl.OgnlLRUCache;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.lang3.BooleanUtils;

public class DefaultOgnlCacheFactory<Key, Value>
implements OgnlCacheFactory<Key, Value> {
    private final AtomicBoolean useLRUCache = new AtomicBoolean(false);
    private final AtomicInteger cacheMaxSize = new AtomicInteger(25000);

    @Override
    public OgnlCache<Key, Value> buildOgnlCache() {
        return this.buildOgnlCache(this.getCacheMaxSize(), 16, 0.75f, this.getUseLRUCache());
    }

    @Override
    public OgnlCache<Key, Value> buildOgnlCache(int evictionLimit, int initialCapacity, float loadFactor, boolean lruCache) {
        if (lruCache) {
            return new OgnlLRUCache(evictionLimit, initialCapacity, loadFactor);
        }
        return new OgnlDefaultCache(evictionLimit, initialCapacity, loadFactor);
    }

    @Override
    public int getCacheMaxSize() {
        return this.cacheMaxSize.get();
    }

    protected void setCacheMaxSize(String maxSize) {
        this.cacheMaxSize.set(Integer.parseInt(maxSize));
    }

    @Override
    public boolean getUseLRUCache() {
        return this.useLRUCache.get();
    }

    protected void setUseLRUCache(String useLRUMode) {
        this.useLRUCache.set(BooleanUtils.toBoolean((String)useLRUMode));
    }
}

