/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts2.portlet.util;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.StringTokenizer;
import javax.portlet.PortletMode;
import javax.portlet.PortletRequest;
import javax.portlet.PortletSecurityException;
import javax.portlet.PortletURL;
import javax.portlet.RenderResponse;
import javax.portlet.WindowState;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.struts2.StrutsException;
import org.apache.struts2.portlet.PortletConstants;
import org.apache.struts2.portlet.context.PortletActionContext;

public class PortletUrlHelper {
    public static final String ENCODING = "UTF-8";
    private static final Logger LOG = LogManager.getLogger(PortletUrlHelper.class);
    protected static final String PORTLETMODE_NAME_EDIT = "edit";
    protected static final String PORTLETMODE_NAME_VIEW = "view";
    protected static final String PORTLETMODE_NAME_HELP = "help";
    protected static final String URLTYPE_NAME_ACTION = "action";
    protected static final String URLTYPE_NAME_RESOURCE = "resource";

    public String buildUrl(String action, String namespace, String method, Map<String, Object> params, String type, String mode, String state) {
        return this.buildUrl(action, namespace, method, params, null, type, mode, state, true, true);
    }

    public String buildUrl(String action, String namespace, String method, Map<String, Object> params, String scheme, String type, String portletMode, String windowState, boolean includeContext, boolean encodeResult) {
        String result;
        int paramStartIndex;
        StringBuilder resultingAction = new StringBuilder();
        PortletRequest request = PortletActionContext.getRequest();
        LOG.debug("Creating url. Action = " + action + ", Namespace = " + namespace + ", Type = " + type);
        namespace = this.prependNamespace(namespace, portletMode, false);
        if (StringUtils.isEmpty((CharSequence)portletMode)) {
            portletMode = PortletActionContext.getRequest().getPortletMode().toString();
        }
        if ((paramStartIndex = action.indexOf(63)) > 0) {
            String value = action;
            action = value.substring(0, value.indexOf(63));
            String queryStr = value.substring(paramStartIndex + 1);
            StringTokenizer tok = new StringTokenizer(queryStr, "&");
            while (tok.hasMoreTokens()) {
                String paramVal = tok.nextToken();
                String key = paramVal.substring(0, paramVal.indexOf(61));
                String val = paramVal.substring(paramVal.indexOf(61) + 1);
                params.put(key, new String[]{val});
            }
        }
        if (StringUtils.isNotEmpty((CharSequence)namespace)) {
            resultingAction.append(namespace);
            if (!action.startsWith("/") && !namespace.endsWith("/")) {
                resultingAction.append("/");
            }
        }
        resultingAction.append(action);
        if (StringUtils.isNotEmpty((CharSequence)method)) {
            resultingAction.append("!").append(method);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Resulting actionPath: " + resultingAction);
        }
        params.put(PortletConstants.ACTION_PARAM, new String[]{resultingAction.toString()});
        params.put(PortletConstants.MODE_PARAM, new String[]{portletMode});
        Map<String, String[]> portletParams = PortletUrlHelper.ensureParamsAreStringArrays(params);
        Object url = this.createUrl(scheme, type, portletParams);
        if (url instanceof PortletURL) {
            try {
                PortletURL portletUrl = (PortletURL)url;
                portletUrl.setPortletMode(this.getPortletMode(request, portletMode));
                portletUrl.setWindowState(this.getWindowState(request, windowState));
            }
            catch (Exception e) {
                LOG.error("Unable to set mode or state:" + e.getMessage(), (Throwable)e);
            }
        }
        if ((result = url.toString()).contains("&amp;")) {
            result = result.replace("&amp;", "&");
        }
        return result;
    }

    protected Object createUrl(String scheme, String type, Map<String, String[]> portletParams) {
        PortletURL url;
        RenderResponse response = PortletActionContext.getRenderResponse();
        if (URLTYPE_NAME_ACTION.equalsIgnoreCase(type)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Creating action url");
            }
            url = response.createActionURL();
        } else {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Creating render url");
            }
            url = response.createRenderURL();
        }
        url.setParameters(portletParams);
        if ("HTTPS".equalsIgnoreCase(scheme)) {
            try {
                url.setSecure(true);
            }
            catch (PortletSecurityException e) {
                LOG.error("Cannot set scheme to https", (Throwable)e);
            }
        }
        return url;
    }

    private String prependNamespace(String namespace, String portletMode, boolean prependModeNamespace) {
        String modeNamespace;
        StringBuilder sb = new StringBuilder();
        if (prependModeNamespace) {
            PortletMode mode = PortletActionContext.getRequest().getPortletMode();
            if (StringUtils.isNotEmpty((CharSequence)portletMode)) {
                mode = new PortletMode(portletMode);
            }
            modeNamespace = PortletActionContext.getModeNamespaceMap().get(mode);
        } else {
            modeNamespace = null;
        }
        String portletNamespace = PortletActionContext.getPortletNamespace();
        if (LOG.isDebugEnabled()) {
            LOG.debug("PortletNamespace: " + portletNamespace + ", modeNamespace: " + (modeNamespace != null ? modeNamespace : "IGNORED"));
        }
        if (StringUtils.isNotEmpty((CharSequence)portletNamespace)) {
            sb.append(portletNamespace);
        }
        if (StringUtils.isNotEmpty((CharSequence)modeNamespace)) {
            if (!modeNamespace.startsWith("/")) {
                sb.append("/");
            }
            sb.append(modeNamespace);
        }
        if (StringUtils.isNotEmpty((CharSequence)namespace)) {
            if (!namespace.startsWith("/")) {
                sb.append("/");
            }
            sb.append(namespace);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Resulting namespace: " + sb);
        }
        return sb.toString();
    }

    public String buildResourceUrl(String value, Map params) {
        StringBuffer sb = new StringBuffer();
        if (!value.startsWith("/")) {
            sb.append("/");
        }
        sb.append(value);
        if (params != null && params.size() > 0) {
            sb.append("?");
            Iterator it = params.keySet().iterator();
            try {
                while (it.hasNext()) {
                    String key = (String)it.next();
                    String val = (String)params.get(key);
                    sb.append(URLEncoder.encode(key, ENCODING)).append("=");
                    sb.append(URLEncoder.encode(val, ENCODING));
                    if (!it.hasNext()) continue;
                    sb.append("&");
                }
            }
            catch (UnsupportedEncodingException e) {
                throw new StrutsException("Encoding UTF-8 not found");
            }
        }
        PortletRequest req = PortletActionContext.getRequest();
        return this.encodeUrl(sb, req);
    }

    protected String encodeUrl(StringBuffer sb, PortletRequest req) {
        RenderResponse resp = PortletActionContext.getRenderResponse();
        return resp.encodeURL(req.getContextPath() + sb.toString());
    }

    public static Map<String, String[]> ensureParamsAreStringArrays(Map<String, Object> params) {
        LinkedHashMap<String, String[]> result = null;
        if (params != null) {
            result = new LinkedHashMap<String, String[]>(params.size());
            for (String key : params.keySet()) {
                Object val = params.get(key);
                if (val instanceof String[]) {
                    result.put(key, (String[])val);
                    continue;
                }
                result.put(key, new String[]{val.toString()});
            }
        }
        return result;
    }

    private WindowState getWindowState(PortletRequest portletReq, String windowState) {
        WindowState state = portletReq.getWindowState();
        if (StringUtils.isNotEmpty((CharSequence)windowState)) {
            if ("maximized".equalsIgnoreCase(windowState)) {
                state = WindowState.MAXIMIZED;
            } else if ("normal".equalsIgnoreCase(windowState)) {
                state = WindowState.NORMAL;
            } else if ("minimized".equalsIgnoreCase(windowState)) {
                state = WindowState.MINIMIZED;
            }
        }
        if (state == null) {
            state = WindowState.NORMAL;
        }
        return state;
    }

    private PortletMode getPortletMode(PortletRequest portletReq, String portletMode) {
        PortletMode mode = portletReq.getPortletMode();
        if (StringUtils.isNotEmpty((CharSequence)portletMode)) {
            if (PORTLETMODE_NAME_EDIT.equalsIgnoreCase(portletMode)) {
                mode = PortletMode.EDIT;
            } else if (PORTLETMODE_NAME_VIEW.equalsIgnoreCase(portletMode)) {
                mode = PortletMode.VIEW;
            } else if (PORTLETMODE_NAME_HELP.equalsIgnoreCase(portletMode)) {
                mode = PortletMode.HELP;
            }
        }
        if (mode == null) {
            mode = PortletMode.VIEW;
        }
        return mode;
    }
}

