/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.aspects.statistics.view;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.SynapseException;
import org.apache.synapse.aspects.ComponentType;
import org.apache.synapse.aspects.statistics.StatisticsRecord;
import org.apache.synapse.aspects.statistics.StatisticsUpdateStrategy;
import org.apache.synapse.aspects.statistics.view.InOutStatisticsView;
import org.apache.synapse.aspects.statistics.view.StatisticsViewStrategy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PerUserViewStrategy
implements StatisticsViewStrategy {
    protected static final int IP = 0;
    protected static final int DOMAIN = 1;
    private Log log = LogFactory.getLog(this.getClass());

    protected PerUserViewStrategy() {
    }

    public Map<String, Map<String, InOutStatisticsView>> determineView(List<StatisticsRecord> statisticsRecords, ComponentType type, int userIDType) {
        HashMap<String, Map<String, InOutStatisticsView>> statisticsMap = new HashMap<String, Map<String, InOutStatisticsView>>();
        if (statisticsRecords == null) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)"Statistics records cannot be found.");
            }
            return statisticsMap;
        }
        HashMap<String, InOutStatisticsView> perUserMap = new HashMap<String, InOutStatisticsView>();
        for (StatisticsRecord record : statisticsRecords) {
            Map perResourceMap;
            if (record == null) continue;
            String userID = 0 == userIDType ? record.getClientIP() : record.getClientHost();
            if (userID == null || "".equals(userID)) {
                if (!this.log.isDebugEnabled()) continue;
                this.log.debug((Object)"user ID cannot be found.");
                continue;
            }
            if (statisticsMap.containsKey(userID)) {
                perResourceMap = (Map)statisticsMap.get(userID);
            } else {
                perResourceMap = new HashMap();
                statisticsMap.put(userID, perResourceMap);
            }
            if (perResourceMap == null) {
                if (!this.log.isDebugEnabled()) continue;
                this.log.debug((Object)("There are not statistics for user ID : " + userID));
                continue;
            }
            StatisticsUpdateStrategy strategy = new StatisticsUpdateStrategy(record);
            Iterator<String> logIds = record.getAllLogIds(type);
            while (logIds.hasNext()) {
                InOutStatisticsView view;
                String id = logIds.next();
                if (!perUserMap.containsKey(id)) {
                    view = new InOutStatisticsView(id, userID, type);
                    perUserMap.put(id, view);
                } else {
                    view = (InOutStatisticsView)perUserMap.get(id);
                }
                this.updateStatistics(id, type, view, strategy);
            }
        }
        return statisticsMap;
    }

    public Map<String, InOutStatisticsView> determineView(String id, List<StatisticsRecord> statisticsRecords, ComponentType type, int userIDType) {
        if (id == null || "".equals(id)) {
            this.handleException("Resource Id cannot be null");
        }
        HashMap<String, InOutStatisticsView> statisticsMap = new HashMap<String, InOutStatisticsView>();
        if (statisticsRecords == null) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)"Statistics records cannot be found.");
            }
            return statisticsMap;
        }
        for (StatisticsRecord record : statisticsRecords) {
            InOutStatisticsView view;
            if (record == null) continue;
            String userID = 0 == userIDType ? record.getClientIP() : record.getClientHost();
            if (userID == null || "".equals(userID)) {
                if (!this.log.isDebugEnabled()) continue;
                this.log.debug((Object)"user ID cannot be found.");
                continue;
            }
            if (statisticsMap.containsKey(userID)) {
                view = (InOutStatisticsView)statisticsMap.get(userID);
            } else {
                view = new InOutStatisticsView(id, userID, type);
                statisticsMap.put(userID, view);
            }
            this.updateStatistics(id, type, view, new StatisticsUpdateStrategy(record));
        }
        return statisticsMap;
    }

    private void updateStatistics(String id, ComponentType type, InOutStatisticsView view, StatisticsUpdateStrategy strategy) {
        if (view != null) {
            strategy.updateStatistics(id, type, view);
        }
    }

    private void handleException(String msg) {
        this.log.error((Object)msg);
        throw new SynapseException(msg);
    }
}

