/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.config.xml;

import java.util.Collection;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMContainer;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.xpath.AXIOMXPath;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.Mediator;
import org.apache.synapse.SynapseConstants;
import org.apache.synapse.SynapseException;
import org.apache.synapse.aspects.AspectConfigurable;
import org.apache.synapse.aspects.AspectConfiguration;
import org.apache.synapse.config.xml.AnonymousListMediator;
import org.apache.synapse.config.xml.AnonymousListMediatorSerializer;
import org.apache.synapse.config.xml.MediatorSerializer;
import org.apache.synapse.config.xml.SynapseXPathSerializer;
import org.apache.synapse.mediators.MediatorProperty;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractMediatorSerializer
implements MediatorSerializer {
    protected static Log log;
    protected static final OMFactory fac;
    protected static final OMNamespace synNS;
    protected static final OMNamespace nullNS;
    protected static final QName PROP_Q;
    protected static final QName DESCRIPTION_Q;

    protected AbstractMediatorSerializer() {
        log = LogFactory.getLog(this.getClass());
    }

    @Override
    public final OMElement serializeMediator(OMElement parent, Mediator m) {
        if (m instanceof AnonymousListMediator) {
            ((AnonymousListMediatorSerializer)this).serializeChildren(parent, ((AnonymousListMediator)m).getList());
            return parent;
        }
        OMElement elem = this.serializeSpecificMediator(m);
        if (m.getDescription() != null) {
            OMElement descriptionElem = fac.createOMElement(DESCRIPTION_Q, (OMContainer)elem);
            descriptionElem.setText(m.getDescription());
            elem.addChild((OMNode)descriptionElem);
        }
        if (parent != null) {
            parent.addChild((OMNode)elem);
        }
        return elem;
    }

    protected abstract OMElement serializeSpecificMediator(Mediator var1);

    protected static void saveTracingState(OMElement mediatorOmElement, Mediator mediator) {
        AspectConfiguration statisticsConfigurable;
        int traceState = mediator.getTraceState();
        String traceValue = null;
        if (traceState == 1) {
            traceValue = "enable";
        } else if (traceState == 0) {
            traceValue = "disable";
        }
        if (traceValue != null) {
            mediatorOmElement.addAttribute(fac.createOMAttribute("trace", nullNS, traceValue));
        }
        if (mediator instanceof AspectConfigurable && (statisticsConfigurable = ((AspectConfigurable)((Object)mediator)).getAspectConfiguration()) != null && statisticsConfigurable.isStatisticsEnable()) {
            mediatorOmElement.addAttribute(fac.createOMAttribute("statistics", nullNS, "enable"));
        }
    }

    protected void serializeMediatorProperties(OMElement parent, Collection<MediatorProperty> props, QName childElementName) {
        for (MediatorProperty mp : props) {
            OMElement prop = fac.createOMElement(childElementName, (OMContainer)parent);
            if (mp.getName() != null) {
                prop.addAttribute(fac.createOMAttribute("name", nullNS, mp.getName()));
            } else {
                this.handleException("Mediator property name missing");
            }
            if (mp.getValue() != null) {
                prop.addAttribute(fac.createOMAttribute("value", nullNS, mp.getValue()));
                continue;
            }
            if (mp.getExpression() != null) {
                SynapseXPathSerializer.serializeXPath(mp.getExpression(), prop, "expression");
                continue;
            }
            this.handleException("Mediator property must have a literal value or be an expression");
        }
    }

    protected void serializeMediatorProperties(OMElement parent, Collection<MediatorProperty> props) {
        this.serializeMediatorProperties(parent, props, PROP_Q);
    }

    protected void serializeProperties(OMElement parent, Collection<MediatorProperty> props) {
        this.serializeMediatorProperties(parent, props);
    }

    protected void serializeNamespaces(OMElement elem, AXIOMXPath xpath) {
        for (Object obj : xpath.getNamespaces().keySet()) {
            String prefix = (String)obj;
            String uri = xpath.getNamespaceContext().translateNamespacePrefixToUri(prefix);
            if ("http://ws.apache.org/ns/synapse".equals(uri)) continue;
            elem.declareNamespace(uri, prefix);
        }
    }

    protected void handleException(String msg) {
        LogFactory.getLog(this.getClass()).error((Object)msg);
        throw new SynapseException(msg);
    }

    protected void handleException(String msg, Exception e) {
        LogFactory.getLog(this.getClass()).error((Object)msg, (Throwable)e);
        throw new SynapseException(msg, e);
    }

    static {
        fac = OMAbstractFactory.getOMFactory();
        synNS = SynapseConstants.SYNAPSE_OMNAMESPACE;
        nullNS = fac.createOMNamespace("", "");
        PROP_Q = new QName("http://ws.apache.org/ns/synapse", "property");
        DESCRIPTION_Q = new QName("http://ws.apache.org/ns/synapse", "description");
    }
}

