/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.config.xml;

import java.util.Properties;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.apache.synapse.Mediator;
import org.apache.synapse.config.xml.AbstractMediatorFactory;
import org.apache.synapse.config.xml.MediatorPropertyFactory;
import org.apache.synapse.mediators.builtin.LogMediator;

public class LogMediatorFactory
extends AbstractMediatorFactory {
    private static final QName LOG_Q = new QName("http://ws.apache.org/ns/synapse", "log");
    private static final String SIMPLE = "simple";
    private static final String HEADERS = "headers";
    private static final String FULL = "full";
    private static final String CUSTOM = "custom";
    public static final String CAT_INFO = "INFO";
    public static final String CAT_TRACE = "TRACE";
    public static final String CAT_DEBUG = "DEBUG";
    public static final String CAT_WARN = "WARN";
    public static final String CAT_ERROR = "ERROR";
    public static final String CAT_FATAL = "FATAL";
    private static final QName ATT_LEVEL = new QName("level");
    private static final QName ATT_SEPERATOR = new QName("separator");
    private static final QName ATT_CATEGORY = new QName("category");

    public QName getTagQName() {
        return LOG_Q;
    }

    public Mediator createSpecificMediator(OMElement elem, Properties properties) {
        OMAttribute separator;
        OMAttribute category;
        LogMediator logMediator = new LogMediator();
        this.processAuditStatus(logMediator, elem);
        OMAttribute level = elem.getAttribute(ATT_LEVEL);
        if (level != null) {
            String levelstr = level.getAttributeValue();
            if (SIMPLE.equals(levelstr)) {
                logMediator.setLogLevel(1);
            } else if (HEADERS.equals(levelstr)) {
                logMediator.setLogLevel(2);
            } else if (FULL.equals(levelstr)) {
                logMediator.setLogLevel(3);
            } else if (CUSTOM.equals(levelstr)) {
                logMediator.setLogLevel(0);
            }
        }
        if ((category = elem.getAttribute(ATT_CATEGORY)) != null) {
            String catstr = category.getAttributeValue().trim().toUpperCase();
            if (CAT_INFO.equals(catstr)) {
                logMediator.setCategory(0);
            } else if (CAT_TRACE.equals(catstr)) {
                logMediator.setCategory(2);
            } else if (CAT_DEBUG.equals(catstr)) {
                logMediator.setCategory(1);
            } else if (CAT_WARN.equals(catstr)) {
                logMediator.setCategory(3);
            } else if (CAT_ERROR.equals(catstr)) {
                logMediator.setCategory(4);
            } else if (CAT_FATAL.equals(catstr)) {
                logMediator.setCategory(5);
            } else {
                this.handleException("Invalid log category. Category has to be one of the following : INFO, TRACE, DEBUG, WARN, ERROR, FATAL");
            }
        }
        if ((separator = elem.getAttribute(ATT_SEPERATOR)) != null) {
            logMediator.setSeparator(separator.getAttributeValue());
        }
        logMediator.addAllProperties(MediatorPropertyFactory.getMediatorProperties(elem));
        return logMediator;
    }
}

