/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.config.xml;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.SynapseException;
import org.apache.synapse.aspects.AspectConfiguration;
import org.apache.synapse.config.xml.ResourceMapFactory;
import org.apache.synapse.config.xml.SequenceMediatorFactory;
import org.apache.synapse.config.xml.endpoints.EndpointFactory;
import org.apache.synapse.core.axis2.ProxyService;
import org.apache.synapse.util.PolicyInfo;

public class ProxyServiceFactory {
    private static final Log log = LogFactory.getLog(ProxyServiceFactory.class);

    public static ProxyService createProxy(OMElement elem, Properties properties) {
        String statisticsValue;
        OMElement target;
        OMElement descriptionElement;
        OMAttribute startOnLoad;
        String traceValue;
        OMAttribute trace;
        String pinnedServersValue;
        OMAttribute pinnedServers;
        String transports;
        ProxyService proxy = null;
        OMAttribute name = elem.getAttribute(new QName("", "name"));
        if (name == null) {
            ProxyServiceFactory.handleException("The 'name' attribute is required for a Proxy service definition");
        } else {
            proxy = new ProxyService(name.getAttributeValue());
        }
        OMAttribute trans = elem.getAttribute(new QName("", "transports"));
        if (trans != null && (transports = trans.getAttributeValue()) != null && !"all".equals(transports)) {
            StringTokenizer st = new StringTokenizer(transports, " ,");
            ArrayList<String> transportList = new ArrayList<String>();
            while (st.hasMoreTokens()) {
                String token = st.nextToken();
                if (token.length() == 0) continue;
                transportList.add(token);
            }
            proxy.setTransports(transportList);
        }
        if ((pinnedServers = elem.getAttribute(new QName("", "pinnedServers"))) != null && (pinnedServersValue = pinnedServers.getAttributeValue()) != null) {
            StringTokenizer st = new StringTokenizer(pinnedServersValue, " ,");
            ArrayList<String> pinnedServersList = new ArrayList<String>();
            while (st.hasMoreTokens()) {
                String token = st.nextToken();
                if (token.length() == 0) continue;
                pinnedServersList.add(token);
            }
            proxy.setPinnedServers(pinnedServersList);
        }
        if ((trace = elem.getAttribute(new QName("", "trace"))) != null && (traceValue = trace.getAttributeValue()) != null) {
            if (traceValue.equals("enable")) {
                proxy.setTraceState(1);
            } else if (traceValue.equals("disable")) {
                proxy.setTraceState(0);
            }
        }
        if ((startOnLoad = elem.getAttribute(new QName("", "startOnLoad"))) != null) {
            proxy.setStartOnLoad(Boolean.valueOf(startOnLoad.getAttributeValue()));
        } else {
            proxy.setStartOnLoad(true);
        }
        OMAttribute serviceGroup = elem.getAttribute(new QName("", "serviceGroup"));
        if (serviceGroup != null) {
            proxy.setServiceGroup(serviceGroup.getAttributeValue());
        }
        if ((descriptionElement = elem.getFirstChildWithName(new QName("http://ws.apache.org/ns/synapse", "description"))) != null) {
            proxy.setDescription(descriptionElement.getText().trim());
        }
        if ((target = elem.getFirstChildWithName(new QName("http://ws.apache.org/ns/synapse", "target"))) != null) {
            boolean isTargetOk = false;
            SequenceMediatorFactory mediatorFactory = new SequenceMediatorFactory();
            OMAttribute inSequence = target.getAttribute(new QName("", "inSequence"));
            if (inSequence != null) {
                proxy.setTargetInSequence(inSequence.getAttributeValue());
                isTargetOk = true;
            } else {
                OMElement inSequenceElement = target.getFirstChildWithName(new QName("http://ws.apache.org/ns/synapse", "inSequence"));
                if (inSequenceElement != null) {
                    proxy.setTargetInLineInSequence(mediatorFactory.createAnonymousSequence(inSequenceElement, properties));
                    isTargetOk = true;
                }
            }
            OMAttribute outSequence = target.getAttribute(new QName("", "outSequence"));
            if (outSequence != null) {
                proxy.setTargetOutSequence(outSequence.getAttributeValue());
            } else {
                OMElement outSequenceElement = target.getFirstChildWithName(new QName("http://ws.apache.org/ns/synapse", "outSequence"));
                if (outSequenceElement != null) {
                    proxy.setTargetInLineOutSequence(mediatorFactory.createAnonymousSequence(outSequenceElement, properties));
                }
            }
            OMAttribute faultSequence = target.getAttribute(new QName("", "faultSequence"));
            if (faultSequence != null) {
                proxy.setTargetFaultSequence(faultSequence.getAttributeValue());
            } else {
                OMElement faultSequenceElement = target.getFirstChildWithName(new QName("http://ws.apache.org/ns/synapse", "faultSequence"));
                if (faultSequenceElement != null) {
                    proxy.setTargetInLineFaultSequence(mediatorFactory.createAnonymousSequence(faultSequenceElement, properties));
                }
            }
            OMAttribute tgtEndpt = target.getAttribute(new QName("", "endpoint"));
            if (tgtEndpt != null) {
                proxy.setTargetEndpoint(tgtEndpt.getAttributeValue());
                isTargetOk = true;
            } else {
                OMElement endpointElement = target.getFirstChildWithName(new QName("http://ws.apache.org/ns/synapse", "endpoint"));
                if (endpointElement != null) {
                    proxy.setTargetInLineEndpoint(EndpointFactory.getEndpointFromElement(endpointElement, true, properties));
                    isTargetOk = true;
                }
            }
            if (!isTargetOk) {
                ProxyServiceFactory.handleException("Target of the proxy service must declare either an inSequence or endpoint or both");
            }
        } else {
            ProxyServiceFactory.handleException("Target is required for a Proxy service definition");
        }
        OMElement wsdl = elem.getFirstChildWithName(new QName("http://ws.apache.org/ns/synapse", "publishWSDL"));
        if (wsdl != null) {
            OMAttribute wsdlkey = wsdl.getAttribute(new QName("", "key"));
            if (wsdlkey != null) {
                proxy.setWSDLKey(wsdlkey.getAttributeValue());
            } else {
                OMAttribute wsdlURI = wsdl.getAttribute(new QName("", "uri"));
                if (wsdlURI != null) {
                    try {
                        proxy.setWsdlURI(new URI(wsdlURI.getAttributeValue()));
                    }
                    catch (URISyntaxException e) {
                        String msg = "Error creating uri for proxy service wsdl";
                        log.error((Object)msg);
                        ProxyServiceFactory.handleException(msg, e);
                    }
                } else {
                    OMElement wsdl11 = wsdl.getFirstChildWithName(new QName("http://schemas.xmlsoap.org/wsdl/", "definitions"));
                    if (wsdl11 != null) {
                        proxy.setInLineWSDL(wsdl11);
                    } else {
                        OMElement wsdl20 = wsdl.getFirstChildWithName(new QName("http://www.w3.org/ns/wsdl", "description"));
                        if (wsdl20 != null) {
                            proxy.setInLineWSDL(wsdl20);
                        }
                    }
                }
            }
            proxy.setResourceMap(ResourceMapFactory.createResourceMap(wsdl));
        }
        Iterator policies = elem.getChildrenWithName(new QName("http://ws.apache.org/ns/synapse", "policy"));
        while (policies.hasNext()) {
            Object o = policies.next();
            if (o instanceof OMElement) {
                OMElement policy = (OMElement)o;
                OMAttribute key = policy.getAttribute(new QName("", "key"));
                OMAttribute type = policy.getAttribute(new QName("", "type"));
                OMAttribute operationName = policy.getAttribute(new QName("", "operationName"));
                OMAttribute operationNS = policy.getAttribute(new QName("", "operationNamespace"));
                if (key != null) {
                    PolicyInfo pi = new PolicyInfo(key.getAttributeValue());
                    if (type != null && type.getAttributeValue() != null) {
                        if ("in".equals(type.getAttributeValue())) {
                            pi.setType(1);
                        } else if ("out".equals(type.getAttributeValue())) {
                            pi.setType(2);
                        } else {
                            ProxyServiceFactory.handleException("Undefined policy type for the policy with key : " + key.getAttributeValue());
                        }
                    }
                    if (operationName != null && operationName.getAttributeValue() != null) {
                        if (operationNS != null && operationNS.getAttributeValue() != null) {
                            pi.setOperation(new QName(operationNS.getAttributeValue(), operationName.getAttributeValue()));
                        } else {
                            pi.setOperation(new QName(operationName.getAttributeValue()));
                        }
                    }
                    proxy.addPolicyInfo(pi);
                    continue;
                }
                ProxyServiceFactory.handleException("Policy element does not specify the policy key");
                continue;
            }
            ProxyServiceFactory.handleException("Invalid 'policy' element found under element 'policies'");
        }
        String nameString = proxy.getName();
        if (nameString == null || "".equals(nameString)) {
            nameString = "AnonymousProxyService";
        }
        AspectConfiguration aspectConfiguration = new AspectConfiguration(nameString);
        proxy.configure(aspectConfiguration);
        OMAttribute statistics = elem.getAttribute(new QName("", "statistics"));
        if (statistics != null && (statisticsValue = statistics.getAttributeValue()) != null && "enable".equals(statisticsValue)) {
            aspectConfiguration.enableStatistics();
        }
        Iterator props = elem.getChildrenWithName(new QName("http://ws.apache.org/ns/synapse", "parameter"));
        while (props.hasNext()) {
            Object o = props.next();
            if (o instanceof OMElement) {
                OMElement prop = (OMElement)o;
                OMAttribute pname = prop.getAttribute(new QName("", "name"));
                OMElement propertyValue = prop.getFirstElement();
                if (pname != null) {
                    if (propertyValue != null) {
                        proxy.addParameter(pname.getAttributeValue(), propertyValue);
                        continue;
                    }
                    proxy.addParameter(pname.getAttributeValue(), prop.getText().trim());
                    continue;
                }
                ProxyServiceFactory.handleException("Invalid property specified for proxy service : " + name);
                continue;
            }
            ProxyServiceFactory.handleException("Invalid property specified for proxy service : " + name);
        }
        if (elem.getFirstChildWithName(new QName("http://ws.apache.org/ns/synapse", "enableAddressing")) != null) {
            proxy.setWsAddrEnabled(true);
        }
        if (elem.getFirstChildWithName(new QName("http://ws.apache.org/ns/synapse", "enableRM")) != null) {
            proxy.setWsRMEnabled(true);
        }
        if (elem.getFirstChildWithName(new QName("http://ws.apache.org/ns/synapse", "enableSec")) != null) {
            proxy.setWsSecEnabled(true);
        }
        return proxy;
    }

    private static void handleException(String msg) {
        log.error((Object)msg);
        throw new SynapseException(msg);
    }

    private static void handleException(String msg, Exception e) {
        log.error((Object)msg, (Throwable)e);
        throw new SynapseException(msg, e);
    }
}

