/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.config.xml;

import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMNode;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.SynapseConstants;
import org.apache.synapse.SynapseException;
import org.apache.synapse.registry.Registry;

public class RegistrySerializer {
    private static final Log log = LogFactory.getLog(RegistrySerializer.class);
    protected static final OMFactory fac = OMAbstractFactory.getOMFactory();
    protected static final OMNamespace synNS = SynapseConstants.SYNAPSE_OMNAMESPACE;
    protected static final OMNamespace nullNS = fac.createOMNamespace("", "");

    public static OMElement serializeRegistry(OMElement parent, Registry registry) {
        OMElement reg = fac.createOMElement("registry", synNS);
        if (registry.getProviderClass() != null) {
            reg.addAttribute(fac.createOMAttribute("provider", nullNS, registry.getProviderClass()));
        } else {
            RegistrySerializer.handleException("Invalid registry. Provider is required");
        }
        for (String string : registry.getConfigurationProperties().keySet()) {
            String value = (String)registry.getConfigurationProperties().get(string);
            OMElement property = fac.createOMElement("parameter", synNS);
            property.addAttribute(fac.createOMAttribute("name", nullNS, string));
            property.setText(value.trim());
            reg.addChild((OMNode)property);
        }
        if (parent != null) {
            parent.addChild((OMNode)reg);
        }
        return reg;
    }

    private static void handleException(String msg) {
        log.error((Object)msg);
        throw new SynapseException(msg);
    }
}

