/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.config.xml.endpoints;

import java.io.File;
import java.net.URL;
import java.util.Properties;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMNode;
import org.apache.axis2.util.JavaUtils;
import org.apache.synapse.config.SynapseConfigUtils;
import org.apache.synapse.config.xml.endpoints.DefaultEndpointFactory;
import org.apache.synapse.config.xml.endpoints.DefinitionFactory;
import org.apache.synapse.config.xml.endpoints.EndpointDefinitionFactory;
import org.apache.synapse.config.xml.endpoints.utils.WSDL11EndpointBuilder;
import org.apache.synapse.endpoints.Endpoint;
import org.apache.synapse.endpoints.EndpointDefinition;
import org.apache.synapse.endpoints.WSDLEndpoint;

public class WSDLEndpointFactory
extends DefaultEndpointFactory {
    public static final String SKIP_WSDL_PARSING = "skip.wsdl.parsing";
    private static WSDLEndpointFactory instance = new WSDLEndpointFactory();

    private WSDLEndpointFactory() {
    }

    public static WSDLEndpointFactory getInstance() {
        return instance;
    }

    protected Endpoint createEndpoint(OMElement epConfig, boolean anonymousEndpoint, Properties properties) {
        OMElement wsdlElement;
        WSDLEndpoint wsdlEndpoint = new WSDLEndpoint();
        OMAttribute name = epConfig.getAttribute(new QName("", "name"));
        if (name != null) {
            wsdlEndpoint.setName(name.getAttributeValue());
        }
        if ((wsdlElement = epConfig.getFirstChildWithName(new QName("http://ws.apache.org/ns/synapse", "wsdl"))) != null) {
            EndpointDefinition endpoint;
            DefinitionFactory fac = this.getEndpointDefinitionFactory();
            if (fac == null) {
                fac = new EndpointDefinitionFactory();
                endpoint = fac.createDefinition(wsdlElement);
            } else {
                endpoint = fac.createDefinition(wsdlElement);
            }
            this.extractSpecificEndpointProperties(endpoint, wsdlElement);
            wsdlEndpoint.setDefinition(endpoint);
            this.processAuditStatus(endpoint, wsdlEndpoint.getName(), wsdlElement);
            String serviceName = wsdlElement.getAttributeValue(new QName("service"));
            String portName = wsdlElement.getAttributeValue(new QName("port"));
            String wsdlURI = wsdlElement.getAttributeValue(new QName("uri"));
            wsdlEndpoint.setServiceName(serviceName);
            wsdlEndpoint.setPortName(portName);
            String noParsing = properties.getProperty(SKIP_WSDL_PARSING);
            if (wsdlURI != null) {
                wsdlEndpoint.setWsdlURI(wsdlURI.trim());
                if (noParsing == null || !JavaUtils.isTrueExplicitly((String)noParsing)) {
                    try {
                        OMElement omElement;
                        OMNamespace ns;
                        OMNode wsdlOM = SynapseConfigUtils.getOMElementFromURL(new URL(wsdlURI).toString(), properties.get("synapse.home") != null ? properties.get("synapse.home").toString() : "");
                        if (wsdlOM != null && wsdlOM instanceof OMElement && (ns = (omElement = (OMElement)wsdlOM).getNamespace()) != null) {
                            String nsUri = omElement.getNamespace().getNamespaceURI();
                            if ("http://schemas.xmlsoap.org/wsdl/".equals(nsUri)) {
                                new WSDL11EndpointBuilder().populateEndpointDefinitionFromWSDL(endpoint, wsdlURI.trim(), omElement, serviceName, portName);
                            } else if ("http://www.w3.org/ns/wsdl".equals(nsUri)) {
                                WSDLEndpointFactory.handleException("WSDL 2.0 Endpoints are currently not supported");
                            }
                        }
                    }
                    catch (Exception e) {
                        WSDLEndpointFactory.handleException("Couldn't create endpoint from the given WSDL URI : " + e.getMessage(), e);
                    }
                }
            }
            OMElement definitionElement = wsdlElement.getFirstChildWithName(new QName("http://schemas.xmlsoap.org/wsdl/", "definitions"));
            if (endpoint == null && definitionElement != null) {
                wsdlEndpoint.setWsdlDoc(definitionElement);
                if (noParsing == null || !JavaUtils.isTrueExplicitly((String)noParsing)) {
                    String resolveRoot = properties.get("resolve.root").toString();
                    String baseUri = "file:./";
                    if (resolveRoot != null) {
                        baseUri = resolveRoot.trim();
                    }
                    if (!baseUri.endsWith(File.separator)) {
                        baseUri = baseUri + File.separator;
                    }
                    new WSDL11EndpointBuilder().populateEndpointDefinitionFromWSDL(endpoint, baseUri, definitionElement, serviceName, portName);
                } else {
                    endpoint = new EndpointDefinition();
                }
            }
            OMElement descriptionElement = wsdlElement.getFirstChildWithName(new QName("http://www.w3.org/ns/wsdl", "description"));
            if (endpoint == null && descriptionElement != null) {
                WSDLEndpointFactory.handleException("WSDL 2.0 Endpoints are currently not supported.");
            }
        }
        this.processProperties(wsdlEndpoint, epConfig);
        return wsdlEndpoint;
    }
}

