/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.config.xml.eventing;

import java.util.Calendar;
import java.util.Collection;
import java.util.List;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMContainer;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMNode;
import org.apache.axis2.databinding.utils.ConverterUtil;
import org.apache.synapse.config.xml.XMLConfigConstants;
import org.apache.synapse.eventing.SynapseEventSource;
import org.wso2.eventing.Subscription;

public class EventSourceSerializer {
    public static OMElement serializeEventSource(OMElement elem, SynapseEventSource eventSource) {
        OMFactory fac = OMAbstractFactory.getOMFactory();
        OMNamespace nullNS = fac.createOMNamespace("", "");
        OMElement evenSourceElem = fac.createOMElement("eventSource", XMLConfigConstants.SYNAPSE_OMNAMESPACE);
        if (eventSource.getName() != null) {
            evenSourceElem.addAttribute(fac.createOMAttribute("name", nullNS, eventSource.getName()));
        }
        if (eventSource.getSubscriptionManager() != null) {
            OMElement subManagerElem = fac.createOMElement("subscriptionManager", XMLConfigConstants.SYNAPSE_OMNAMESPACE);
            subManagerElem.addAttribute(fac.createOMAttribute("class", nullNS, eventSource.getSubscriptionManager().getClass().getName()));
            Collection names = eventSource.getSubscriptionManager().getPropertyNames();
            for (String name : names) {
                String value = eventSource.isContainsConfigurationProperty(name) ? eventSource.getConfigurationProperty(name) : eventSource.getSubscriptionManager().getPropertyValue(name);
                OMElement propElem = fac.createOMElement("property", XMLConfigConstants.SYNAPSE_OMNAMESPACE);
                propElem.addAttribute(fac.createOMAttribute("name", nullNS, name));
                propElem.addAttribute(fac.createOMAttribute("value", nullNS, value));
                subManagerElem.addChild((OMNode)propElem);
            }
            evenSourceElem.addChild((OMNode)subManagerElem);
            List staticSubscriptionList = eventSource.getSubscriptionManager().getStaticSubscriptions();
            for (Subscription staticSubscription : staticSubscriptionList) {
                OMElement staticSubElem = fac.createOMElement("subscription", XMLConfigConstants.SYNAPSE_OMNAMESPACE);
                staticSubElem.addAttribute(fac.createOMAttribute("id", nullNS, staticSubscription.getId()));
                OMElement filterElem = fac.createOMElement("filter", XMLConfigConstants.SYNAPSE_OMNAMESPACE);
                filterElem.addAttribute(fac.createOMAttribute("source", nullNS, staticSubscription.getFilterValue()));
                filterElem.addAttribute(fac.createOMAttribute("dialect", nullNS, staticSubscription.getFilterDialect()));
                staticSubElem.addChild((OMNode)filterElem);
                OMElement endpointElem = fac.createOMElement("endpoint", XMLConfigConstants.SYNAPSE_OMNAMESPACE);
                OMElement addressElem = fac.createOMElement("address", XMLConfigConstants.SYNAPSE_OMNAMESPACE);
                addressElem.addAttribute(fac.createOMAttribute("uri", nullNS, staticSubscription.getEndpointUrl()));
                endpointElem.addChild((OMNode)addressElem);
                staticSubElem.addChild((OMNode)endpointElem);
                if (staticSubscription.getExpires() != null) {
                    OMElement expiresElem = fac.createOMElement("expires", XMLConfigConstants.SYNAPSE_OMNAMESPACE);
                    fac.createOMText((OMContainer)expiresElem, ConverterUtil.convertToString((Calendar)staticSubscription.getExpires()));
                    staticSubElem.addChild((OMNode)expiresElem);
                }
                evenSourceElem.addChild((OMNode)staticSubElem);
            }
        }
        if (elem != null) {
            elem.addChild((OMNode)evenSourceElem);
        }
        return evenSourceElem;
    }
}

