/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.deployers;

import java.io.File;
import java.util.Properties;
import org.apache.axiom.om.OMElement;
import org.apache.axis2.deployment.DeploymentException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.Startup;
import org.apache.synapse.config.xml.StartupFinder;
import org.apache.synapse.deployers.AbstractSynapseArtifactDeployer;

public class TaskDeployer
extends AbstractSynapseArtifactDeployer {
    private static Log log = LogFactory.getLog(TaskDeployer.class);

    public String deploySynapseArtifact(OMElement artifactConfig, String fileName, Properties properties) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("StartupTask Deployment from file : " + fileName + " : Started"));
        }
        try {
            Startup st = StartupFinder.getInstance().getStartup(artifactConfig, properties);
            st.setFileName(new File(fileName).getName());
            if (log.isDebugEnabled()) {
                log.debug((Object)("StartupTask named '" + st.getName() + "' has been built from the file " + fileName));
            }
            st.init(this.getSynapseEnvironment());
            if (log.isDebugEnabled()) {
                log.debug((Object)("Initialized the StartupTask : " + st.getName()));
            }
            this.getSynapseConfiguration().addStartup(st);
            if (log.isDebugEnabled()) {
                log.debug((Object)("StartupTask Deployment from file : " + fileName + " : Completed"));
            }
            log.info((Object)("StartupTask named '" + st.getName() + "' has been deployed from file : " + fileName));
            return st.getName();
        }
        catch (Exception e) {
            this.handleSynapseArtifactDeploymentError("StartupTask Deployment from the file : " + fileName + " : Failed.", e);
            return null;
        }
    }

    public String updateSynapseArtifact(OMElement artifactConfig, String fileName, String existingArtifactName, Properties properties) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("StartupTask update from file : " + fileName + " has started"));
        }
        try {
            Startup st = StartupFinder.getInstance().getStartup(artifactConfig, properties);
            st.setFileName(new File(fileName).getName());
            if (log.isDebugEnabled()) {
                log.debug((Object)("StartupTask: " + st.getName() + " has been built from the file: " + fileName));
            }
            Startup existingSt = this.getSynapseConfiguration().getStartup(existingArtifactName);
            existingSt.destroy();
            st.init(this.getSynapseEnvironment());
            if (existingArtifactName.equals(st.getName())) {
                this.getSynapseConfiguration().updateStartup(st);
            } else {
                this.getSynapseConfiguration().addStartup(st);
                this.getSynapseConfiguration().removeStartup(existingArtifactName);
                log.info((Object)("StartupTask: " + existingArtifactName + " has been undeployed"));
            }
            log.info((Object)("StartupTask: " + st.getName() + " has been updated from the file: " + fileName));
            return st.getName();
        }
        catch (DeploymentException e) {
            this.handleSynapseArtifactDeploymentError("Error while updating the startup task from the file: " + fileName);
            return null;
        }
    }

    public void undeploySynapseArtifact(String artifactName) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("StartupTask Undeployment of the task named : " + artifactName + " : Started"));
        }
        try {
            Startup st = this.getSynapseConfiguration().getStartup(artifactName);
            if (st != null) {
                this.getSynapseConfiguration().removeStartup(artifactName);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Destroying the StartupTask named : " + artifactName));
                }
                st.destroy();
                if (log.isDebugEnabled()) {
                    log.debug((Object)("StartupTask Undeployment of the sequence named : " + artifactName + " : Completed"));
                }
                log.info((Object)("StartupTask named '" + st.getName() + "' has been undeployed"));
            } else if (log.isDebugEnabled()) {
                log.debug((Object)("Startup task " + artifactName + " has already been undeployed"));
            }
        }
        catch (Exception e) {
            this.handleSynapseArtifactDeploymentError("StartupTask Undeployement of task named : " + artifactName + " : Failed", e);
        }
    }

    public void restoreSynapseArtifact(String artifactName) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Restoring the StartupTask with name : " + artifactName + " : Started"));
        }
        try {
            Startup st = this.getSynapseConfiguration().getStartup(artifactName);
            OMElement stElem = StartupFinder.getInstance().serializeStartup(null, st);
            if (st.getFileName() != null) {
                String fileName = this.getServerConfigurationInformation().getSynapseXMLLocation() + File.separator + "tasks" + File.separator + st.getFileName();
                this.writeToFile(stElem, fileName);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Restoring the StartupTask with name : " + artifactName + " : Completed"));
                }
                log.info((Object)("StartupTask named '" + artifactName + "' has been restored"));
            } else {
                this.handleSynapseArtifactDeploymentError("Couldn't restore the StartupTask named '" + artifactName + "', filename cannot be found");
            }
        }
        catch (Exception e) {
            this.handleSynapseArtifactDeploymentError("Restoring of the StartupTask named '" + artifactName + "' has failed", e);
        }
    }
}

