/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.endpoints;

import org.apache.axiom.om.OMElement;
import org.apache.synapse.MessageContext;
import org.apache.synapse.endpoints.AbstractEndpoint;

public class WSDLEndpoint
extends AbstractEndpoint {
    private String wsdlURI;
    private OMElement wsdlDoc;
    private String serviceName;
    private String portName;

    public void onFault(MessageContext synCtx) {
        if (this.getParentEndpoint() != null) {
            if (this.isTimeout(synCtx)) {
                this.getContext().onTimeout();
            } else if (this.isSuspendFault(synCtx)) {
                this.getContext().onFault();
            }
        }
        this.setErrorOnMessage(synCtx, null, null);
        super.onFault(synCtx);
    }

    public void onSuccess() {
        this.getContext().onSuccess();
    }

    public void send(MessageContext synCtx) {
        if (this.getParentEndpoint() == null && !this.readyToSend()) {
            this.informFailure(synCtx, 303001, "Currently , WSDL endpoint : " + this.getContext());
        } else {
            super.send(synCtx);
        }
    }

    public String getWsdlURI() {
        return this.wsdlURI;
    }

    public void setWsdlURI(String wsdlURI) {
        this.wsdlURI = wsdlURI;
    }

    public OMElement getWsdlDoc() {
        return this.wsdlDoc;
    }

    public void setWsdlDoc(OMElement wsdlDoc) {
        this.wsdlDoc = wsdlDoc;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    public String getPortName() {
        return this.portName;
    }

    public void setPortName(String portName) {
        this.portName = portName;
    }
}

