/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.endpoints.algorithms;

import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.axis2.clustering.Member;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.ManagedLifecycle;
import org.apache.synapse.MessageContext;
import org.apache.synapse.PropertyInclude;
import org.apache.synapse.SynapseException;
import org.apache.synapse.commons.jmx.MBeanRegistrar;
import org.apache.synapse.core.SynapseEnvironment;
import org.apache.synapse.endpoints.Endpoint;
import org.apache.synapse.endpoints.algorithms.AlgorithmContext;
import org.apache.synapse.endpoints.algorithms.LoadbalanceAlgorithm;
import org.apache.synapse.endpoints.algorithms.WeightedRoundRobinView;
import org.apache.synapse.endpoints.algorithms.WeightedRoundRobinViewMBean;
import org.apache.synapse.mediators.MediatorProperty;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WeightedRoundRobin
implements LoadbalanceAlgorithm,
ManagedLifecycle {
    private static final Log log = LogFactory.getLog(WeightedRoundRobin.class);
    private EndpointState[] endpointStates = null;
    private List<Endpoint> endpoints;
    private Endpoint loadBalanceEndpoint;
    private int endpointCursor = 0;
    private static final int DEFAULT_WEIGHT = 1;
    private static final String LOADBALANCE_WEIGHT = "loadbalance.weight";
    private static final String LOADBALANCE_ThEADLOCAL = "loadbalance.threadLocal";
    private boolean isThreadLocal = false;
    private AlgorithmThreadLocal threadedAlgorithm = null;
    private ReadWriteLock lock = new ReentrantReadWriteLock();
    private WeightedRoundRobinViewMBean view;

    @Override
    public void setApplicationMembers(List<Member> members) {
        throw new UnsupportedOperationException("This algorithm doesn't operate on Members");
    }

    @Override
    public void setEndpoints(List<Endpoint> endpoints) {
        this.endpoints = endpoints;
    }

    @Override
    public void setLoadBalanceEndpoint(Endpoint endpoint) {
        this.loadBalanceEndpoint = endpoint;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public Endpoint getNextEndpoint(MessageContext synapseMessageContext, AlgorithmContext algorithmContext) {
        readLock = this.lock.readLock();
        readLock.lock();
        if (!this.isThreadLocal) {
            var4_4 = this;
            synchronized (var4_4) {
                state = this.endpointStates[this.endpointCursor];
                if (state.getCurrentWeight() == 0) {
                    state.reset();
                    this.endpointCursor = this.endpointCursor == this.endpointStates.length - 1 ? 0 : ++this.endpointCursor;
                    state = this.endpointStates[this.endpointCursor];
                }
                state.decrementCurrentWeight();
                var6_9 = this.endpoints.get(state.getEndpointPosition());
                return var6_9;
            }
        }
        ** if (this.threadedAlgorithm == null) goto lbl-1000
lbl-1000:
        // 1 sources

        {
            algo = (Algorithm)this.threadedAlgorithm.get();
            position = algo.getNextEndpoint();
            var6_10 = this.endpoints.get(position);
            return var6_10;
        }
lbl-1000:
        // 1 sources

        {
            msg = "Algorithm: WeightedRoundRobin algorithm not initialized properly";
            WeightedRoundRobin.log.error((Object)msg);
            throw new SynapseException(msg);
        }
        finally {
            readLock.unlock();
        }
    }

    @Override
    public Member getNextApplicationMember(AlgorithmContext algorithmContext) {
        throw new UnsupportedOperationException("This algorithm doesn't operate on Members");
    }

    @Override
    public void reset(AlgorithmContext algorithmContext) {
        for (EndpointState state : this.endpointStates) {
            state.reset();
        }
        this.endpointCursor = 0;
    }

    @Override
    public String getName() {
        return WeightedRoundRobin.class.getName();
    }

    @Override
    public LoadbalanceAlgorithm clone() {
        return null;
    }

    @Override
    public void init(SynapseEnvironment se) {
        MediatorProperty threadLocalProperty;
        if (this.endpoints == null) {
            String msg = "Endpoints are not set, cannot initialize the algorithm";
            log.error((Object)msg);
            throw new SynapseException(msg);
        }
        this.endpointStates = new EndpointState[this.endpoints.size()];
        for (int i = 0; i < this.endpoints.size(); ++i) {
            EndpointState state;
            Endpoint endpoint = this.endpoints.get(i);
            if (!(endpoint instanceof PropertyInclude)) {
                EndpointState state2;
                this.endpointStates[i] = state2 = new EndpointState(i, 1);
                continue;
            }
            MediatorProperty property = ((PropertyInclude)((Object)endpoint)).getProperty(LOADBALANCE_WEIGHT);
            if (property != null) {
                int weight = Integer.parseInt(property.getValue());
                if (weight <= 0) {
                    String msg = "Weight must be greater than zero";
                    log.error((Object)msg);
                    throw new SynapseException(msg);
                }
                state = new EndpointState(i, weight);
            } else {
                state = new EndpointState(i, 1);
            }
            this.endpointStates[i] = state;
        }
        if (this.loadBalanceEndpoint instanceof PropertyInclude && (threadLocalProperty = ((PropertyInclude)((Object)this.loadBalanceEndpoint)).getProperty(LOADBALANCE_ThEADLOCAL)) != null && threadLocalProperty.getValue().equals("true")) {
            this.isThreadLocal = true;
        }
        this.view = new WeightedRoundRobinView(this);
        MBeanRegistrar.getInstance().registerMBean((Object)this.view, "LBAlgorithms", this.loadBalanceEndpoint.getName() != null ? this.loadBalanceEndpoint.getName() : "LBEpr");
    }

    @Override
    public void destroy() {
    }

    private void calculate() {
        Arrays.sort(this.endpointStates, new Comparator<EndpointState>(){

            @Override
            public int compare(EndpointState o1, EndpointState o2) {
                return o2.getWeight() - o1.getWeight();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void changeWeight(int pos, int weight) {
        Lock writeLock = this.lock.writeLock();
        writeLock.lock();
        try {
            EndpointState state = null;
            for (EndpointState s : this.endpointStates) {
                if (s.getEndpointPosition() != pos) continue;
                state = s;
            }
            if (state == null) {
                throw new SynapseException("The specified endpoint position cannot be found");
            }
            state.weight = weight;
            this.calculate();
            this.reset(null);
        }
        finally {
            writeLock.unlock();
        }
    }

    public int[] getCurrentWeights() {
        int[] weights = new int[this.endpointStates.length];
        for (int i = 0; i < weights.length; ++i) {
            weights[i] = 1;
        }
        for (EndpointState state : this.endpointStates) {
            if (state.getEndpointPosition() >= weights.length || state.getEndpointPosition() < 0) continue;
            weights[state.getEndpointPosition()] = state.getWeight();
        }
        return weights;
    }

    private static class EndpointState {
        private int endpointPosition = 0;
        private int weight = 0;
        private int currentWeight = 0;

        public EndpointState(int endpointPosition, int weight) {
            this.endpointPosition = endpointPosition;
            this.weight = weight;
            this.currentWeight = weight;
        }

        public int getEndpointPosition() {
            return this.endpointPosition;
        }

        public int getWeight() {
            return this.weight;
        }

        public int getCurrentWeight() {
            return this.currentWeight;
        }

        public void decrementCurrentWeight() {
            --this.currentWeight;
        }

        public void reset() {
            this.currentWeight = this.weight;
        }
    }

    private static class Algorithm {
        private EndpointState[] threadLocalEndpointStates = null;
        private int threadLocalEndpointCursor = 0;

        public Algorithm(EndpointState[] states) {
            this.threadLocalEndpointStates = new EndpointState[states.length];
            for (int i = 0; i < states.length; ++i) {
                this.threadLocalEndpointStates[i] = new EndpointState(states[i].getEndpointPosition(), states[i].getWeight());
            }
        }

        public int getNextEndpoint() {
            EndpointState state = this.threadLocalEndpointStates[this.threadLocalEndpointCursor];
            if (state.getCurrentWeight() == 0) {
                state.reset();
                this.threadLocalEndpointCursor = this.threadLocalEndpointCursor == this.threadLocalEndpointStates.length - 1 ? 0 : ++this.threadLocalEndpointCursor;
                state = this.threadLocalEndpointStates[this.threadLocalEndpointCursor];
            }
            state.decrementCurrentWeight();
            return state.getEndpointPosition();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class AlgorithmThreadLocal
    extends ThreadLocal<Algorithm> {
        private AlgorithmThreadLocal() {
        }

        @Override
        protected Algorithm initialValue() {
            return new Algorithm(WeightedRoundRobin.this.endpointStates);
        }
    }
}

