/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.mediators;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.Mediator;
import org.apache.synapse.MessageContext;
import org.apache.synapse.SynapseException;

public class MediatorWorker
implements Runnable {
    private static final Log log = LogFactory.getLog(MediatorWorker.class);
    private static final Log trace = LogFactory.getLog((String)"TRACE_LOGGER");
    private Mediator seq = null;
    private MessageContext synCtx = null;

    public MediatorWorker(Mediator seq, MessageContext synCtx) {
        this.seq = seq;
        this.synCtx = synCtx;
    }

    public MediatorWorker(MessageContext synCtx) {
        this.synCtx = synCtx;
        this.seq = synCtx.getMainSequence();
    }

    public void run() {
        block9: {
            try {
                this.seq.mediate(this.synCtx);
            }
            catch (SynapseException syne) {
                if (!this.synCtx.getFaultStack().isEmpty()) {
                    this.warn(false, "Executing fault handler due to exception encountered", this.synCtx);
                    this.synCtx.getFaultStack().pop().handleFault(this.synCtx, syne);
                } else {
                    this.warn(false, "Exception encountered but no fault handler found - message dropped", this.synCtx);
                }
            }
            catch (Exception e) {
                String msg = "Unexpected error executing task/async inject";
                log.error((Object)msg, (Throwable)e);
                if (this.synCtx.getServiceLog() != null) {
                    this.synCtx.getServiceLog().error((Object)msg, (Throwable)e);
                }
                if (!this.synCtx.getFaultStack().isEmpty()) {
                    this.warn(false, "Executing fault handler due to exception encountered", this.synCtx);
                    this.synCtx.getFaultStack().pop().handleFault(this.synCtx, e);
                } else {
                    this.warn(false, "Exception encountered but no fault handler found - message dropped", this.synCtx);
                }
            }
            catch (Throwable e) {
                String msg = "Unexpected error executing task/async inject, message dropped";
                log.error((Object)msg, e);
                if (this.synCtx.getServiceLog() == null) break block9;
                this.synCtx.getServiceLog().error((Object)msg, e);
            }
        }
        this.synCtx = null;
        this.seq = null;
    }

    private void warn(boolean traceOn, String msg, MessageContext msgContext) {
        if (traceOn) {
            trace.warn((Object)msg);
        }
        if (log.isDebugEnabled()) {
            log.warn((Object)msg);
        }
        if (msgContext.getServiceLog() != null) {
            msgContext.getServiceLog().warn((Object)msg);
        }
    }
}

