/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.mediators.base;

import java.util.Stack;
import org.apache.synapse.FaultHandler;
import org.apache.synapse.Mediator;
import org.apache.synapse.MessageContext;
import org.apache.synapse.Nameable;
import org.apache.synapse.SynapseLog;
import org.apache.synapse.aspects.ComponentType;
import org.apache.synapse.aspects.statistics.StatisticsReporter;
import org.apache.synapse.core.SynapseEnvironment;
import org.apache.synapse.mediators.AbstractListMediator;
import org.apache.synapse.mediators.MediatorFaultHandler;
import org.apache.synapse.mediators.Value;

public class SequenceMediator
extends AbstractListMediator
implements Nameable {
    private String name = null;
    private Value key = null;
    private String errorHandler = null;
    private boolean dynamic = false;
    private boolean initialized = false;
    private String registryKey = null;
    private String fileName;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean mediate(MessageContext synCtx) {
        SynapseLog synLog = this.getLog(synCtx);
        if (synLog.isTraceOrDebugEnabled()) {
            synLog.traceOrDebug("Start : Sequence " + (this.name == null ? (this.key == null ? "<anonymous" : "key=<" + this.key) : "<" + this.name) + ">");
            if (synLog.isTraceTraceEnabled()) {
                synLog.traceTrace("Message : " + synCtx.getEnvelope());
            }
        }
        if (this.key == null) {
            boolean faultStack22;
            Mediator errorHandlerMediator = null;
            try {
                FaultHandler o;
                Stack<FaultHandler> faultStack22;
                if (this.isStatisticsEnable()) {
                    StatisticsReporter.reportForComponent(synCtx, this.getAspectConfiguration(), ComponentType.SEQUENCE);
                }
                if (this.errorHandler != null) {
                    errorHandlerMediator = synCtx.getSequence(this.errorHandler);
                    if (errorHandlerMediator != null) {
                        if (synLog.isTraceOrDebugEnabled()) {
                            synLog.traceOrDebug("Setting the onError handler : " + this.errorHandler + " for the sequence : " + this.name);
                        }
                        synCtx.pushFaultHandler(new MediatorFaultHandler(errorHandlerMediator));
                    } else {
                        synLog.auditWarn("onError handler : " + this.errorHandler + " for sequence : " + this.name + " cannot be found");
                    }
                }
                boolean result = super.mediate(synCtx);
                if (errorHandlerMediator != null && (faultStack22 = synCtx.getFaultStack()) != null && !faultStack22.isEmpty() && (o = faultStack22.peek()) instanceof MediatorFaultHandler && errorHandlerMediator.equals(((MediatorFaultHandler)o).getFaultMediator())) {
                    faultStack22.pop();
                }
                if (synLog.isTraceOrDebugEnabled()) {
                    if (synLog.isTraceTraceEnabled()) {
                        synLog.traceTrace("Message : " + synCtx.getEnvelope());
                    }
                    synLog.traceOrDebug("End : Sequence <" + (this.name == null ? "anonymous" : this.name) + ">");
                }
                faultStack22 = result;
            }
            catch (Throwable throwable) {
                if (this.isStatisticsEnable()) {
                    boolean shouldReport = Boolean.parseBoolean(String.valueOf(synCtx.getProperty("OUT_ONLY")));
                    if (!shouldReport) {
                        boolean bl = shouldReport = !Boolean.parseBoolean(String.valueOf(synCtx.getProperty("synapse.internal.request.sending")));
                    }
                    if (shouldReport) {
                        StatisticsReporter.reportForComponent(synCtx, this.getAspectConfiguration(), ComponentType.SEQUENCE);
                    }
                }
                throw throwable;
            }
            if (this.isStatisticsEnable()) {
                boolean shouldReport = Boolean.parseBoolean(String.valueOf(synCtx.getProperty("OUT_ONLY")));
                if (!shouldReport) {
                    boolean bl = shouldReport = !Boolean.parseBoolean(String.valueOf(synCtx.getProperty("synapse.internal.request.sending")));
                }
                if (shouldReport) {
                    StatisticsReporter.reportForComponent(synCtx, this.getAspectConfiguration(), ComponentType.SEQUENCE);
                }
            }
            return faultStack22;
        }
        String sequenceKey = this.key.evaluateValue(synCtx);
        Mediator m = synCtx.getSequence(sequenceKey);
        if (m != null) {
            if (synLog.isTraceOrDebugEnabled()) {
                synLog.traceOrDebug("Executing with key " + this.key);
            }
            boolean result = m.mediate(synCtx);
            if (synLog.isTraceOrDebugEnabled()) {
                synLog.traceOrDebug("End : Sequence key=<" + this.key + ">");
            }
            return result;
        }
        this.handleException("Sequence named " + this.key + " cannot be found", synCtx);
        return false;
    }

    public synchronized void init(SynapseEnvironment se) {
        if (!this.initialized) {
            super.init(se);
            this.initialized = true;
        }
    }

    public synchronized void destroy() {
        if (this.initialized) {
            super.destroy();
            this.initialized = false;
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Value getKey() {
        return this.key;
    }

    public void setKey(Value key) {
        this.key = key;
    }

    public String getErrorHandler() {
        return this.errorHandler;
    }

    public void setErrorHandler(String errorHandler) {
        this.errorHandler = errorHandler;
    }

    public boolean isDynamic() {
        return this.dynamic;
    }

    public void setDynamic(boolean dynamic) {
        this.dynamic = dynamic;
    }

    public String getRegistryKey() {
        return this.registryKey;
    }

    public void setRegistryKey(String registryKey) {
        this.registryKey = registryKey;
    }

    public String getAuditId() {
        return this.getName();
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public boolean isInitialized() {
        return this.initialized;
    }
}

