/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.mediators.store;

import org.apache.axis2.description.Parameter;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.synapse.Mediator;
import org.apache.synapse.MessageContext;
import org.apache.synapse.core.axis2.Axis2MessageContext;
import org.apache.synapse.mediators.AbstractMediator;
import org.apache.synapse.message.store.MessageStore;

public class MessageStoreMediator
extends AbstractMediator {
    private String name;
    private String messageStoreName;
    private String onStoreSequence;

    public boolean mediate(MessageContext synCtx) {
        MessageStore messageStore;
        if (synCtx != null && (messageStore = synCtx.getConfiguration().getMessageStore(this.messageStoreName)) != null) {
            String serverName;
            Mediator sequence;
            if (this.onStoreSequence != null && (sequence = synCtx.getSequence(this.onStoreSequence)) != null) {
                sequence.mediate(synCtx);
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Message Store mediator storing the message : \n " + synCtx.getEnvelope()));
            }
            if (synCtx instanceof Axis2MessageContext && (serverName = MessageStoreMediator.getAxis2ParameterValue(((Axis2MessageContext)synCtx).getAxis2MessageContext().getConfigurationContext().getAxisConfiguration(), "SynapseConfig.ServerName")) != null) {
                synCtx.setProperty("SynapseConfig.ServerName", serverName);
            }
            messageStore.offer(synCtx);
            ((Axis2MessageContext)synCtx).getAxis2MessageContext().getOperationContext().setProperty("RESPONSE_WRITTEN", (Object)"SKIP");
            return true;
        }
        return false;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getMessageStoreName() {
        return this.messageStoreName;
    }

    public void setMessageStoreName(String messageStoreName) {
        this.messageStoreName = messageStoreName;
    }

    public String getOnStoreSequence() {
        return this.onStoreSequence;
    }

    public void setOnStoreSequence(String onStoreSequence) {
        this.onStoreSequence = onStoreSequence;
    }

    private static String getAxis2ParameterValue(AxisConfiguration axisConfiguration, String paramKey) {
        Parameter parameter = axisConfiguration.getParameter(paramKey);
        if (parameter == null) {
            return null;
        }
        Object value = parameter.getValue();
        if (value != null && value instanceof String) {
            return (String)parameter.getValue();
        }
        return null;
    }
}

