/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.mediators.template;

import java.util.HashMap;
import java.util.Map;
import org.apache.synapse.Mediator;
import org.apache.synapse.MessageContext;
import org.apache.synapse.SynapseLog;
import org.apache.synapse.mediators.AbstractMediator;
import org.apache.synapse.mediators.Value;
import org.apache.synapse.mediators.eip.EIPUtils;
import org.apache.synapse.mediators.template.TemplateMediator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InvokeMediator
extends AbstractMediator {
    private String targetTemplate;
    private Map<String, Value> pName2ExpressionMap = new HashMap<String, Value>();

    @Override
    public boolean mediate(MessageContext synCtx) {
        SynapseLog synLog = this.getLog(synCtx);
        if (synLog.isTraceOrDebugEnabled()) {
            synLog.traceOrDebug("Invoking Target EIP Sequence " + this.targetTemplate + " paramNames : " + this.pName2ExpressionMap.keySet());
            if (synLog.isTraceTraceEnabled()) {
                synLog.traceTrace("Message : " + synCtx.getEnvelope());
            }
        }
        Mediator mediator = synCtx.getSequenceTemplate(this.targetTemplate);
        this.populateParameters(synCtx, ((TemplateMediator)mediator).getName());
        if (mediator != null && mediator instanceof TemplateMediator) {
            return mediator.mediate(synCtx);
        }
        return false;
    }

    private void populateParameters(MessageContext synCtx, String templateQualifiedName) {
        for (String parameter : this.pName2ExpressionMap.keySet()) {
            Value expression;
            if ("".equals(parameter) || (expression = this.pName2ExpressionMap.get(parameter)) == null) continue;
            EIPUtils.createSynapseEIPTemplateProperty(synCtx, templateQualifiedName, parameter, expression);
        }
    }

    public String getTargetTemplate() {
        return this.targetTemplate;
    }

    public void setTargetTemplate(String targetTemplate) {
        this.targetTemplate = targetTemplate;
    }

    public Map<String, Value> getpName2ExpressionMap() {
        return this.pName2ExpressionMap;
    }

    public void addExpressionForParamName(String pName, Value expr) {
        this.pName2ExpressionMap.put(pName, expr);
    }
}

