/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.mediators.transform.url;

import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.MessageContext;
import org.apache.synapse.commons.evaluators.Evaluator;
import org.apache.synapse.commons.evaluators.EvaluatorContext;
import org.apache.synapse.commons.evaluators.EvaluatorException;
import org.apache.synapse.core.axis2.Axis2MessageContext;
import org.apache.synapse.mediators.transform.url.RewriteAction;
import org.apache.synapse.mediators.transform.url.URIFragments;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RewriteRule {
    private static final Log log = LogFactory.getLog(RewriteRule.class);
    private Evaluator condition;
    private List<RewriteAction> actions = new ArrayList<RewriteAction>();

    public void rewrite(URIFragments fragments, MessageContext messageContext) throws URISyntaxException {
        if (this.condition != null) {
            String uriString = fragments.toURIString();
            Map<String, String> headers = this.getHeaders(messageContext);
            EvaluatorContext ctx = new EvaluatorContext(uriString, headers);
            ctx.setProperties(((Axis2MessageContext)messageContext).getProperties());
            ctx.setMessageContext(((Axis2MessageContext)messageContext).getAxis2MessageContext());
            if (log.isTraceEnabled()) {
                log.trace((Object)("Evaluating condition with URI: " + uriString));
            }
            try {
                if (!this.condition.evaluate(ctx)) {
                    if (log.isTraceEnabled()) {
                        log.trace((Object)"Condition evaluated to 'false' - Skipping the current action");
                    }
                    return;
                }
                if (log.isTraceEnabled()) {
                    log.trace((Object)"Condition evaluated to 'true' - Performing the stated action");
                }
            }
            catch (EvaluatorException e) {
                log.warn((Object)"Error while evaluating the condition - Skipping the rule as it failed", (Throwable)e);
                return;
            }
        }
        for (RewriteAction action : this.actions) {
            action.execute(fragments, messageContext);
        }
    }

    private Map<String, String> getHeaders(MessageContext synCtx) {
        Axis2MessageContext axis2smc = (Axis2MessageContext)synCtx;
        org.apache.axis2.context.MessageContext axis2MessageCtx = axis2smc.getAxis2MessageContext();
        Object headers = axis2MessageCtx.getProperty("TRANSPORT_HEADERS");
        HashMap<String, String> evaluatorHeaders = new HashMap<String, String>();
        if (headers != null && headers instanceof Map) {
            Map headersMap = (Map)headers;
            for (Map.Entry entryObj : headersMap.entrySet()) {
                Map.Entry entry = entryObj;
                if (!(entry.getKey() instanceof String) || !(entry.getValue() instanceof String)) continue;
                evaluatorHeaders.put((String)entry.getKey(), (String)entry.getValue());
            }
        }
        return evaluatorHeaders;
    }

    public Evaluator getCondition() {
        return this.condition;
    }

    public void setCondition(Evaluator condition) {
        this.condition = condition;
    }

    public void addRewriteAction(RewriteAction action) {
        this.actions.add(action);
    }

    public List<RewriteAction> getActions() {
        return this.actions;
    }
}

