/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.message.store;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.MessageContext;
import org.apache.synapse.message.store.AbstractMessageStore;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InMemoryMessageStore
extends AbstractMessageStore {
    private static final Log log = LogFactory.getLog(InMemoryMessageStore.class);
    private Map<String, MessageContext> messageList = new ConcurrentHashMap<String, MessageContext>();
    private Lock lock = new ReentrantLock();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean offer(MessageContext messageContext) {
        this.lock.lock();
        try {
            if (messageContext != null) {
                messageContext.getEnvelope().build();
                this.messageList.put(messageContext.getMessageID(), messageContext);
                this.notifyMessageAddition(messageContext.getMessageID());
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Message with id " + messageContext.getMessageID() + " stored"));
                }
            }
            Object var3_2 = null;
            this.lock.unlock();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.lock.unlock();
            throw throwable;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MessageContext poll() {
        MessageContext context;
        this.lock.lock();
        try {
            context = this.peek();
            if (context != null) {
                this.messageList.remove(context.getMessageID());
                this.notifyMessageRemoval(context.getMessageID());
            }
            Object var3_2 = null;
            this.lock.unlock();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.lock.unlock();
            throw throwable;
        }
        return context;
    }

    @Override
    public MessageContext peek() {
        if (this.messageList.size() > 0) {
            return (MessageContext)this.messageList.values().toArray()[0];
        }
        return null;
    }

    @Override
    public MessageContext remove() throws NoSuchElementException {
        MessageContext context = this.poll();
        if (context == null) {
            throw new NoSuchElementException();
        }
        return context;
    }

    @Override
    public MessageContext get(int index) {
        if (index >= 0 && index < this.messageList.size()) {
            return (MessageContext)this.messageList.values().toArray()[index];
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MessageContext remove(String messageID) {
        this.lock.lock();
        try {
            if (messageID != null && this.messageList.remove(messageID) != null) {
                this.notifyMessageRemoval(messageID);
            }
            Object var3_2 = null;
            this.lock.unlock();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.lock.unlock();
            throw throwable;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        this.lock.lock();
        try {
            for (String k : this.messageList.keySet()) {
                this.messageList.remove(k);
                this.notifyMessageRemoval(k);
            }
            Object var4_3 = null;
            this.lock.unlock();
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.lock.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<MessageContext> getAll() {
        this.lock.lock();
        try {
            ArrayList<MessageContext> returnList = new ArrayList<MessageContext>();
            for (Map.Entry<String, MessageContext> entry : this.messageList.entrySet()) {
                returnList.add(entry.getValue());
            }
            ArrayList<MessageContext> arrayList = returnList;
            Object var5_4 = null;
            this.lock.unlock();
            return arrayList;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.lock.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MessageContext get(String messageId) {
        block3: {
            this.lock.lock();
            try {
                if (messageId == null) break block3;
                MessageContext messageContext = this.messageList.get(messageId);
                Object var4_3 = null;
                this.lock.unlock();
                return messageContext;
            }
            catch (Throwable throwable) {
                Object var4_5 = null;
                this.lock.unlock();
                throw throwable;
            }
        }
        Object var4_4 = null;
        this.lock.unlock();
        return null;
    }

    @Override
    public int size() {
        return this.messageList.size();
    }
}

