/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.rest;

import java.util.Collection;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.MessageContext;
import org.apache.synapse.core.axis2.Axis2MessageContext;
import org.apache.synapse.rest.API;

public class RESTRequestHandler {
    private static final Log log = LogFactory.getLog(RESTRequestHandler.class);

    public boolean process(MessageContext synCtx) {
        if (synCtx.isResponse()) {
            return this.dispatchToAPI(synCtx);
        }
        org.apache.axis2.context.MessageContext msgCtx = ((Axis2MessageContext)synCtx).getAxis2MessageContext();
        String protocol = msgCtx.getIncomingTransportName();
        if (!"http".equals(protocol) && !"https".equals(protocol)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Invalid protocol for REST API mediation: " + protocol));
            }
            return false;
        }
        return this.dispatchToAPI(synCtx);
    }

    private boolean dispatchToAPI(MessageContext synCtx) {
        Collection<API> apiSet = synCtx.getEnvironment().getSynapseConfiguration().getAPIs();
        API defaultAPI = null;
        for (API api : apiSet) {
            if ("/".equals(api.getContext())) {
                defaultAPI = api;
                continue;
            }
            if (!api.canProcess(synCtx)) continue;
            if (log.isDebugEnabled()) {
                log.debug((Object)("Located specific API: " + api.getName() + " for processing message"));
            }
            api.process(synCtx);
            return true;
        }
        if (defaultAPI != null && defaultAPI.canProcess(synCtx)) {
            defaultAPI.process(synCtx);
            return true;
        }
        return false;
    }
}

