/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.rest;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.axiom.util.UIDGenerator;
import org.apache.synapse.ManagedLifecycle;
import org.apache.synapse.Mediator;
import org.apache.synapse.MessageContext;
import org.apache.synapse.SynapseException;
import org.apache.synapse.core.SynapseEnvironment;
import org.apache.synapse.core.axis2.Axis2MessageContext;
import org.apache.synapse.core.axis2.Axis2Sender;
import org.apache.synapse.mediators.MediatorFaultHandler;
import org.apache.synapse.mediators.base.SequenceMediator;
import org.apache.synapse.rest.AbstractRESTProcessor;
import org.apache.synapse.rest.RESTConstants;
import org.apache.synapse.rest.RESTUtils;
import org.apache.synapse.rest.dispatch.DispatcherHelper;

public class Resource
extends AbstractRESTProcessor
implements ManagedLifecycle {
    private Set<String> methods = new HashSet<String>(4);
    private String contentType;
    private String userAgent;
    private int protocol = 0;
    private SequenceMediator inSequence;
    private SequenceMediator outSequence;
    private SequenceMediator faultSequence;
    private String inSequenceKey;
    private String outSequenceKey;
    private String faultSequenceKey;
    private DispatcherHelper dispatcherHelper;

    public Resource() {
        super(UIDGenerator.generateUID());
    }

    protected String getName() {
        return this.name;
    }

    public SequenceMediator getInSequence() {
        return this.inSequence;
    }

    public void setInSequence(SequenceMediator inSequence) {
        this.inSequence = inSequence;
    }

    public SequenceMediator getOutSequence() {
        return this.outSequence;
    }

    public void setOutSequence(SequenceMediator outSequence) {
        this.outSequence = outSequence;
    }

    public String getInSequenceKey() {
        return this.inSequenceKey;
    }

    public void setInSequenceKey(String inSequenceKey) {
        this.inSequenceKey = inSequenceKey;
    }

    public String getOutSequenceKey() {
        return this.outSequenceKey;
    }

    public void setOutSequenceKey(String outSequenceKey) {
        this.outSequenceKey = outSequenceKey;
    }

    public SequenceMediator getFaultSequence() {
        return this.faultSequence;
    }

    public void setFaultSequence(SequenceMediator faultSequence) {
        this.faultSequence = faultSequence;
    }

    public String getFaultSequenceKey() {
        return this.faultSequenceKey;
    }

    public void setFaultSequenceKey(String faultSequenceKey) {
        this.faultSequenceKey = faultSequenceKey;
    }

    public boolean addMethod(String method) {
        for (RESTConstants.METHODS allowedMethod : RESTConstants.METHODS.values()) {
            if (!allowedMethod.name().equals(method)) continue;
            this.methods.add(method);
            return true;
        }
        return false;
    }

    public String[] getMethods() {
        return this.methods.toArray(new String[this.methods.size()]);
    }

    public DispatcherHelper getDispatcherHelper() {
        return this.dispatcherHelper;
    }

    public void setDispatcherHelper(DispatcherHelper dispatcherHelper) {
        this.dispatcherHelper = dispatcherHelper;
    }

    public String getContentType() {
        return this.contentType;
    }

    public void setContentType(String contentType) {
        if (contentType.indexOf(47) == -1 || contentType.split("/").length != 2) {
            throw new SynapseException("Invalid content type: " + contentType);
        }
        this.contentType = contentType;
    }

    public String getUserAgent() {
        return this.userAgent;
    }

    public void setUserAgent(String userAgent) {
        this.userAgent = userAgent;
    }

    public int getProtocol() {
        return this.protocol;
    }

    public void setProtocol(int protocol) {
        this.protocol = protocol;
    }

    boolean canProcess(MessageContext synCtx) {
        String agent;
        String type;
        boolean hasPayload;
        if (synCtx.isResponse()) {
            return true;
        }
        org.apache.axis2.context.MessageContext msgCtx = ((Axis2MessageContext)synCtx).getAxis2MessageContext();
        if (this.protocol == 1 && !"http".equals(msgCtx.getIncomingTransportName())) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)"Protocol information does not match - Expected HTTP");
            }
            return false;
        }
        if (this.protocol == 2 && !"https".equals(msgCtx.getIncomingTransportName())) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)"Protocol information does not match - Expected HTTPS");
            }
            return false;
        }
        String method = (String)msgCtx.getProperty("HTTP_METHOD");
        synCtx.setProperty("REST_METHOD", method);
        if ("OPTIONS".equals(method)) {
            return true;
        }
        if (!this.methods.isEmpty() && !this.methods.contains(method)) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)"HTTP method does not match");
            }
            return false;
        }
        Map transportHeaders = (Map)msgCtx.getProperty("TRANSPORT_HEADERS");
        if ((this.contentType != null || this.userAgent != null) && transportHeaders == null) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)"Transport headers not available on the message");
            }
            return false;
        }
        boolean bl = hasPayload = !Boolean.TRUE.equals(msgCtx.getProperty("NO_ENTITY_BODY"));
        if (this.contentType != null && hasPayload && !this.contentType.equals(type = (String)transportHeaders.get("Content-Type"))) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Content type does not match - Expected: " + this.contentType + ", " + "Found: " + type));
            }
            return false;
        }
        if (!(this.userAgent == null || (agent = (String)transportHeaders.get("User-Agent")) != null && agent.matches(this.userAgent))) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("User agent does not match - Expected: " + this.userAgent + ", " + "Found: " + agent));
            }
            return false;
        }
        return true;
    }

    void process(MessageContext synCtx) {
        String sequenceKey;
        SequenceMediator sequence;
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Processing message with ID: " + synCtx.getMessageID() + " through the " + "resource: " + this.name));
        }
        if (!synCtx.isResponse()) {
            String method = (String)synCtx.getProperty("REST_METHOD");
            if ("OPTIONS".equals(method) && this.sendOptions(synCtx)) {
                return;
            }
            synCtx.setProperty("SYNAPSE_RESOURCE", this.name);
            String path = RESTUtils.getFullRequestPath(synCtx);
            int queryIndex = path.indexOf(63);
            if (queryIndex != -1) {
                String[] entries;
                String query = path.substring(queryIndex + 1);
                for (String entry : entries = query.split("&")) {
                    int index = entry.indexOf(61);
                    if (index == -1) continue;
                    try {
                        String name = entry.substring(0, index);
                        String value = URLDecoder.decode(entry.substring(index + 1), "UTF-8");
                        synCtx.setProperty("query.param." + name, value);
                    }
                    catch (UnsupportedEncodingException ignored) {
                        // empty catch block
                    }
                }
            }
        }
        SequenceMediator sequenceMediator = sequence = synCtx.isResponse() ? this.outSequence : this.inSequence;
        if (sequence != null) {
            this.registerFaultHandler(synCtx);
            sequence.mediate(synCtx);
            return;
        }
        String string = sequenceKey = synCtx.isResponse() ? this.outSequenceKey : this.inSequenceKey;
        if (sequenceKey != null) {
            this.registerFaultHandler(synCtx);
            Mediator referredSequence = synCtx.getSequence(sequenceKey);
            if (referredSequence == null) {
                throw new SynapseException("Specified sequence: " + sequenceKey + " cannot " + "be found");
            }
            referredSequence.mediate(synCtx);
            return;
        }
        if (synCtx.isResponse()) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)"No out-sequence configured. Sending the response back.");
            }
            this.registerFaultHandler(synCtx);
            Axis2Sender.sendBack(synCtx);
        } else if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"No in-sequence configured. Dropping the request.");
        }
    }

    private void registerFaultHandler(MessageContext synCtx) {
        if (this.faultSequence != null) {
            synCtx.pushFaultHandler(new MediatorFaultHandler(this.faultSequence));
        } else if (this.faultSequenceKey != null) {
            Mediator faultSequence = synCtx.getSequence(this.faultSequenceKey);
            if (faultSequence != null) {
                synCtx.pushFaultHandler(new MediatorFaultHandler(faultSequence));
            } else {
                synCtx.pushFaultHandler(new MediatorFaultHandler(synCtx.getFaultSequence()));
            }
        } else {
            synCtx.pushFaultHandler(new MediatorFaultHandler(synCtx.getFaultSequence()));
        }
    }

    private boolean sendOptions(MessageContext synCtx) {
        org.apache.axis2.context.MessageContext msgCtx = ((Axis2MessageContext)synCtx).getAxis2MessageContext();
        Map transportHeaders = (Map)msgCtx.getProperty("TRANSPORT_HEADERS");
        if (this.methods.contains("OPTIONS")) {
            String maxForwardsHeader = (String)transportHeaders.get("Max-Forwards");
            if (maxForwardsHeader != null) {
                int maxForwards = Integer.parseInt(maxForwardsHeader);
                if (maxForwards == 0) {
                    synCtx.setResponse(true);
                    synCtx.setTo(null);
                    transportHeaders.put("Allow", this.getSupportedMethods());
                    Axis2Sender.sendBack(synCtx);
                    return true;
                }
                transportHeaders.put("Max-Forwards", String.valueOf(maxForwards - 1));
            }
            return false;
        }
        synCtx.setResponse(true);
        synCtx.setTo(null);
        transportHeaders.put("Allow", this.getSupportedMethods());
        Axis2Sender.sendBack(synCtx);
        return true;
    }

    private String getSupportedMethods() {
        String value = "";
        if (this.methods.isEmpty()) {
            value = "GET, POST, PUT, DELETE";
        } else {
            for (String method : this.methods) {
                if ("OPTIONS".equals(method)) continue;
                if (value.length() > 0) {
                    value = value + ", ";
                }
                value = value + method;
            }
        }
        return value;
    }

    public void init(SynapseEnvironment se) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Initializing resource with ID: " + this.name));
        }
        if (this.inSequence != null) {
            this.inSequence.init(se);
        }
        if (this.outSequence != null) {
            this.outSequence.init(se);
        }
        if (this.faultSequence != null) {
            this.faultSequence.init(se);
        }
    }

    public void destroy() {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Destroying resource with ID: " + this.name));
        }
        if (this.inSequence != null && this.inSequence.isInitialized()) {
            this.inSequence.destroy();
        }
        if (this.outSequence != null && this.outSequence.isInitialized()) {
            this.outSequence.destroy();
        }
        if (this.faultSequence != null && this.faultSequence.isInitialized()) {
            this.faultSequence.destroy();
        }
    }
}

