/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.rest.dispatch;

import org.apache.synapse.rest.RESTUtils;
import org.apache.synapse.rest.dispatch.DispatcherHelper;

public class URLMappingHelper
implements DispatcherHelper {
    private String[] pathSegments;
    private String extension;
    private String exactMatch;

    public URLMappingHelper(String urlMapping) {
        if (urlMapping.startsWith("/") && urlMapping.endsWith("/*")) {
            this.pathSegments = urlMapping.length() > 2 ? urlMapping.substring(1, urlMapping.length() - 2).split("/") : new String[0];
        } else if (urlMapping.startsWith("*.")) {
            this.extension = urlMapping.substring(1);
        } else {
            this.exactMatch = urlMapping;
        }
    }

    public boolean isExactMatch(String url) {
        if (!"/".equals(url)) {
            url = RESTUtils.trimTrailingSlashes(url);
        }
        return this.exactMatch != null && this.exactMatch.equals(url);
    }

    public boolean isExtensionMatch(String url) {
        int index = url.indexOf(63);
        if (index != -1) {
            url = url.substring(0, index);
        }
        return this.extension != null && url.endsWith(this.extension);
    }

    public int getPrefixMatchingLength(String url) {
        if (this.pathSegments != null) {
            if (this.pathSegments.length == 0) {
                return 1;
            }
            url = RESTUtils.trimSlashes(url);
            String[] segments = url.split("/");
            int matchingLength = 0;
            for (int i = 0; i < this.pathSegments.length; ++i) {
                if (segments.length > i) {
                    if (segments[i].equals(this.pathSegments[i])) {
                        ++matchingLength;
                        continue;
                    }
                    return 0;
                }
                return 0;
            }
            return matchingLength;
        }
        return 0;
    }

    public String getString() {
        if (this.pathSegments != null) {
            String str = "";
            for (String segment : this.pathSegments) {
                str = str + "/" + segment;
            }
            return str + "/*";
        }
        if (this.extension != null) {
            return "*." + this.extension;
        }
        return this.exactMatch;
    }
}

